<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Expense_Central_Travel_Card_Transaction_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Assign Central Travel Card Transaction Assignment Request Element
 * @subpackage Structs
 */
class Assign_Expense_Central_Travel_Card_Transaction_RequestType extends AbstractStructBase
{
    /**
     * The Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference to credit card transaction.
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Credit_Card_Transaction_Reference;
    /**
     * The Expense_Credit_Card_Transaction_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing the assignee data
     * @var \StructType\Expense_Central_Travel_Card_Transaction_DataType
     */
    public $Expense_Credit_Card_Transaction_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for
     * Assign_Expense_Central_Travel_Card_Transaction_RequestType
     * @uses Assign_Expense_Central_Travel_Card_Transaction_RequestType::setCredit_Card_Transaction_Reference()
     * @uses Assign_Expense_Central_Travel_Card_Transaction_RequestType::setExpense_Credit_Card_Transaction_Data()
     * @uses Assign_Expense_Central_Travel_Card_Transaction_RequestType::setVersion()
     * @param \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference
     * @param \StructType\Expense_Central_Travel_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data
     * @param string $version
     */
    public function __construct(\StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference = null, \StructType\Expense_Central_Travel_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data = null, $version = null)
    {
        $this
            ->setCredit_Card_Transaction_Reference($credit_Card_Transaction_Reference)
            ->setExpense_Credit_Card_Transaction_Data($expense_Credit_Card_Transaction_Data)
            ->setVersion($version);
    }
    /**
     * Get Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getCredit_Card_Transaction_Reference()
    {
        return $this->Credit_Card_Transaction_Reference;
    }
    /**
     * Set Credit_Card_Transaction_Reference value
     * @param \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference
     * @return \StructType\Assign_Expense_Central_Travel_Card_Transaction_RequestType
     */
    public function setCredit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference = null)
    {
        $this->Credit_Card_Transaction_Reference = $credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Transaction_Data value
     * @return \StructType\Expense_Central_Travel_Card_Transaction_DataType|null
     */
    public function getExpense_Credit_Card_Transaction_Data()
    {
        return $this->Expense_Credit_Card_Transaction_Data;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Data value
     * @param \StructType\Expense_Central_Travel_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data
     * @return \StructType\Assign_Expense_Central_Travel_Card_Transaction_RequestType
     */
    public function setExpense_Credit_Card_Transaction_Data(\StructType\Expense_Central_Travel_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data = null)
    {
        $this->Expense_Credit_Card_Transaction_Data = $expense_Credit_Card_Transaction_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Assign_Expense_Central_Travel_Card_Transaction_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
