<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_Snapshot_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Worktag Split Template Snapshot Data
 * @subpackage Structs
 */
class Worktag_Split_Template_Snapshot_DataType extends AbstractStructBase
{
    /**
     * The Worktag_Split_Template_Snapshot_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Snapshot Reference
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_Template_SnapshotObjectType
     */
    public $Worktag_Split_Template_Snapshot_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Snapshot Effective Date
     * - maxOccurs: 1
     * @var string
     */
    public $Effective_Date;
    /**
     * The Worktag_Split_Template_Item_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Worktag_Split_Template_Item_DataType[]
     */
    public $Worktag_Split_Template_Item_Data;
    /**
     * Constructor method for Worktag_Split_Template_Snapshot_DataType
     * @uses Worktag_Split_Template_Snapshot_DataType::setWorktag_Split_Template_Snapshot_Reference()
     * @uses Worktag_Split_Template_Snapshot_DataType::setEffective_Date()
     * @uses Worktag_Split_Template_Snapshot_DataType::setWorktag_Split_Template_Item_Data()
     * @param \StructType\Worktag_Split_Template_SnapshotObjectType $worktag_Split_Template_Snapshot_Reference
     * @param string $effective_Date
     * @param \StructType\Worktag_Split_Template_Item_DataType[] $worktag_Split_Template_Item_Data
     */
    public function __construct(\StructType\Worktag_Split_Template_SnapshotObjectType $worktag_Split_Template_Snapshot_Reference = null, $effective_Date = null, array $worktag_Split_Template_Item_Data = array())
    {
        $this
            ->setWorktag_Split_Template_Snapshot_Reference($worktag_Split_Template_Snapshot_Reference)
            ->setEffective_Date($effective_Date)
            ->setWorktag_Split_Template_Item_Data($worktag_Split_Template_Item_Data);
    }
    /**
     * Get Worktag_Split_Template_Snapshot_Reference value
     * @return \StructType\Worktag_Split_Template_SnapshotObjectType|null
     */
    public function getWorktag_Split_Template_Snapshot_Reference()
    {
        return $this->Worktag_Split_Template_Snapshot_Reference;
    }
    /**
     * Set Worktag_Split_Template_Snapshot_Reference value
     * @param \StructType\Worktag_Split_Template_SnapshotObjectType $worktag_Split_Template_Snapshot_Reference
     * @return \StructType\Worktag_Split_Template_Snapshot_DataType
     */
    public function setWorktag_Split_Template_Snapshot_Reference(\StructType\Worktag_Split_Template_SnapshotObjectType $worktag_Split_Template_Snapshot_Reference = null)
    {
        $this->Worktag_Split_Template_Snapshot_Reference = $worktag_Split_Template_Snapshot_Reference;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Worktag_Split_Template_Snapshot_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Item_Data value
     * @return \StructType\Worktag_Split_Template_Item_DataType[]|null
     */
    public function getWorktag_Split_Template_Item_Data()
    {
        return $this->Worktag_Split_Template_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Split_Template_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Split_Template_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_Split_Template_Item_DataForArrayConstraintsFromSetWorktag_Split_Template_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_Snapshot_DataTypeWorktag_Split_Template_Item_DataItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_Snapshot_DataTypeWorktag_Split_Template_Item_DataItem instanceof \StructType\Worktag_Split_Template_Item_DataType) {
                $invalidValues[] = is_object($worktag_Split_Template_Snapshot_DataTypeWorktag_Split_Template_Item_DataItem) ? get_class($worktag_Split_Template_Snapshot_DataTypeWorktag_Split_Template_Item_DataItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_Snapshot_DataTypeWorktag_Split_Template_Item_DataItem), var_export($worktag_Split_Template_Snapshot_DataTypeWorktag_Split_Template_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Split_Template_Item_Data property can only contain items of type \StructType\Worktag_Split_Template_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Split_Template_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worktag_Split_Template_Item_DataType[] $worktag_Split_Template_Item_Data
     * @return \StructType\Worktag_Split_Template_Snapshot_DataType
     */
    public function setWorktag_Split_Template_Item_Data(array $worktag_Split_Template_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_Split_Template_Item_DataArrayErrorMessage = self::validateWorktag_Split_Template_Item_DataForArrayConstraintsFromSetWorktag_Split_Template_Item_Data($worktag_Split_Template_Item_Data))) {
            throw new \InvalidArgumentException($worktag_Split_Template_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Split_Template_Item_Data = $worktag_Split_Template_Item_Data;
        return $this;
    }
    /**
     * Add item to Worktag_Split_Template_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worktag_Split_Template_Item_DataType $item
     * @return \StructType\Worktag_Split_Template_Snapshot_DataType
     */
    public function addToWorktag_Split_Template_Item_Data(\StructType\Worktag_Split_Template_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worktag_Split_Template_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Split_Template_Item_Data property can only contain items of type \StructType\Worktag_Split_Template_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Split_Template_Item_Data[] = $item;
        return $this;
    }
}
