<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for Worktag Split Template
 * @subpackage Structs
 */
class Worktag_Split_Template_DataType extends AbstractStructBase
{
    /**
     * The Worktag_Split_Template_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for Worktag Split Template Data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worktag_Split_Template_ID;
    /**
     * The Template_Name
     * Meta information extracted from the WSDL
     * - documentation: Name for Worktag Split Template
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Template_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Criteria Active or Inactive Status
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Worktag_Split_Template_Restriction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template filtered by Worktag Split Template Restriction
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_Template_CriteriaObjectType
     */
    public $Worktag_Split_Template_Restriction_Reference;
    /**
     * The Worktag_Split_Template_Sharing_Data
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Sharing Options
     * @var \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public $Worktag_Split_Template_Sharing_Data;
    /**
     * The Worktag_Split_Template_Version_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_Template_Snapshot_DataType[]
     */
    public $Worktag_Split_Template_Version_Data;
    /**
     * Constructor method for Worktag_Split_Template_DataType
     * @uses Worktag_Split_Template_DataType::setWorktag_Split_Template_ID()
     * @uses Worktag_Split_Template_DataType::setTemplate_Name()
     * @uses Worktag_Split_Template_DataType::setInactive()
     * @uses Worktag_Split_Template_DataType::setWorktag_Split_Template_Restriction_Reference()
     * @uses Worktag_Split_Template_DataType::setWorktag_Split_Template_Sharing_Data()
     * @uses Worktag_Split_Template_DataType::setWorktag_Split_Template_Version_Data()
     * @param string $worktag_Split_Template_ID
     * @param string $template_Name
     * @param bool $inactive
     * @param \StructType\Worktag_Split_Template_CriteriaObjectType $worktag_Split_Template_Restriction_Reference
     * @param \StructType\Worktag_Split_Template_Sharing_DataType $worktag_Split_Template_Sharing_Data
     * @param \StructType\Worktag_Split_Template_Snapshot_DataType[] $worktag_Split_Template_Version_Data
     */
    public function __construct($worktag_Split_Template_ID = null, $template_Name = null, $inactive = null, \StructType\Worktag_Split_Template_CriteriaObjectType $worktag_Split_Template_Restriction_Reference = null, \StructType\Worktag_Split_Template_Sharing_DataType $worktag_Split_Template_Sharing_Data = null, array $worktag_Split_Template_Version_Data = array())
    {
        $this
            ->setWorktag_Split_Template_ID($worktag_Split_Template_ID)
            ->setTemplate_Name($template_Name)
            ->setInactive($inactive)
            ->setWorktag_Split_Template_Restriction_Reference($worktag_Split_Template_Restriction_Reference)
            ->setWorktag_Split_Template_Sharing_Data($worktag_Split_Template_Sharing_Data)
            ->setWorktag_Split_Template_Version_Data($worktag_Split_Template_Version_Data);
    }
    /**
     * Get Worktag_Split_Template_ID value
     * @return string|null
     */
    public function getWorktag_Split_Template_ID()
    {
        return $this->Worktag_Split_Template_ID;
    }
    /**
     * Set Worktag_Split_Template_ID value
     * @param string $worktag_Split_Template_ID
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function setWorktag_Split_Template_ID($worktag_Split_Template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($worktag_Split_Template_ID) && !is_string($worktag_Split_Template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worktag_Split_Template_ID, true), gettype($worktag_Split_Template_ID)), __LINE__);
        }
        $this->Worktag_Split_Template_ID = $worktag_Split_Template_ID;
        return $this;
    }
    /**
     * Get Template_Name value
     * @return string|null
     */
    public function getTemplate_Name()
    {
        return $this->Template_Name;
    }
    /**
     * Set Template_Name value
     * @param string $template_Name
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function setTemplate_Name($template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Name) && !is_string($template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Name, true), gettype($template_Name)), __LINE__);
        }
        $this->Template_Name = $template_Name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Restriction_Reference value
     * @return \StructType\Worktag_Split_Template_CriteriaObjectType|null
     */
    public function getWorktag_Split_Template_Restriction_Reference()
    {
        return $this->Worktag_Split_Template_Restriction_Reference;
    }
    /**
     * Set Worktag_Split_Template_Restriction_Reference value
     * @param \StructType\Worktag_Split_Template_CriteriaObjectType $worktag_Split_Template_Restriction_Reference
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function setWorktag_Split_Template_Restriction_Reference(\StructType\Worktag_Split_Template_CriteriaObjectType $worktag_Split_Template_Restriction_Reference = null)
    {
        $this->Worktag_Split_Template_Restriction_Reference = $worktag_Split_Template_Restriction_Reference;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Sharing_Data value
     * @return \StructType\Worktag_Split_Template_Sharing_DataType|null
     */
    public function getWorktag_Split_Template_Sharing_Data()
    {
        return $this->Worktag_Split_Template_Sharing_Data;
    }
    /**
     * Set Worktag_Split_Template_Sharing_Data value
     * @param \StructType\Worktag_Split_Template_Sharing_DataType $worktag_Split_Template_Sharing_Data
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function setWorktag_Split_Template_Sharing_Data(\StructType\Worktag_Split_Template_Sharing_DataType $worktag_Split_Template_Sharing_Data = null)
    {
        $this->Worktag_Split_Template_Sharing_Data = $worktag_Split_Template_Sharing_Data;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Version_Data value
     * @return \StructType\Worktag_Split_Template_Snapshot_DataType[]|null
     */
    public function getWorktag_Split_Template_Version_Data()
    {
        return $this->Worktag_Split_Template_Version_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Split_Template_Version_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Split_Template_Version_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_Split_Template_Version_DataForArrayConstraintsFromSetWorktag_Split_Template_Version_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_DataTypeWorktag_Split_Template_Version_DataItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_DataTypeWorktag_Split_Template_Version_DataItem instanceof \StructType\Worktag_Split_Template_Snapshot_DataType) {
                $invalidValues[] = is_object($worktag_Split_Template_DataTypeWorktag_Split_Template_Version_DataItem) ? get_class($worktag_Split_Template_DataTypeWorktag_Split_Template_Version_DataItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_DataTypeWorktag_Split_Template_Version_DataItem), var_export($worktag_Split_Template_DataTypeWorktag_Split_Template_Version_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Split_Template_Version_Data property can only contain items of type \StructType\Worktag_Split_Template_Snapshot_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Split_Template_Version_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worktag_Split_Template_Snapshot_DataType[] $worktag_Split_Template_Version_Data
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function setWorktag_Split_Template_Version_Data(array $worktag_Split_Template_Version_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_Split_Template_Version_DataArrayErrorMessage = self::validateWorktag_Split_Template_Version_DataForArrayConstraintsFromSetWorktag_Split_Template_Version_Data($worktag_Split_Template_Version_Data))) {
            throw new \InvalidArgumentException($worktag_Split_Template_Version_DataArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Split_Template_Version_Data = $worktag_Split_Template_Version_Data;
        return $this;
    }
    /**
     * Add item to Worktag_Split_Template_Version_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worktag_Split_Template_Snapshot_DataType $item
     * @return \StructType\Worktag_Split_Template_DataType
     */
    public function addToWorktag_Split_Template_Version_Data(\StructType\Worktag_Split_Template_Snapshot_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worktag_Split_Template_Snapshot_DataType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Split_Template_Version_Data property can only contain items of type \StructType\Worktag_Split_Template_Snapshot_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Split_Template_Version_Data[] = $item;
        return $this;
    }
}
