<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing unnamed resource data.
 * @subpackage Structs
 */
class Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType extends AbstractStructBase
{
    /**
     * The Unnamed_Resource_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Contains a unique identifier for an instance of unnamed resource.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unnamed_Resource_Reference_ID;
    /**
     * The Sequence
     * Meta information extracted from the WSDL
     * - documentation: Sequential number of the unnamed resources by role within a resource plan. | The sequence of unnamed resource associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Sequence;
    /**
     * Constructor method for Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType
     * @uses Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType::setUnnamed_Resource_Reference_ID()
     * @uses Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType::setSequence()
     * @param string $unnamed_Resource_Reference_ID
     * @param float $sequence
     */
    public function __construct($unnamed_Resource_Reference_ID = null, $sequence = null)
    {
        $this
            ->setUnnamed_Resource_Reference_ID($unnamed_Resource_Reference_ID)
            ->setSequence($sequence);
    }
    /**
     * Get Unnamed_Resource_Reference_ID value
     * @return string|null
     */
    public function getUnnamed_Resource_Reference_ID()
    {
        return $this->Unnamed_Resource_Reference_ID;
    }
    /**
     * Set Unnamed_Resource_Reference_ID value
     * @param string $unnamed_Resource_Reference_ID
     * @return \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType
     */
    public function setUnnamed_Resource_Reference_ID($unnamed_Resource_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($unnamed_Resource_Reference_ID) && !is_string($unnamed_Resource_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unnamed_Resource_Reference_ID, true), gettype($unnamed_Resource_Reference_ID)), __LINE__);
        }
        $this->Unnamed_Resource_Reference_ID = $unnamed_Resource_Reference_ID;
        return $this;
    }
    /**
     * Get Sequence value
     * @return float|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param float $sequence
     * @return \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: float
        if (!is_null($sequence) && !(is_float($sequence) || is_numeric($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($sequence) && mb_strlen(mb_substr($sequence, false !== mb_strpos($sequence, '.') ? mb_strpos($sequence, '.') + 1 : mb_strlen($sequence))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($sequence, true), mb_strlen(mb_substr($sequence, mb_strpos($sequence, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sequence) && $sequence < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sequence, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($sequence) && mb_strlen(preg_replace('/(\D)/', '', $sequence)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($sequence, true), mb_strlen(preg_replace('/(\D)/', '', $sequence))), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
}
