<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trip_Leg_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Trip Leg Details Data
 * @subpackage Structs
 */
class Trip_Leg_Details_DataType extends AbstractStructBase
{
    /**
     * The Trip_Leg_Details_Id
     * Meta information extracted from the WSDL
     * - documentation: Trip Leg Details ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trip_Leg_Details_Id;
    /**
     * The Arrival_Date
     * Meta information extracted from the WSDL
     * - documentation: Arrival Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Arrival_Date;
    /**
     * The Arrival_Time
     * Meta information extracted from the WSDL
     * - documentation: The time of arrival in the local time zone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Arrival_Time;
    /**
     * The Carrier_Code
     * Meta information extracted from the WSDL
     * - documentation: Carrier Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_Code;
    /**
     * The Carrier_Number
     * Meta information extracted from the WSDL
     * - documentation: Carrier Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_Number;
    /**
     * The Class_of_Service
     * Meta information extracted from the WSDL
     * - documentation: Class of Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Class_of_Service;
    /**
     * The Class_of_Service_Reference
     * Meta information extracted from the WSDL
     * - documentation: Class of Service
     * - minOccurs: 0
     * @var \StructType\Class_of_ServiceObjectType
     */
    public $Class_of_Service_Reference;
    /**
     * The Conjunction_Ticket
     * Meta information extracted from the WSDL
     * - documentation: A ticket issued to report additional trip legs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Conjunction_Ticket;
    /**
     * The Coupon_Number
     * Meta information extracted from the WSDL
     * - documentation: The coupon number used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Coupon_Number;
    /**
     * The Departure_Time
     * Meta information extracted from the WSDL
     * - documentation: Time of the departure for this flight in local time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Departure_Time;
    /**
     * The Departure_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Departure Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Departure_Tax_Amount;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - documentation: Destination
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination;
    /**
     * The Destination_Reference
     * Meta information extracted from the WSDL
     * - documentation: Destination
     * - minOccurs: 0
     * @var \StructType\AirportObjectType
     */
    public $Destination_Reference;
    /**
     * The Endorsements
     * Meta information extracted from the WSDL
     * - documentation: The travel agency added notations or mandatory government notations or restrictions set on the ticket due to the fare type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Endorsements;
    /**
     * The Exchange_Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: The exchanged ticket number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Exchange_Ticket_Number;
    /**
     * The Fare_Base
     * Meta information extracted from the WSDL
     * - documentation: Fare Basis Code Value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fare_Base;
    /**
     * The Leg_Number
     * Meta information extracted from the WSDL
     * - documentation: Leg Number
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Leg_Number;
    /**
     * The Stopover_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Code indicating whether the destination is a connection point or a final destination for one segment of air travel or for one segment of rail travel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Stopover_Indicator;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - documentation: Origination
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The Origination_Reference
     * Meta information extracted from the WSDL
     * - documentation: Origination
     * - minOccurs: 0
     * @var \StructType\AirportObjectType
     */
    public $Origination_Reference;
    /**
     * The Travel_Date
     * Meta information extracted from the WSDL
     * - documentation: The date for start of travel for this leg.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Date;
    /**
     * The Trip_Leg_Fare_Amount
     * Meta information extracted from the WSDL
     * - documentation: Trip Leg Fare Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Trip_Leg_Fare_Amount;
    /**
     * The Trip_Leg_Fee_Amount
     * Meta information extracted from the WSDL
     * - documentation: Trip Leg Fee Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Trip_Leg_Fee_Amount;
    /**
     * The Trip_Leg_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Trip Leg Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Trip_Leg_Tax_Amount;
    /**
     * The Refund_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Leg Level Refund Indicator
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Refund_Indicator;
    /**
     * The Trip_Leg_Details_Name_Match_Data
     * Meta information extracted from the WSDL
     * - documentation: Trip Leg Details Name Match Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Trip_Leg_Details_Name_Match_DataType[]
     */
    public $Trip_Leg_Details_Name_Match_Data;
    /**
     * Constructor method for Trip_Leg_Details_DataType
     * @uses Trip_Leg_Details_DataType::setTrip_Leg_Details_Id()
     * @uses Trip_Leg_Details_DataType::setArrival_Date()
     * @uses Trip_Leg_Details_DataType::setArrival_Time()
     * @uses Trip_Leg_Details_DataType::setCarrier_Code()
     * @uses Trip_Leg_Details_DataType::setCarrier_Number()
     * @uses Trip_Leg_Details_DataType::setClass_of_Service()
     * @uses Trip_Leg_Details_DataType::setClass_of_Service_Reference()
     * @uses Trip_Leg_Details_DataType::setConjunction_Ticket()
     * @uses Trip_Leg_Details_DataType::setCoupon_Number()
     * @uses Trip_Leg_Details_DataType::setDeparture_Time()
     * @uses Trip_Leg_Details_DataType::setDeparture_Tax_Amount()
     * @uses Trip_Leg_Details_DataType::setDestination()
     * @uses Trip_Leg_Details_DataType::setDestination_Reference()
     * @uses Trip_Leg_Details_DataType::setEndorsements()
     * @uses Trip_Leg_Details_DataType::setExchange_Ticket_Number()
     * @uses Trip_Leg_Details_DataType::setFare_Base()
     * @uses Trip_Leg_Details_DataType::setLeg_Number()
     * @uses Trip_Leg_Details_DataType::setStopover_Indicator()
     * @uses Trip_Leg_Details_DataType::setOrigin()
     * @uses Trip_Leg_Details_DataType::setOrigination_Reference()
     * @uses Trip_Leg_Details_DataType::setTravel_Date()
     * @uses Trip_Leg_Details_DataType::setTrip_Leg_Fare_Amount()
     * @uses Trip_Leg_Details_DataType::setTrip_Leg_Fee_Amount()
     * @uses Trip_Leg_Details_DataType::setTrip_Leg_Tax_Amount()
     * @uses Trip_Leg_Details_DataType::setRefund_Indicator()
     * @uses Trip_Leg_Details_DataType::setTrip_Leg_Details_Name_Match_Data()
     * @param string $trip_Leg_Details_Id
     * @param string $arrival_Date
     * @param string $arrival_Time
     * @param string $carrier_Code
     * @param string $carrier_Number
     * @param string $class_of_Service
     * @param \StructType\Class_of_ServiceObjectType $class_of_Service_Reference
     * @param string $conjunction_Ticket
     * @param string $coupon_Number
     * @param string $departure_Time
     * @param float $departure_Tax_Amount
     * @param string $destination
     * @param \StructType\AirportObjectType $destination_Reference
     * @param string $endorsements
     * @param string $exchange_Ticket_Number
     * @param string $fare_Base
     * @param float $leg_Number
     * @param string $stopover_Indicator
     * @param string $origin
     * @param \StructType\AirportObjectType $origination_Reference
     * @param string $travel_Date
     * @param float $trip_Leg_Fare_Amount
     * @param float $trip_Leg_Fee_Amount
     * @param float $trip_Leg_Tax_Amount
     * @param bool $refund_Indicator
     * @param \StructType\Trip_Leg_Details_Name_Match_DataType[] $trip_Leg_Details_Name_Match_Data
     */
    public function __construct($trip_Leg_Details_Id = null, $arrival_Date = null, $arrival_Time = null, $carrier_Code = null, $carrier_Number = null, $class_of_Service = null, \StructType\Class_of_ServiceObjectType $class_of_Service_Reference = null, $conjunction_Ticket = null, $coupon_Number = null, $departure_Time = null, $departure_Tax_Amount = null, $destination = null, \StructType\AirportObjectType $destination_Reference = null, $endorsements = null, $exchange_Ticket_Number = null, $fare_Base = null, $leg_Number = null, $stopover_Indicator = null, $origin = null, \StructType\AirportObjectType $origination_Reference = null, $travel_Date = null, $trip_Leg_Fare_Amount = null, $trip_Leg_Fee_Amount = null, $trip_Leg_Tax_Amount = null, $refund_Indicator = null, array $trip_Leg_Details_Name_Match_Data = array())
    {
        $this
            ->setTrip_Leg_Details_Id($trip_Leg_Details_Id)
            ->setArrival_Date($arrival_Date)
            ->setArrival_Time($arrival_Time)
            ->setCarrier_Code($carrier_Code)
            ->setCarrier_Number($carrier_Number)
            ->setClass_of_Service($class_of_Service)
            ->setClass_of_Service_Reference($class_of_Service_Reference)
            ->setConjunction_Ticket($conjunction_Ticket)
            ->setCoupon_Number($coupon_Number)
            ->setDeparture_Time($departure_Time)
            ->setDeparture_Tax_Amount($departure_Tax_Amount)
            ->setDestination($destination)
            ->setDestination_Reference($destination_Reference)
            ->setEndorsements($endorsements)
            ->setExchange_Ticket_Number($exchange_Ticket_Number)
            ->setFare_Base($fare_Base)
            ->setLeg_Number($leg_Number)
            ->setStopover_Indicator($stopover_Indicator)
            ->setOrigin($origin)
            ->setOrigination_Reference($origination_Reference)
            ->setTravel_Date($travel_Date)
            ->setTrip_Leg_Fare_Amount($trip_Leg_Fare_Amount)
            ->setTrip_Leg_Fee_Amount($trip_Leg_Fee_Amount)
            ->setTrip_Leg_Tax_Amount($trip_Leg_Tax_Amount)
            ->setRefund_Indicator($refund_Indicator)
            ->setTrip_Leg_Details_Name_Match_Data($trip_Leg_Details_Name_Match_Data);
    }
    /**
     * Get Trip_Leg_Details_Id value
     * @return string|null
     */
    public function getTrip_Leg_Details_Id()
    {
        return $this->Trip_Leg_Details_Id;
    }
    /**
     * Set Trip_Leg_Details_Id value
     * @param string $trip_Leg_Details_Id
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setTrip_Leg_Details_Id($trip_Leg_Details_Id = null)
    {
        // validation for constraint: string
        if (!is_null($trip_Leg_Details_Id) && !is_string($trip_Leg_Details_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trip_Leg_Details_Id, true), gettype($trip_Leg_Details_Id)), __LINE__);
        }
        $this->Trip_Leg_Details_Id = $trip_Leg_Details_Id;
        return $this;
    }
    /**
     * Get Arrival_Date value
     * @return string|null
     */
    public function getArrival_Date()
    {
        return $this->Arrival_Date;
    }
    /**
     * Set Arrival_Date value
     * @param string $arrival_Date
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setArrival_Date($arrival_Date = null)
    {
        // validation for constraint: string
        if (!is_null($arrival_Date) && !is_string($arrival_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival_Date, true), gettype($arrival_Date)), __LINE__);
        }
        $this->Arrival_Date = $arrival_Date;
        return $this;
    }
    /**
     * Get Arrival_Time value
     * @return string|null
     */
    public function getArrival_Time()
    {
        return $this->Arrival_Time;
    }
    /**
     * Set Arrival_Time value
     * @param string $arrival_Time
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setArrival_Time($arrival_Time = null)
    {
        // validation for constraint: string
        if (!is_null($arrival_Time) && !is_string($arrival_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival_Time, true), gettype($arrival_Time)), __LINE__);
        }
        $this->Arrival_Time = $arrival_Time;
        return $this;
    }
    /**
     * Get Carrier_Code value
     * @return string|null
     */
    public function getCarrier_Code()
    {
        return $this->Carrier_Code;
    }
    /**
     * Set Carrier_Code value
     * @param string $carrier_Code
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setCarrier_Code($carrier_Code = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Code) && !is_string($carrier_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Code, true), gettype($carrier_Code)), __LINE__);
        }
        $this->Carrier_Code = $carrier_Code;
        return $this;
    }
    /**
     * Get Carrier_Number value
     * @return string|null
     */
    public function getCarrier_Number()
    {
        return $this->Carrier_Number;
    }
    /**
     * Set Carrier_Number value
     * @param string $carrier_Number
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setCarrier_Number($carrier_Number = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Number) && !is_string($carrier_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Number, true), gettype($carrier_Number)), __LINE__);
        }
        $this->Carrier_Number = $carrier_Number;
        return $this;
    }
    /**
     * Get Class_of_Service value
     * @return string|null
     */
    public function getClass_of_Service()
    {
        return $this->Class_of_Service;
    }
    /**
     * Set Class_of_Service value
     * @param string $class_of_Service
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setClass_of_Service($class_of_Service = null)
    {
        // validation for constraint: string
        if (!is_null($class_of_Service) && !is_string($class_of_Service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class_of_Service, true), gettype($class_of_Service)), __LINE__);
        }
        $this->Class_of_Service = $class_of_Service;
        return $this;
    }
    /**
     * Get Class_of_Service_Reference value
     * @return \StructType\Class_of_ServiceObjectType|null
     */
    public function getClass_of_Service_Reference()
    {
        return $this->Class_of_Service_Reference;
    }
    /**
     * Set Class_of_Service_Reference value
     * @param \StructType\Class_of_ServiceObjectType $class_of_Service_Reference
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setClass_of_Service_Reference(\StructType\Class_of_ServiceObjectType $class_of_Service_Reference = null)
    {
        $this->Class_of_Service_Reference = $class_of_Service_Reference;
        return $this;
    }
    /**
     * Get Conjunction_Ticket value
     * @return string|null
     */
    public function getConjunction_Ticket()
    {
        return $this->Conjunction_Ticket;
    }
    /**
     * Set Conjunction_Ticket value
     * @param string $conjunction_Ticket
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setConjunction_Ticket($conjunction_Ticket = null)
    {
        // validation for constraint: string
        if (!is_null($conjunction_Ticket) && !is_string($conjunction_Ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conjunction_Ticket, true), gettype($conjunction_Ticket)), __LINE__);
        }
        $this->Conjunction_Ticket = $conjunction_Ticket;
        return $this;
    }
    /**
     * Get Coupon_Number value
     * @return string|null
     */
    public function getCoupon_Number()
    {
        return $this->Coupon_Number;
    }
    /**
     * Set Coupon_Number value
     * @param string $coupon_Number
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setCoupon_Number($coupon_Number = null)
    {
        // validation for constraint: string
        if (!is_null($coupon_Number) && !is_string($coupon_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coupon_Number, true), gettype($coupon_Number)), __LINE__);
        }
        $this->Coupon_Number = $coupon_Number;
        return $this;
    }
    /**
     * Get Departure_Time value
     * @return string|null
     */
    public function getDeparture_Time()
    {
        return $this->Departure_Time;
    }
    /**
     * Set Departure_Time value
     * @param string $departure_Time
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setDeparture_Time($departure_Time = null)
    {
        // validation for constraint: string
        if (!is_null($departure_Time) && !is_string($departure_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure_Time, true), gettype($departure_Time)), __LINE__);
        }
        $this->Departure_Time = $departure_Time;
        return $this;
    }
    /**
     * Get Departure_Tax_Amount value
     * @return float|null
     */
    public function getDeparture_Tax_Amount()
    {
        return $this->Departure_Tax_Amount;
    }
    /**
     * Set Departure_Tax_Amount value
     * @param float $departure_Tax_Amount
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setDeparture_Tax_Amount($departure_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($departure_Tax_Amount) && !(is_float($departure_Tax_Amount) || is_numeric($departure_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($departure_Tax_Amount, true), gettype($departure_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($departure_Tax_Amount) && mb_strlen(mb_substr($departure_Tax_Amount, false !== mb_strpos($departure_Tax_Amount, '.') ? mb_strpos($departure_Tax_Amount, '.') + 1 : mb_strlen($departure_Tax_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($departure_Tax_Amount, true), mb_strlen(mb_substr($departure_Tax_Amount, mb_strpos($departure_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($departure_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $departure_Tax_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($departure_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $departure_Tax_Amount))), __LINE__);
        }
        $this->Departure_Tax_Amount = $departure_Tax_Amount;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Destination_Reference value
     * @return \StructType\AirportObjectType|null
     */
    public function getDestination_Reference()
    {
        return $this->Destination_Reference;
    }
    /**
     * Set Destination_Reference value
     * @param \StructType\AirportObjectType $destination_Reference
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setDestination_Reference(\StructType\AirportObjectType $destination_Reference = null)
    {
        $this->Destination_Reference = $destination_Reference;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return string|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param string $endorsements
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setEndorsements($endorsements = null)
    {
        // validation for constraint: string
        if (!is_null($endorsements) && !is_string($endorsements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endorsements, true), gettype($endorsements)), __LINE__);
        }
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get Exchange_Ticket_Number value
     * @return string|null
     */
    public function getExchange_Ticket_Number()
    {
        return $this->Exchange_Ticket_Number;
    }
    /**
     * Set Exchange_Ticket_Number value
     * @param string $exchange_Ticket_Number
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setExchange_Ticket_Number($exchange_Ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($exchange_Ticket_Number) && !is_string($exchange_Ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchange_Ticket_Number, true), gettype($exchange_Ticket_Number)), __LINE__);
        }
        $this->Exchange_Ticket_Number = $exchange_Ticket_Number;
        return $this;
    }
    /**
     * Get Fare_Base value
     * @return string|null
     */
    public function getFare_Base()
    {
        return $this->Fare_Base;
    }
    /**
     * Set Fare_Base value
     * @param string $fare_Base
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setFare_Base($fare_Base = null)
    {
        // validation for constraint: string
        if (!is_null($fare_Base) && !is_string($fare_Base)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fare_Base, true), gettype($fare_Base)), __LINE__);
        }
        $this->Fare_Base = $fare_Base;
        return $this;
    }
    /**
     * Get Leg_Number value
     * @return float|null
     */
    public function getLeg_Number()
    {
        return $this->Leg_Number;
    }
    /**
     * Set Leg_Number value
     * @param float $leg_Number
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setLeg_Number($leg_Number = null)
    {
        // validation for constraint: float
        if (!is_null($leg_Number) && !(is_float($leg_Number) || is_numeric($leg_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($leg_Number, true), gettype($leg_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($leg_Number) && mb_strlen(mb_substr($leg_Number, false !== mb_strpos($leg_Number, '.') ? mb_strpos($leg_Number, '.') + 1 : mb_strlen($leg_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($leg_Number, true), mb_strlen(mb_substr($leg_Number, mb_strpos($leg_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($leg_Number) && $leg_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($leg_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($leg_Number) && mb_strlen(preg_replace('/(\D)/', '', $leg_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($leg_Number, true), mb_strlen(preg_replace('/(\D)/', '', $leg_Number))), __LINE__);
        }
        $this->Leg_Number = $leg_Number;
        return $this;
    }
    /**
     * Get Stopover_Indicator value
     * @return string|null
     */
    public function getStopover_Indicator()
    {
        return $this->Stopover_Indicator;
    }
    /**
     * Set Stopover_Indicator value
     * @param string $stopover_Indicator
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setStopover_Indicator($stopover_Indicator = null)
    {
        // validation for constraint: string
        if (!is_null($stopover_Indicator) && !is_string($stopover_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopover_Indicator, true), gettype($stopover_Indicator)), __LINE__);
        }
        $this->Stopover_Indicator = $stopover_Indicator;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Origination_Reference value
     * @return \StructType\AirportObjectType|null
     */
    public function getOrigination_Reference()
    {
        return $this->Origination_Reference;
    }
    /**
     * Set Origination_Reference value
     * @param \StructType\AirportObjectType $origination_Reference
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setOrigination_Reference(\StructType\AirportObjectType $origination_Reference = null)
    {
        $this->Origination_Reference = $origination_Reference;
        return $this;
    }
    /**
     * Get Travel_Date value
     * @return string|null
     */
    public function getTravel_Date()
    {
        return $this->Travel_Date;
    }
    /**
     * Set Travel_Date value
     * @param string $travel_Date
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setTravel_Date($travel_Date = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Date) && !is_string($travel_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Date, true), gettype($travel_Date)), __LINE__);
        }
        $this->Travel_Date = $travel_Date;
        return $this;
    }
    /**
     * Get Trip_Leg_Fare_Amount value
     * @return float|null
     */
    public function getTrip_Leg_Fare_Amount()
    {
        return $this->Trip_Leg_Fare_Amount;
    }
    /**
     * Set Trip_Leg_Fare_Amount value
     * @param float $trip_Leg_Fare_Amount
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setTrip_Leg_Fare_Amount($trip_Leg_Fare_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($trip_Leg_Fare_Amount) && !(is_float($trip_Leg_Fare_Amount) || is_numeric($trip_Leg_Fare_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($trip_Leg_Fare_Amount, true), gettype($trip_Leg_Fare_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($trip_Leg_Fare_Amount) && mb_strlen(mb_substr($trip_Leg_Fare_Amount, false !== mb_strpos($trip_Leg_Fare_Amount, '.') ? mb_strpos($trip_Leg_Fare_Amount, '.') + 1 : mb_strlen($trip_Leg_Fare_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($trip_Leg_Fare_Amount, true), mb_strlen(mb_substr($trip_Leg_Fare_Amount, mb_strpos($trip_Leg_Fare_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($trip_Leg_Fare_Amount) && mb_strlen(preg_replace('/(\D)/', '', $trip_Leg_Fare_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($trip_Leg_Fare_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $trip_Leg_Fare_Amount))), __LINE__);
        }
        $this->Trip_Leg_Fare_Amount = $trip_Leg_Fare_Amount;
        return $this;
    }
    /**
     * Get Trip_Leg_Fee_Amount value
     * @return float|null
     */
    public function getTrip_Leg_Fee_Amount()
    {
        return $this->Trip_Leg_Fee_Amount;
    }
    /**
     * Set Trip_Leg_Fee_Amount value
     * @param float $trip_Leg_Fee_Amount
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setTrip_Leg_Fee_Amount($trip_Leg_Fee_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($trip_Leg_Fee_Amount) && !(is_float($trip_Leg_Fee_Amount) || is_numeric($trip_Leg_Fee_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($trip_Leg_Fee_Amount, true), gettype($trip_Leg_Fee_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($trip_Leg_Fee_Amount) && mb_strlen(mb_substr($trip_Leg_Fee_Amount, false !== mb_strpos($trip_Leg_Fee_Amount, '.') ? mb_strpos($trip_Leg_Fee_Amount, '.') + 1 : mb_strlen($trip_Leg_Fee_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($trip_Leg_Fee_Amount, true), mb_strlen(mb_substr($trip_Leg_Fee_Amount, mb_strpos($trip_Leg_Fee_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($trip_Leg_Fee_Amount) && mb_strlen(preg_replace('/(\D)/', '', $trip_Leg_Fee_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($trip_Leg_Fee_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $trip_Leg_Fee_Amount))), __LINE__);
        }
        $this->Trip_Leg_Fee_Amount = $trip_Leg_Fee_Amount;
        return $this;
    }
    /**
     * Get Trip_Leg_Tax_Amount value
     * @return float|null
     */
    public function getTrip_Leg_Tax_Amount()
    {
        return $this->Trip_Leg_Tax_Amount;
    }
    /**
     * Set Trip_Leg_Tax_Amount value
     * @param float $trip_Leg_Tax_Amount
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setTrip_Leg_Tax_Amount($trip_Leg_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($trip_Leg_Tax_Amount) && !(is_float($trip_Leg_Tax_Amount) || is_numeric($trip_Leg_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($trip_Leg_Tax_Amount, true), gettype($trip_Leg_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($trip_Leg_Tax_Amount) && mb_strlen(mb_substr($trip_Leg_Tax_Amount, false !== mb_strpos($trip_Leg_Tax_Amount, '.') ? mb_strpos($trip_Leg_Tax_Amount, '.') + 1 : mb_strlen($trip_Leg_Tax_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($trip_Leg_Tax_Amount, true), mb_strlen(mb_substr($trip_Leg_Tax_Amount, mb_strpos($trip_Leg_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($trip_Leg_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $trip_Leg_Tax_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($trip_Leg_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $trip_Leg_Tax_Amount))), __LINE__);
        }
        $this->Trip_Leg_Tax_Amount = $trip_Leg_Tax_Amount;
        return $this;
    }
    /**
     * Get Refund_Indicator value
     * @return bool|null
     */
    public function getRefund_Indicator()
    {
        return $this->Refund_Indicator;
    }
    /**
     * Set Refund_Indicator value
     * @param bool $refund_Indicator
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setRefund_Indicator($refund_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($refund_Indicator) && !is_bool($refund_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refund_Indicator, true), gettype($refund_Indicator)), __LINE__);
        }
        $this->Refund_Indicator = $refund_Indicator;
        return $this;
    }
    /**
     * Get Trip_Leg_Details_Name_Match_Data value
     * @return \StructType\Trip_Leg_Details_Name_Match_DataType[]|null
     */
    public function getTrip_Leg_Details_Name_Match_Data()
    {
        return $this->Trip_Leg_Details_Name_Match_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTrip_Leg_Details_Name_Match_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrip_Leg_Details_Name_Match_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrip_Leg_Details_Name_Match_DataForArrayConstraintsFromSetTrip_Leg_Details_Name_Match_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trip_Leg_Details_DataTypeTrip_Leg_Details_Name_Match_DataItem) {
            // validation for constraint: itemType
            if (!$trip_Leg_Details_DataTypeTrip_Leg_Details_Name_Match_DataItem instanceof \StructType\Trip_Leg_Details_Name_Match_DataType) {
                $invalidValues[] = is_object($trip_Leg_Details_DataTypeTrip_Leg_Details_Name_Match_DataItem) ? get_class($trip_Leg_Details_DataTypeTrip_Leg_Details_Name_Match_DataItem) : sprintf('%s(%s)', gettype($trip_Leg_Details_DataTypeTrip_Leg_Details_Name_Match_DataItem), var_export($trip_Leg_Details_DataTypeTrip_Leg_Details_Name_Match_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Trip_Leg_Details_Name_Match_Data property can only contain items of type \StructType\Trip_Leg_Details_Name_Match_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Trip_Leg_Details_Name_Match_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Trip_Leg_Details_Name_Match_DataType[] $trip_Leg_Details_Name_Match_Data
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function setTrip_Leg_Details_Name_Match_Data(array $trip_Leg_Details_Name_Match_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($trip_Leg_Details_Name_Match_DataArrayErrorMessage = self::validateTrip_Leg_Details_Name_Match_DataForArrayConstraintsFromSetTrip_Leg_Details_Name_Match_Data($trip_Leg_Details_Name_Match_Data))) {
            throw new \InvalidArgumentException($trip_Leg_Details_Name_Match_DataArrayErrorMessage, __LINE__);
        }
        $this->Trip_Leg_Details_Name_Match_Data = $trip_Leg_Details_Name_Match_Data;
        return $this;
    }
    /**
     * Add item to Trip_Leg_Details_Name_Match_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Trip_Leg_Details_Name_Match_DataType $item
     * @return \StructType\Trip_Leg_Details_DataType
     */
    public function addToTrip_Leg_Details_Name_Match_Data(\StructType\Trip_Leg_Details_Name_Match_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Trip_Leg_Details_Name_Match_DataType) {
            throw new \InvalidArgumentException(sprintf('The Trip_Leg_Details_Name_Match_Data property can only contain items of type \StructType\Trip_Leg_Details_Name_Match_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Trip_Leg_Details_Name_Match_Data[] = $item;
        return $this;
    }
}
