<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Profile_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: At least one of the selected business assets is not issued to the selected worker for Travel Profile. | Element containing all Travel Profile data
 * @subpackage Structs
 */
class Travel_Profile_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Worker
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Vehicle_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Vehicle Type. For the selected worker, this vehicle type is the default value for vehicle type on an expense report line item detail.
     * - minOccurs: 0
     * @var \StructType\Vehicle_TypeObjectType
     */
    public $Vehicle_Type_Reference;
    /**
     * The Resource_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Asset allocated to the selected worker.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType[]
     */
    public $Resource_Reference;
    /**
     * The Fuel_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Fuel Type. For the selected worker, this fuel type is the default value for fuel type on an expense report line item detail.
     * - minOccurs: 0
     * @var \StructType\Fuel_TypeObjectType
     */
    public $Fuel_Type_Reference;
    /**
     * The Engine_Capacity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Engine Capacity. For the selected worker, this engine capacity is the default value for engine capacity on an expense report line item detail.
     * - minOccurs: 0
     * @var \StructType\Engine_CapacityObjectType
     */
    public $Engine_Capacity_Reference;
    /**
     * The Vehicle_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Vehicle Plan. For the selected worker, this vehicle plan is the default value for vehicle plan on an expense report line item detail.
     * - minOccurs: 0
     * @var \StructType\Vehicle_PlanObjectType
     */
    public $Vehicle_Plan_Reference;
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Airline. For the selected worker, this airline is the default value for airline on an expense report line item detail.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType[]
     */
    public $Airline_Reference;
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Car Rental Agency. For the selected worker, this car rental agency is the default value for car rental agency on an expense report line item detail.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Car_Rental_AgencyObjectType[]
     */
    public $Car_Rental_Agency_Reference;
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Hotel. For the selected worker, this hotel is the default value for hotel on an expense report line item detail.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelObjectType[]
     */
    public $Hotel_Reference;
    /**
     * The Travel_Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Travel Country. For the selected worker, this travel country is the default value for country on an expense report line item detail.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CountryObjectType[]
     */
    public $Travel_Country_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worker_Travel_Profile_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Expense_Item_Accumulator_Balance_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Accumulator_Balance_DataType[]
     */
    public $Expense_Item_Accumulator_Balance_Data;
    /**
     * Constructor method for Travel_Profile_DataType
     * @uses Travel_Profile_DataType::setWorker_Reference()
     * @uses Travel_Profile_DataType::setVehicle_Type_Reference()
     * @uses Travel_Profile_DataType::setResource_Reference()
     * @uses Travel_Profile_DataType::setFuel_Type_Reference()
     * @uses Travel_Profile_DataType::setEngine_Capacity_Reference()
     * @uses Travel_Profile_DataType::setVehicle_Plan_Reference()
     * @uses Travel_Profile_DataType::setAirline_Reference()
     * @uses Travel_Profile_DataType::setCar_Rental_Agency_Reference()
     * @uses Travel_Profile_DataType::setHotel_Reference()
     * @uses Travel_Profile_DataType::setTravel_Country_Reference()
     * @uses Travel_Profile_DataType::setAttachment_Data()
     * @uses Travel_Profile_DataType::setExpense_Item_Accumulator_Balance_Data()
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference
     * @param \StructType\Business_AssetObjectType[] $resource_Reference
     * @param \StructType\Fuel_TypeObjectType $fuel_Type_Reference
     * @param \StructType\Engine_CapacityObjectType $engine_Capacity_Reference
     * @param \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @param \StructType\CountryObjectType[] $travel_Country_Reference
     * @param \StructType\Worker_Travel_Profile_Attachment_DataType[] $attachment_Data
     * @param \StructType\Expense_Item_Accumulator_Balance_DataType[] $expense_Item_Accumulator_Balance_Data
     */
    public function __construct(\StructType\WorkerObjectType $worker_Reference = null, \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference = null, array $resource_Reference = array(), \StructType\Fuel_TypeObjectType $fuel_Type_Reference = null, \StructType\Engine_CapacityObjectType $engine_Capacity_Reference = null, \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference = null, array $airline_Reference = array(), array $car_Rental_Agency_Reference = array(), array $hotel_Reference = array(), array $travel_Country_Reference = array(), array $attachment_Data = array(), array $expense_Item_Accumulator_Balance_Data = array())
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setVehicle_Type_Reference($vehicle_Type_Reference)
            ->setResource_Reference($resource_Reference)
            ->setFuel_Type_Reference($fuel_Type_Reference)
            ->setEngine_Capacity_Reference($engine_Capacity_Reference)
            ->setVehicle_Plan_Reference($vehicle_Plan_Reference)
            ->setAirline_Reference($airline_Reference)
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference)
            ->setHotel_Reference($hotel_Reference)
            ->setTravel_Country_Reference($travel_Country_Reference)
            ->setAttachment_Data($attachment_Data)
            ->setExpense_Item_Accumulator_Balance_Data($expense_Item_Accumulator_Balance_Data);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Vehicle_Type_Reference value
     * @return \StructType\Vehicle_TypeObjectType|null
     */
    public function getVehicle_Type_Reference()
    {
        return $this->Vehicle_Type_Reference;
    }
    /**
     * Set Vehicle_Type_Reference value
     * @param \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setVehicle_Type_Reference(\StructType\Vehicle_TypeObjectType $vehicle_Type_Reference = null)
    {
        $this->Vehicle_Type_Reference = $vehicle_Type_Reference;
        return $this;
    }
    /**
     * Get Resource_Reference value
     * @return \StructType\Business_AssetObjectType[]|null
     */
    public function getResource_Reference()
    {
        return $this->Resource_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_ReferenceForArrayConstraintsFromSetResource_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeResource_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeResource_ReferenceItem instanceof \StructType\Business_AssetObjectType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeResource_ReferenceItem) ? get_class($travel_Profile_DataTypeResource_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeResource_ReferenceItem), var_export($travel_Profile_DataTypeResource_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType[] $resource_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setResource_Reference(array $resource_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_ReferenceArrayErrorMessage = self::validateResource_ReferenceForArrayConstraintsFromSetResource_Reference($resource_Reference))) {
            throw new \InvalidArgumentException($resource_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Resource_Reference = $resource_Reference;
        return $this;
    }
    /**
     * Add item to Resource_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToResource_Reference(\StructType\Business_AssetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_AssetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Reference[] = $item;
        return $this;
    }
    /**
     * Get Fuel_Type_Reference value
     * @return \StructType\Fuel_TypeObjectType|null
     */
    public function getFuel_Type_Reference()
    {
        return $this->Fuel_Type_Reference;
    }
    /**
     * Set Fuel_Type_Reference value
     * @param \StructType\Fuel_TypeObjectType $fuel_Type_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setFuel_Type_Reference(\StructType\Fuel_TypeObjectType $fuel_Type_Reference = null)
    {
        $this->Fuel_Type_Reference = $fuel_Type_Reference;
        return $this;
    }
    /**
     * Get Engine_Capacity_Reference value
     * @return \StructType\Engine_CapacityObjectType|null
     */
    public function getEngine_Capacity_Reference()
    {
        return $this->Engine_Capacity_Reference;
    }
    /**
     * Set Engine_Capacity_Reference value
     * @param \StructType\Engine_CapacityObjectType $engine_Capacity_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setEngine_Capacity_Reference(\StructType\Engine_CapacityObjectType $engine_Capacity_Reference = null)
    {
        $this->Engine_Capacity_Reference = $engine_Capacity_Reference;
        return $this;
    }
    /**
     * Get Vehicle_Plan_Reference value
     * @return \StructType\Vehicle_PlanObjectType|null
     */
    public function getVehicle_Plan_Reference()
    {
        return $this->Vehicle_Plan_Reference;
    }
    /**
     * Set Vehicle_Plan_Reference value
     * @param \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setVehicle_Plan_Reference(\StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference = null)
    {
        $this->Vehicle_Plan_Reference = $vehicle_Plan_Reference;
        return $this;
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType[]|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeAirline_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeAirline_ReferenceItem instanceof \StructType\AirlineObjectType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeAirline_ReferenceItem) ? get_class($travel_Profile_DataTypeAirline_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeAirline_ReferenceItem), var_export($travel_Profile_DataTypeAirline_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setAirline_Reference(array $airline_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($airline_ReferenceArrayErrorMessage = self::validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference($airline_Reference))) {
            throw new \InvalidArgumentException($airline_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Add item to Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToAirline_Reference(\StructType\AirlineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline_Reference[] = $item;
        return $this;
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType[]|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCar_Rental_Agency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCar_Rental_Agency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeCar_Rental_Agency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeCar_Rental_Agency_ReferenceItem instanceof \StructType\Car_Rental_AgencyObjectType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeCar_Rental_Agency_ReferenceItem) ? get_class($travel_Profile_DataTypeCar_Rental_Agency_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeCar_Rental_Agency_ReferenceItem), var_export($travel_Profile_DataTypeCar_Rental_Agency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setCar_Rental_Agency_Reference(array $car_Rental_Agency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($car_Rental_Agency_ReferenceArrayErrorMessage = self::validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference($car_Rental_Agency_Reference))) {
            throw new \InvalidArgumentException($car_Rental_Agency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Add item to Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Car_Rental_AgencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Car_Rental_Agency_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType[]|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeHotel_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeHotel_ReferenceItem instanceof \StructType\HotelObjectType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeHotel_ReferenceItem) ? get_class($travel_Profile_DataTypeHotel_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeHotel_ReferenceItem), var_export($travel_Profile_DataTypeHotel_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setHotel_Reference(array $hotel_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($hotel_ReferenceArrayErrorMessage = self::validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference($hotel_Reference))) {
            throw new \InvalidArgumentException($hotel_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Add item to Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToHotel_Reference(\StructType\HotelObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelObjectType) {
            throw new \InvalidArgumentException(sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel_Reference[] = $item;
        return $this;
    }
    /**
     * Get Travel_Country_Reference value
     * @return \StructType\CountryObjectType[]|null
     */
    public function getTravel_Country_Reference()
    {
        return $this->Travel_Country_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Country_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Country_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Country_ReferenceForArrayConstraintsFromSetTravel_Country_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeTravel_Country_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeTravel_Country_ReferenceItem instanceof \StructType\CountryObjectType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeTravel_Country_ReferenceItem) ? get_class($travel_Profile_DataTypeTravel_Country_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeTravel_Country_ReferenceItem), var_export($travel_Profile_DataTypeTravel_Country_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Country_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Country_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType[] $travel_Country_Reference
     * @return \StructType\Travel_Profile_DataType
     */
    public function setTravel_Country_Reference(array $travel_Country_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Country_ReferenceArrayErrorMessage = self::validateTravel_Country_ReferenceForArrayConstraintsFromSetTravel_Country_Reference($travel_Country_Reference))) {
            throw new \InvalidArgumentException($travel_Country_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_Country_Reference = $travel_Country_Reference;
        return $this;
    }
    /**
     * Add item to Travel_Country_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToTravel_Country_Reference(\StructType\CountryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Country_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Country_Reference[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeAttachment_DataItem instanceof \StructType\Worker_Travel_Profile_Attachment_DataType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeAttachment_DataItem) ? get_class($travel_Profile_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeAttachment_DataItem), var_export($travel_Profile_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Worker_Travel_Profile_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Travel_Profile_Attachment_DataType[] $attachment_Data
     * @return \StructType\Travel_Profile_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Travel_Profile_Attachment_DataType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToAttachment_Data(\StructType\Worker_Travel_Profile_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_Travel_Profile_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Worker_Travel_Profile_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Expense_Item_Accumulator_Balance_Data value
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType[]|null
     */
    public function getExpense_Item_Accumulator_Balance_Data()
    {
        return $this->Expense_Item_Accumulator_Balance_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Accumulator_Balance_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Accumulator_Balance_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_Accumulator_Balance_DataForArrayConstraintsFromSetExpense_Item_Accumulator_Balance_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Profile_DataTypeExpense_Item_Accumulator_Balance_DataItem) {
            // validation for constraint: itemType
            if (!$travel_Profile_DataTypeExpense_Item_Accumulator_Balance_DataItem instanceof \StructType\Expense_Item_Accumulator_Balance_DataType) {
                $invalidValues[] = is_object($travel_Profile_DataTypeExpense_Item_Accumulator_Balance_DataItem) ? get_class($travel_Profile_DataTypeExpense_Item_Accumulator_Balance_DataItem) : sprintf('%s(%s)', gettype($travel_Profile_DataTypeExpense_Item_Accumulator_Balance_DataItem), var_export($travel_Profile_DataTypeExpense_Item_Accumulator_Balance_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Accumulator_Balance_Data property can only contain items of type \StructType\Expense_Item_Accumulator_Balance_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Accumulator_Balance_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Accumulator_Balance_DataType[] $expense_Item_Accumulator_Balance_Data
     * @return \StructType\Travel_Profile_DataType
     */
    public function setExpense_Item_Accumulator_Balance_Data(array $expense_Item_Accumulator_Balance_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_Accumulator_Balance_DataArrayErrorMessage = self::validateExpense_Item_Accumulator_Balance_DataForArrayConstraintsFromSetExpense_Item_Accumulator_Balance_Data($expense_Item_Accumulator_Balance_Data))) {
            throw new \InvalidArgumentException($expense_Item_Accumulator_Balance_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Accumulator_Balance_Data = $expense_Item_Accumulator_Balance_Data;
        return $this;
    }
    /**
     * Add item to Expense_Item_Accumulator_Balance_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Accumulator_Balance_DataType $item
     * @return \StructType\Travel_Profile_DataType
     */
    public function addToExpense_Item_Accumulator_Balance_Data(\StructType\Expense_Item_Accumulator_Balance_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Item_Accumulator_Balance_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Accumulator_Balance_Data property can only contain items of type \StructType\Expense_Item_Accumulator_Balance_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Accumulator_Balance_Data[] = $item;
        return $this;
    }
}
