<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_City_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Travel City Object
 * @subpackage Structs
 */
class Travel_City_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Travel City Object
     * - maxOccurs: unbounded
     * @var \StructType\Travel_CityObjectType[]
     */
    public $Travel_City_Reference;
    /**
     * Constructor method for Travel_City_Request_ReferencesType
     * @uses Travel_City_Request_ReferencesType::setTravel_City_Reference()
     * @param \StructType\Travel_CityObjectType[] $travel_City_Reference
     */
    public function __construct(array $travel_City_Reference = array())
    {
        $this
            ->setTravel_City_Reference($travel_City_Reference);
    }
    /**
     * Get Travel_City_Reference value
     * @return \StructType\Travel_CityObjectType[]|null
     */
    public function getTravel_City_Reference()
    {
        return $this->Travel_City_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_City_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_City_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_City_ReferenceForArrayConstraintsFromSetTravel_City_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_City_Request_ReferencesTypeTravel_City_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_City_Request_ReferencesTypeTravel_City_ReferenceItem instanceof \StructType\Travel_CityObjectType) {
                $invalidValues[] = is_object($travel_City_Request_ReferencesTypeTravel_City_ReferenceItem) ? get_class($travel_City_Request_ReferencesTypeTravel_City_ReferenceItem) : sprintf('%s(%s)', gettype($travel_City_Request_ReferencesTypeTravel_City_ReferenceItem), var_export($travel_City_Request_ReferencesTypeTravel_City_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_City_Reference property can only contain items of type \StructType\Travel_CityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_City_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_CityObjectType[] $travel_City_Reference
     * @return \StructType\Travel_City_Request_ReferencesType
     */
    public function setTravel_City_Reference(array $travel_City_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_City_ReferenceArrayErrorMessage = self::validateTravel_City_ReferenceForArrayConstraintsFromSetTravel_City_Reference($travel_City_Reference))) {
            throw new \InvalidArgumentException($travel_City_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_City_Reference = $travel_City_Reference;
        return $this;
    }
    /**
     * Add item to Travel_City_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_CityObjectType $item
     * @return \StructType\Travel_City_Request_ReferencesType
     */
    public function addToTravel_City_Reference(\StructType\Travel_CityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_CityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_City_Reference property can only contain items of type \StructType\Travel_CityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_City_Reference[] = $item;
        return $this;
    }
}
