<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_File_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Booking Record Data.
 * @subpackage Structs
 */
class Travel_Booking_File_DataType extends AbstractStructBase
{
    /**
     * The File_ID
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking File ID. This is the Travel Booking unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_ID;
    /**
     * The File_Name
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking File Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Name;
    /**
     * The File_Date
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking File Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Date;
    /**
     * The Default_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Company.
     * @var \StructType\CompanyObjectType
     */
    public $Default_Company_Reference;
    /**
     * The Travel_Booking_Record_Data
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_Record_DataType[]
     */
    public $Travel_Booking_Record_Data;
    /**
     * Constructor method for Travel_Booking_File_DataType
     * @uses Travel_Booking_File_DataType::setFile_ID()
     * @uses Travel_Booking_File_DataType::setFile_Name()
     * @uses Travel_Booking_File_DataType::setFile_Date()
     * @uses Travel_Booking_File_DataType::setDefault_Company_Reference()
     * @uses Travel_Booking_File_DataType::setTravel_Booking_Record_Data()
     * @param string $file_ID
     * @param string $file_Name
     * @param string $file_Date
     * @param \StructType\CompanyObjectType $default_Company_Reference
     * @param \StructType\Travel_Booking_Record_DataType[] $travel_Booking_Record_Data
     */
    public function __construct($file_ID = null, $file_Name = null, $file_Date = null, \StructType\CompanyObjectType $default_Company_Reference = null, array $travel_Booking_Record_Data = array())
    {
        $this
            ->setFile_ID($file_ID)
            ->setFile_Name($file_Name)
            ->setFile_Date($file_Date)
            ->setDefault_Company_Reference($default_Company_Reference)
            ->setTravel_Booking_Record_Data($travel_Booking_Record_Data);
    }
    /**
     * Get File_ID value
     * @return string|null
     */
    public function getFile_ID()
    {
        return $this->File_ID;
    }
    /**
     * Set File_ID value
     * @param string $file_ID
     * @return \StructType\Travel_Booking_File_DataType
     */
    public function setFile_ID($file_ID = null)
    {
        // validation for constraint: string
        if (!is_null($file_ID) && !is_string($file_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_ID, true), gettype($file_ID)), __LINE__);
        }
        $this->File_ID = $file_ID;
        return $this;
    }
    /**
     * Get File_Name value
     * @return string|null
     */
    public function getFile_Name()
    {
        return $this->File_Name;
    }
    /**
     * Set File_Name value
     * @param string $file_Name
     * @return \StructType\Travel_Booking_File_DataType
     */
    public function setFile_Name($file_Name = null)
    {
        // validation for constraint: string
        if (!is_null($file_Name) && !is_string($file_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Name, true), gettype($file_Name)), __LINE__);
        }
        $this->File_Name = $file_Name;
        return $this;
    }
    /**
     * Get File_Date value
     * @return string|null
     */
    public function getFile_Date()
    {
        return $this->File_Date;
    }
    /**
     * Set File_Date value
     * @param string $file_Date
     * @return \StructType\Travel_Booking_File_DataType
     */
    public function setFile_Date($file_Date = null)
    {
        // validation for constraint: string
        if (!is_null($file_Date) && !is_string($file_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Date, true), gettype($file_Date)), __LINE__);
        }
        $this->File_Date = $file_Date;
        return $this;
    }
    /**
     * Get Default_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getDefault_Company_Reference()
    {
        return $this->Default_Company_Reference;
    }
    /**
     * Set Default_Company_Reference value
     * @param \StructType\CompanyObjectType $default_Company_Reference
     * @return \StructType\Travel_Booking_File_DataType
     */
    public function setDefault_Company_Reference(\StructType\CompanyObjectType $default_Company_Reference = null)
    {
        $this->Default_Company_Reference = $default_Company_Reference;
        return $this;
    }
    /**
     * Get Travel_Booking_Record_Data value
     * @return \StructType\Travel_Booking_Record_DataType[]|null
     */
    public function getTravel_Booking_Record_Data()
    {
        return $this->Travel_Booking_Record_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Booking_Record_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Booking_Record_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Booking_Record_DataForArrayConstraintsFromSetTravel_Booking_Record_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_File_DataTypeTravel_Booking_Record_DataItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_File_DataTypeTravel_Booking_Record_DataItem instanceof \StructType\Travel_Booking_Record_DataType) {
                $invalidValues[] = is_object($travel_Booking_File_DataTypeTravel_Booking_Record_DataItem) ? get_class($travel_Booking_File_DataTypeTravel_Booking_Record_DataItem) : sprintf('%s(%s)', gettype($travel_Booking_File_DataTypeTravel_Booking_Record_DataItem), var_export($travel_Booking_File_DataTypeTravel_Booking_Record_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Booking_Record_Data property can only contain items of type \StructType\Travel_Booking_Record_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Booking_Record_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_DataType[] $travel_Booking_Record_Data
     * @return \StructType\Travel_Booking_File_DataType
     */
    public function setTravel_Booking_Record_Data(array $travel_Booking_Record_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Booking_Record_DataArrayErrorMessage = self::validateTravel_Booking_Record_DataForArrayConstraintsFromSetTravel_Booking_Record_Data($travel_Booking_Record_Data))) {
            throw new \InvalidArgumentException($travel_Booking_Record_DataArrayErrorMessage, __LINE__);
        }
        $this->Travel_Booking_Record_Data = $travel_Booking_Record_Data;
        return $this;
    }
    /**
     * Add item to Travel_Booking_Record_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_DataType $item
     * @return \StructType\Travel_Booking_File_DataType
     */
    public function addToTravel_Booking_Record_Data(\StructType\Travel_Booking_Record_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_Record_DataType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Booking_Record_Data property can only contain items of type \StructType\Travel_Booking_Record_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Booking_Record_Data[] = $item;
        return $this;
    }
}
