<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Item response options
 * @subpackage Structs
 */
class Supplier_Item_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Include Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Show_All_Pricing
     * Meta information extracted from the WSDL
     * - documentation: When 1, will return all Unit of Measure Pricing and Advance Pricing data, including future dated, past dated, and pricing not valid as of current day. Pricing marked Inactive will be returned as well. The value "As of Effective Day"
     * from the Response Filter will be ignored. If 'Only Default UOM and Price' filter criteria is also 1, only default pricing is returned, and no Advanced Pricing is returned, but historical and future default Unit of Measure pricing will still appear.
     * If used with 'Only Active Supplier Items' is 1, only pricing not marked inactive is returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Show_All_Pricing;
    /**
     * Constructor method for Supplier_Item_Response_GroupType
     * @uses Supplier_Item_Response_GroupType::setInclude_Reference()
     * @uses Supplier_Item_Response_GroupType::setShow_All_Pricing()
     * @param bool $include_Reference
     * @param bool $show_All_Pricing
     */
    public function __construct($include_Reference = null, $show_All_Pricing = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setShow_All_Pricing($show_All_Pricing);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Supplier_Item_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Show_All_Pricing value
     * @return bool|null
     */
    public function getShow_All_Pricing()
    {
        return $this->Show_All_Pricing;
    }
    /**
     * Set Show_All_Pricing value
     * @param bool $show_All_Pricing
     * @return \StructType\Supplier_Item_Response_GroupType
     */
    public function setShow_All_Pricing($show_All_Pricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($show_All_Pricing) && !is_bool($show_All_Pricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($show_All_Pricing, true), gettype($show_All_Pricing)), __LINE__);
        }
        $this->Show_All_Pricing = $show_All_Pricing;
        return $this;
    }
}
