<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Assignment_Rule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all supplier invoice assignment rule data.
 * @subpackage Structs
 */
class Supplier_Invoice_Assignment_Rule_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Assignment_Rule_ID
     * Meta information extracted from the WSDL
     * - documentation: ID for supplier invoice assignment rule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Assignment_Rule_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Ordering used for Supplier Invoice Assignment Rule. If this is empty, the Supplier Invoice Assignment Rule will be added to the bottom.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Supplier_Groups_Reference
     * Meta information extracted from the WSDL
     * - documentation: Relevant Supplier Group(s) for Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupObjectType[]
     */
    public $Supplier_Groups_Reference;
    /**
     * The Supplier_Categories_Reference
     * Meta information extracted from the WSDL
     * - documentation: Relevant Supplier Categories for Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType[]
     */
    public $Supplier_Categories_Reference;
    /**
     * The Suppliers_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier(s) used for the Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Suppliers_Reference;
    /**
     * The Companies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Companies or Company Hierarchies for the Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Companies_Reference;
    /**
     * The Supplier_Invoice_Work_Queue_Tags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Work Queue Tags for the Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_TagObjectType[]
     */
    public $Supplier_Invoice_Work_Queue_Tags_Reference;
    /**
     * The External_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Specify External Transaction Sources that are valid for supplier invoice usage. | External Supplier Invoice Sources for the Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType[]
     */
    public $External_Source_Reference;
    /**
     * The Greater_Than_Amount
     * Meta information extracted from the WSDL
     * - documentation: Greater than amount for supplier invoice work queue tag assignment rule. | Greater than amount for Supplier Invoice Assignment Rule.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Greater_Than_Amount;
    /**
     * The Currencies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Relevant currencies pertaining to Supplier Invoice Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType[]
     */
    public $Currencies_Reference;
    /**
     * The Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Assignee for the Supplier Invoice Assignment Rule. This is the Worker that the supplier invoice will be assigned to.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Assignee_Reference;
    /**
     * The Assign_To_Creator
     * Meta information extracted from the WSDL
     * - documentation: True if the supplier invoice will be assigned to the creator of the invoice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Assign_To_Creator;
    /**
     * The Supplier_Name_Range_Start
     * Meta information extracted from the WSDL
     * - documentation: Enter Name Range Start for Supplier
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Name_Range_Start;
    /**
     * The Supplier_Name_Range_End
     * Meta information extracted from the WSDL
     * - documentation: Enter Name Range End for Supplier
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Name_Range_End;
    /**
     * Constructor method for Supplier_Invoice_Assignment_Rule_DataType
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSupplier_Invoice_Assignment_Rule_ID()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setOrder()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSupplier_Groups_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSupplier_Categories_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSuppliers_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setCompanies_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSupplier_Invoice_Work_Queue_Tags_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setExternal_Source_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setGreater_Than_Amount()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setCurrencies_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setAssignee_Reference()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setAssign_To_Creator()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSupplier_Name_Range_Start()
     * @uses Supplier_Invoice_Assignment_Rule_DataType::setSupplier_Name_Range_End()
     * @param string $supplier_Invoice_Assignment_Rule_ID
     * @param string $order
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Groups_Reference
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Categories_Reference
     * @param \StructType\Resource_ProviderObjectType[] $suppliers_Reference
     * @param \StructType\OrganizationObjectType[] $companies_Reference
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType[] $supplier_Invoice_Work_Queue_Tags_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_Source_Reference
     * @param float $greater_Than_Amount
     * @param \StructType\CurrencyObjectType[] $currencies_Reference
     * @param \StructType\WorkerObjectType $assignee_Reference
     * @param bool $assign_To_Creator
     * @param string $supplier_Name_Range_Start
     * @param string $supplier_Name_Range_End
     */
    public function __construct($supplier_Invoice_Assignment_Rule_ID = null, $order = null, array $supplier_Groups_Reference = array(), array $supplier_Categories_Reference = array(), array $suppliers_Reference = array(), array $companies_Reference = array(), array $supplier_Invoice_Work_Queue_Tags_Reference = array(), array $external_Source_Reference = array(), $greater_Than_Amount = null, array $currencies_Reference = array(), \StructType\WorkerObjectType $assignee_Reference = null, $assign_To_Creator = null, $supplier_Name_Range_Start = null, $supplier_Name_Range_End = null)
    {
        $this
            ->setSupplier_Invoice_Assignment_Rule_ID($supplier_Invoice_Assignment_Rule_ID)
            ->setOrder($order)
            ->setSupplier_Groups_Reference($supplier_Groups_Reference)
            ->setSupplier_Categories_Reference($supplier_Categories_Reference)
            ->setSuppliers_Reference($suppliers_Reference)
            ->setCompanies_Reference($companies_Reference)
            ->setSupplier_Invoice_Work_Queue_Tags_Reference($supplier_Invoice_Work_Queue_Tags_Reference)
            ->setExternal_Source_Reference($external_Source_Reference)
            ->setGreater_Than_Amount($greater_Than_Amount)
            ->setCurrencies_Reference($currencies_Reference)
            ->setAssignee_Reference($assignee_Reference)
            ->setAssign_To_Creator($assign_To_Creator)
            ->setSupplier_Name_Range_Start($supplier_Name_Range_Start)
            ->setSupplier_Name_Range_End($supplier_Name_Range_End);
    }
    /**
     * Get Supplier_Invoice_Assignment_Rule_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Assignment_Rule_ID()
    {
        return $this->Supplier_Invoice_Assignment_Rule_ID;
    }
    /**
     * Set Supplier_Invoice_Assignment_Rule_ID value
     * @param string $supplier_Invoice_Assignment_Rule_ID
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSupplier_Invoice_Assignment_Rule_ID($supplier_Invoice_Assignment_Rule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Assignment_Rule_ID) && !is_string($supplier_Invoice_Assignment_Rule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Assignment_Rule_ID, true), gettype($supplier_Invoice_Assignment_Rule_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Assignment_Rule_ID = $supplier_Invoice_Assignment_Rule_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Supplier_Groups_Reference value
     * @return \StructType\Supplier_GroupObjectType[]|null
     */
    public function getSupplier_Groups_Reference()
    {
        return $this->Supplier_Groups_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Groups_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Groups_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Groups_ReferenceForArrayConstraintsFromSetSupplier_Groups_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeSupplier_Groups_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeSupplier_Groups_ReferenceItem instanceof \StructType\Supplier_GroupObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Groups_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Groups_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Groups_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Groups_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Groups_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Groups_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Groups_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSupplier_Groups_Reference(array $supplier_Groups_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Groups_ReferenceArrayErrorMessage = self::validateSupplier_Groups_ReferenceForArrayConstraintsFromSetSupplier_Groups_Reference($supplier_Groups_Reference))) {
            throw new \InvalidArgumentException($supplier_Groups_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Groups_Reference = $supplier_Groups_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Groups_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToSupplier_Groups_Reference(\StructType\Supplier_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Groups_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Groups_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Categories_Reference value
     * @return \StructType\Supplier_CategoryObjectType[]|null
     */
    public function getSupplier_Categories_Reference()
    {
        return $this->Supplier_Categories_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Categories_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Categories_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Categories_ReferenceForArrayConstraintsFromSetSupplier_Categories_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeSupplier_Categories_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeSupplier_Categories_ReferenceItem instanceof \StructType\Supplier_CategoryObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Categories_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Categories_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Categories_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Categories_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Categories_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Categories_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Categories_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSupplier_Categories_Reference(array $supplier_Categories_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Categories_ReferenceArrayErrorMessage = self::validateSupplier_Categories_ReferenceForArrayConstraintsFromSetSupplier_Categories_Reference($supplier_Categories_Reference))) {
            throw new \InvalidArgumentException($supplier_Categories_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Categories_Reference = $supplier_Categories_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Categories_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToSupplier_Categories_Reference(\StructType\Supplier_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Categories_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Categories_Reference[] = $item;
        return $this;
    }
    /**
     * Get Suppliers_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSuppliers_Reference()
    {
        return $this->Suppliers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSuppliers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuppliers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSuppliers_ReferenceForArrayConstraintsFromSetSuppliers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeSuppliers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeSuppliers_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeSuppliers_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeSuppliers_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeSuppliers_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeSuppliers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Suppliers_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Suppliers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $suppliers_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSuppliers_Reference(array $suppliers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($suppliers_ReferenceArrayErrorMessage = self::validateSuppliers_ReferenceForArrayConstraintsFromSetSuppliers_Reference($suppliers_Reference))) {
            throw new \InvalidArgumentException($suppliers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Suppliers_Reference = $suppliers_Reference;
        return $this;
    }
    /**
     * Add item to Suppliers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToSuppliers_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Suppliers_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Suppliers_Reference[] = $item;
        return $this;
    }
    /**
     * Get Companies_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompanies_Reference()
    {
        return $this->Companies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanies_ReferenceForArrayConstraintsFromSetCompanies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeCompanies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeCompanies_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeCompanies_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeCompanies_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeCompanies_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeCompanies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $companies_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setCompanies_Reference(array $companies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($companies_ReferenceArrayErrorMessage = self::validateCompanies_ReferenceForArrayConstraintsFromSetCompanies_Reference($companies_Reference))) {
            throw new \InvalidArgumentException($companies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Companies_Reference = $companies_Reference;
        return $this;
    }
    /**
     * Add item to Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToCompanies_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Companies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tags_Reference value
     * @return \StructType\Supplier_Invoice_Work_Queue_TagObjectType[]|null
     */
    public function getSupplier_Invoice_Work_Queue_Tags_Reference()
    {
        return $this->Supplier_Invoice_Work_Queue_Tags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Work_Queue_Tags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Work_Queue_Tags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Work_Queue_Tags_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tags_ReferenceItem instanceof \StructType\Supplier_Invoice_Work_Queue_TagObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tags_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tags_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tags_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Work_Queue_Tags_Reference property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType[] $supplier_Invoice_Work_Queue_Tags_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSupplier_Invoice_Work_Queue_Tags_Reference(array $supplier_Invoice_Work_Queue_Tags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Work_Queue_Tags_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Work_Queue_Tags_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tags_Reference($supplier_Invoice_Work_Queue_Tags_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Work_Queue_Tags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tags_Reference = $supplier_Invoice_Work_Queue_Tags_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Work_Queue_Tags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToSupplier_Invoice_Work_Queue_Tags_Reference(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Work_Queue_Tags_Reference property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tags_Reference[] = $item;
        return $this;
    }
    /**
     * Get External_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType[]|null
     */
    public function getExternal_Source_Reference()
    {
        return $this->External_Source_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_Source_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_Source_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_Source_ReferenceForArrayConstraintsFromSetExternal_Source_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeExternal_Source_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeExternal_Source_ReferenceItem instanceof \StructType\External_Transaction_Source__All_ObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeExternal_Source_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeExternal_Source_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeExternal_Source_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeExternal_Source_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_Source_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_Source_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setExternal_Source_Reference(array $external_Source_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($external_Source_ReferenceArrayErrorMessage = self::validateExternal_Source_ReferenceForArrayConstraintsFromSetExternal_Source_Reference($external_Source_Reference))) {
            throw new \InvalidArgumentException($external_Source_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->External_Source_Reference = $external_Source_Reference;
        return $this;
    }
    /**
     * Add item to External_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToExternal_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Transaction_Source__All_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The External_Source_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_Source_Reference[] = $item;
        return $this;
    }
    /**
     * Get Greater_Than_Amount value
     * @return float|null
     */
    public function getGreater_Than_Amount()
    {
        return $this->Greater_Than_Amount;
    }
    /**
     * Set Greater_Than_Amount value
     * @param float $greater_Than_Amount
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setGreater_Than_Amount($greater_Than_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($greater_Than_Amount) && !(is_float($greater_Than_Amount) || is_numeric($greater_Than_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($greater_Than_Amount, true), gettype($greater_Than_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($greater_Than_Amount) && mb_strlen(mb_substr($greater_Than_Amount, false !== mb_strpos($greater_Than_Amount, '.') ? mb_strpos($greater_Than_Amount, '.') + 1 : mb_strlen($greater_Than_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($greater_Than_Amount, true), mb_strlen(mb_substr($greater_Than_Amount, mb_strpos($greater_Than_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($greater_Than_Amount) && $greater_Than_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($greater_Than_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($greater_Than_Amount) && mb_strlen(preg_replace('/(\D)/', '', $greater_Than_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($greater_Than_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $greater_Than_Amount))), __LINE__);
        }
        $this->Greater_Than_Amount = $greater_Than_Amount;
        return $this;
    }
    /**
     * Get Currencies_Reference value
     * @return \StructType\CurrencyObjectType[]|null
     */
    public function getCurrencies_Reference()
    {
        return $this->Currencies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrencies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrencies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencies_ReferenceForArrayConstraintsFromSetCurrencies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Assignment_Rule_DataTypeCurrencies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Assignment_Rule_DataTypeCurrencies_ReferenceItem instanceof \StructType\CurrencyObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Assignment_Rule_DataTypeCurrencies_ReferenceItem) ? get_class($supplier_Invoice_Assignment_Rule_DataTypeCurrencies_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Assignment_Rule_DataTypeCurrencies_ReferenceItem), var_export($supplier_Invoice_Assignment_Rule_DataTypeCurrencies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currencies_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType[] $currencies_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setCurrencies_Reference(array $currencies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($currencies_ReferenceArrayErrorMessage = self::validateCurrencies_ReferenceForArrayConstraintsFromSetCurrencies_Reference($currencies_Reference))) {
            throw new \InvalidArgumentException($currencies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Currencies_Reference = $currencies_Reference;
        return $this;
    }
    /**
     * Add item to Currencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType $item
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function addToCurrencies_Reference(\StructType\CurrencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Currencies_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currencies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Assignee_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAssignee_Reference()
    {
        return $this->Assignee_Reference;
    }
    /**
     * Set Assignee_Reference value
     * @param \StructType\WorkerObjectType $assignee_Reference
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setAssignee_Reference(\StructType\WorkerObjectType $assignee_Reference = null)
    {
        $this->Assignee_Reference = $assignee_Reference;
        return $this;
    }
    /**
     * Get Assign_To_Creator value
     * @return bool|null
     */
    public function getAssign_To_Creator()
    {
        return $this->Assign_To_Creator;
    }
    /**
     * Set Assign_To_Creator value
     * @param bool $assign_To_Creator
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setAssign_To_Creator($assign_To_Creator = null)
    {
        // validation for constraint: boolean
        if (!is_null($assign_To_Creator) && !is_bool($assign_To_Creator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assign_To_Creator, true), gettype($assign_To_Creator)), __LINE__);
        }
        $this->Assign_To_Creator = $assign_To_Creator;
        return $this;
    }
    /**
     * Get Supplier_Name_Range_Start value
     * @return string|null
     */
    public function getSupplier_Name_Range_Start()
    {
        return $this->Supplier_Name_Range_Start;
    }
    /**
     * Set Supplier_Name_Range_Start value
     * @param string $supplier_Name_Range_Start
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSupplier_Name_Range_Start($supplier_Name_Range_Start = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Name_Range_Start) && !is_string($supplier_Name_Range_Start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Name_Range_Start, true), gettype($supplier_Name_Range_Start)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($supplier_Name_Range_Start) && mb_strlen($supplier_Name_Range_Start) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($supplier_Name_Range_Start)), __LINE__);
        }
        $this->Supplier_Name_Range_Start = $supplier_Name_Range_Start;
        return $this;
    }
    /**
     * Get Supplier_Name_Range_End value
     * @return string|null
     */
    public function getSupplier_Name_Range_End()
    {
        return $this->Supplier_Name_Range_End;
    }
    /**
     * Set Supplier_Name_Range_End value
     * @param string $supplier_Name_Range_End
     * @return \StructType\Supplier_Invoice_Assignment_Rule_DataType
     */
    public function setSupplier_Name_Range_End($supplier_Name_Range_End = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Name_Range_End) && !is_string($supplier_Name_Range_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Name_Range_End, true), gettype($supplier_Name_Range_End)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($supplier_Name_Range_End) && mb_strlen($supplier_Name_Range_End) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($supplier_Name_Range_End)), __LINE__);
        }
        $this->Supplier_Name_Range_End = $supplier_Name_Range_End;
        return $this;
    }
}
