<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Field_Interface_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Classification Field Interface Data element to configure one or more Supplier Classification Fields for a Supplier
 * @subpackage Structs
 */
class Supplier_Classification_Field_Interface_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Supplier Classification Field for the Suppler Classification Field Interface
     * @var \StructType\Custom_Supplier_Classification_FieldObjectType
     */
    public $Supplier_Classification_Field_Reference;
    /**
     * The Field_Date_Value
     * Meta information extracted from the WSDL
     * - documentation: The value for a Supplier Classification Field that has 1 of these Supplier Classification Types: Date, Effective Date, or Expiration Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field_Date_Value;
    /**
     * The Field_Number_Value
     * Meta information extracted from the WSDL
     * - documentation: The value for a Supplier Classification Field that has Supplier Classification Type of Number
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Field_Number_Value;
    /**
     * The Field_Text_Value
     * Meta information extracted from the WSDL
     * - documentation: The value for a Supplier Classification Field that has Supplier Classification Type of Text
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field_Text_Value;
    /**
     * The Field_Single_Select_Choice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Supplier Classification Field Choice for a Supplier Classification Field that has Supplier Classification Type of Multiple Choice - Single Select
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType
     */
    public $Field_Single_Select_Choice_Reference;
    /**
     * The Field_Multi_Select_Choice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Supplier Classification Field Choice for a Supplier Classification Field that has Supplier Classification Type of Multiple Choice - Multi Select
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType[]
     */
    public $Field_Multi_Select_Choice_Reference;
    /**
     * The Financials_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Financials Attachment Data element for a Supplier Classification Field that has Supplier Classification Type of Upload Attachment
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Financials_Attachment_Data;
    /**
     * Constructor method for Supplier_Classification_Field_Interface_DataType
     * @uses Supplier_Classification_Field_Interface_DataType::setSupplier_Classification_Field_Reference()
     * @uses Supplier_Classification_Field_Interface_DataType::setField_Date_Value()
     * @uses Supplier_Classification_Field_Interface_DataType::setField_Number_Value()
     * @uses Supplier_Classification_Field_Interface_DataType::setField_Text_Value()
     * @uses Supplier_Classification_Field_Interface_DataType::setField_Single_Select_Choice_Reference()
     * @uses Supplier_Classification_Field_Interface_DataType::setField_Multi_Select_Choice_Reference()
     * @uses Supplier_Classification_Field_Interface_DataType::setFinancials_Attachment_Data()
     * @param \StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference
     * @param string $field_Date_Value
     * @param float $field_Number_Value
     * @param string $field_Text_Value
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $field_Single_Select_Choice_Reference
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType[] $field_Multi_Select_Choice_Reference
     * @param \StructType\Financials_Attachment_DataType[] $financials_Attachment_Data
     */
    public function __construct(\StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference = null, $field_Date_Value = null, $field_Number_Value = null, $field_Text_Value = null, \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $field_Single_Select_Choice_Reference = null, array $field_Multi_Select_Choice_Reference = array(), array $financials_Attachment_Data = array())
    {
        $this
            ->setSupplier_Classification_Field_Reference($supplier_Classification_Field_Reference)
            ->setField_Date_Value($field_Date_Value)
            ->setField_Number_Value($field_Number_Value)
            ->setField_Text_Value($field_Text_Value)
            ->setField_Single_Select_Choice_Reference($field_Single_Select_Choice_Reference)
            ->setField_Multi_Select_Choice_Reference($field_Multi_Select_Choice_Reference)
            ->setFinancials_Attachment_Data($financials_Attachment_Data);
    }
    /**
     * Get Supplier_Classification_Field_Reference value
     * @return \StructType\Custom_Supplier_Classification_FieldObjectType|null
     */
    public function getSupplier_Classification_Field_Reference()
    {
        return $this->Supplier_Classification_Field_Reference;
    }
    /**
     * Set Supplier_Classification_Field_Reference value
     * @param \StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setSupplier_Classification_Field_Reference(\StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference = null)
    {
        $this->Supplier_Classification_Field_Reference = $supplier_Classification_Field_Reference;
        return $this;
    }
    /**
     * Get Field_Date_Value value
     * @return string|null
     */
    public function getField_Date_Value()
    {
        return $this->Field_Date_Value;
    }
    /**
     * Set Field_Date_Value value
     * @param string $field_Date_Value
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setField_Date_Value($field_Date_Value = null)
    {
        // validation for constraint: string
        if (!is_null($field_Date_Value) && !is_string($field_Date_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field_Date_Value, true), gettype($field_Date_Value)), __LINE__);
        }
        $this->Field_Date_Value = $field_Date_Value;
        return $this;
    }
    /**
     * Get Field_Number_Value value
     * @return float|null
     */
    public function getField_Number_Value()
    {
        return $this->Field_Number_Value;
    }
    /**
     * Set Field_Number_Value value
     * @param float $field_Number_Value
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setField_Number_Value($field_Number_Value = null)
    {
        // validation for constraint: float
        if (!is_null($field_Number_Value) && !(is_float($field_Number_Value) || is_numeric($field_Number_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($field_Number_Value, true), gettype($field_Number_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($field_Number_Value) && mb_strlen(mb_substr($field_Number_Value, false !== mb_strpos($field_Number_Value, '.') ? mb_strpos($field_Number_Value, '.') + 1 : mb_strlen($field_Number_Value))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($field_Number_Value, true), mb_strlen(mb_substr($field_Number_Value, mb_strpos($field_Number_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($field_Number_Value) && $field_Number_Value < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($field_Number_Value, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($field_Number_Value) && mb_strlen(preg_replace('/(\D)/', '', $field_Number_Value)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($field_Number_Value, true), mb_strlen(preg_replace('/(\D)/', '', $field_Number_Value))), __LINE__);
        }
        $this->Field_Number_Value = $field_Number_Value;
        return $this;
    }
    /**
     * Get Field_Text_Value value
     * @return string|null
     */
    public function getField_Text_Value()
    {
        return $this->Field_Text_Value;
    }
    /**
     * Set Field_Text_Value value
     * @param string $field_Text_Value
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setField_Text_Value($field_Text_Value = null)
    {
        // validation for constraint: string
        if (!is_null($field_Text_Value) && !is_string($field_Text_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field_Text_Value, true), gettype($field_Text_Value)), __LINE__);
        }
        $this->Field_Text_Value = $field_Text_Value;
        return $this;
    }
    /**
     * Get Field_Single_Select_Choice_Reference value
     * @return \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType|null
     */
    public function getField_Single_Select_Choice_Reference()
    {
        return $this->Field_Single_Select_Choice_Reference;
    }
    /**
     * Set Field_Single_Select_Choice_Reference value
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $field_Single_Select_Choice_Reference
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setField_Single_Select_Choice_Reference(\StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $field_Single_Select_Choice_Reference = null)
    {
        $this->Field_Single_Select_Choice_Reference = $field_Single_Select_Choice_Reference;
        return $this;
    }
    /**
     * Get Field_Multi_Select_Choice_Reference value
     * @return \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType[]|null
     */
    public function getField_Multi_Select_Choice_Reference()
    {
        return $this->Field_Multi_Select_Choice_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setField_Multi_Select_Choice_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setField_Multi_Select_Choice_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateField_Multi_Select_Choice_ReferenceForArrayConstraintsFromSetField_Multi_Select_Choice_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Field_Interface_DataTypeField_Multi_Select_Choice_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Field_Interface_DataTypeField_Multi_Select_Choice_ReferenceItem instanceof \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType) {
                $invalidValues[] = is_object($supplier_Classification_Field_Interface_DataTypeField_Multi_Select_Choice_ReferenceItem) ? get_class($supplier_Classification_Field_Interface_DataTypeField_Multi_Select_Choice_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Classification_Field_Interface_DataTypeField_Multi_Select_Choice_ReferenceItem), var_export($supplier_Classification_Field_Interface_DataTypeField_Multi_Select_Choice_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Field_Multi_Select_Choice_Reference property can only contain items of type \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Field_Multi_Select_Choice_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType[] $field_Multi_Select_Choice_Reference
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setField_Multi_Select_Choice_Reference(array $field_Multi_Select_Choice_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($field_Multi_Select_Choice_ReferenceArrayErrorMessage = self::validateField_Multi_Select_Choice_ReferenceForArrayConstraintsFromSetField_Multi_Select_Choice_Reference($field_Multi_Select_Choice_Reference))) {
            throw new \InvalidArgumentException($field_Multi_Select_Choice_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Field_Multi_Select_Choice_Reference = $field_Multi_Select_Choice_Reference;
        return $this;
    }
    /**
     * Add item to Field_Multi_Select_Choice_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $item
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function addToField_Multi_Select_Choice_Reference(\StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Field_Multi_Select_Choice_Reference property can only contain items of type \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Field_Multi_Select_Choice_Reference[] = $item;
        return $this;
    }
    /**
     * Get Financials_Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getFinancials_Attachment_Data()
    {
        return $this->Financials_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setFinancials_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancials_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinancials_Attachment_DataForArrayConstraintsFromSetFinancials_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Field_Interface_DataTypeFinancials_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Field_Interface_DataTypeFinancials_Attachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($supplier_Classification_Field_Interface_DataTypeFinancials_Attachment_DataItem) ? get_class($supplier_Classification_Field_Interface_DataTypeFinancials_Attachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Classification_Field_Interface_DataTypeFinancials_Attachment_DataItem), var_export($supplier_Classification_Field_Interface_DataTypeFinancials_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Financials_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Financials_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $financials_Attachment_Data
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function setFinancials_Attachment_Data(array $financials_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($financials_Attachment_DataArrayErrorMessage = self::validateFinancials_Attachment_DataForArrayConstraintsFromSetFinancials_Attachment_Data($financials_Attachment_Data))) {
            throw new \InvalidArgumentException($financials_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Financials_Attachment_Data = $financials_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Financials_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Supplier_Classification_Field_Interface_DataType
     */
    public function addToFinancials_Attachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Financials_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Financials_Attachment_Data[] = $item;
        return $this;
    }
}
