<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_CategoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Category Instance and Data
 * @subpackage Structs
 */
class Supplier_CategoryType extends AbstractStructBase
{
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Category
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType
     */
    public $Supplier_Category_Reference;
    /**
     * The Supplier_Category_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Category Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Category_DataType[]
     */
    public $Supplier_Category_Data;
    /**
     * Constructor method for Supplier_CategoryType
     * @uses Supplier_CategoryType::setSupplier_Category_Reference()
     * @uses Supplier_CategoryType::setSupplier_Category_Data()
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @param \StructType\Supplier_Category_DataType[] $supplier_Category_Data
     */
    public function __construct(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null, array $supplier_Category_Data = array())
    {
        $this
            ->setSupplier_Category_Reference($supplier_Category_Reference)
            ->setSupplier_Category_Data($supplier_Category_Data);
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * Set Supplier_Category_Reference value
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @return \StructType\Supplier_CategoryType
     */
    public function setSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null)
    {
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Get Supplier_Category_Data value
     * @return \StructType\Supplier_Category_DataType[]|null
     */
    public function getSupplier_Category_Data()
    {
        return $this->Supplier_Category_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Category_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Category_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Category_DataForArrayConstraintsFromSetSupplier_Category_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_CategoryTypeSupplier_Category_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_CategoryTypeSupplier_Category_DataItem instanceof \StructType\Supplier_Category_DataType) {
                $invalidValues[] = is_object($supplier_CategoryTypeSupplier_Category_DataItem) ? get_class($supplier_CategoryTypeSupplier_Category_DataItem) : sprintf('%s(%s)', gettype($supplier_CategoryTypeSupplier_Category_DataItem), var_export($supplier_CategoryTypeSupplier_Category_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Category_Data property can only contain items of type \StructType\Supplier_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Category_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Category_DataType[] $supplier_Category_Data
     * @return \StructType\Supplier_CategoryType
     */
    public function setSupplier_Category_Data(array $supplier_Category_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Category_DataArrayErrorMessage = self::validateSupplier_Category_DataForArrayConstraintsFromSetSupplier_Category_Data($supplier_Category_Data))) {
            throw new \InvalidArgumentException($supplier_Category_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Category_Data = $supplier_Category_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Category_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Category_DataType $item
     * @return \StructType\Supplier_CategoryType
     */
    public function addToSupplier_Category_Data(\StructType\Supplier_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Category_Data property can only contain items of type \StructType\Supplier_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Category_Data[] = $item;
        return $this;
    }
}
