<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Catalog_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Catalog response data for requested references.
 * @subpackage Structs
 */
class Supplier_Catalog_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Catalog
     * Meta information extracted from the WSDL
     * - documentation: Element containing Supplier Catalog data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CatalogType[]
     */
    public $Supplier_Catalog;
    /**
     * Constructor method for Supplier_Catalog_Response_DataType
     * @uses Supplier_Catalog_Response_DataType::setSupplier_Catalog()
     * @param \StructType\Supplier_CatalogType[] $supplier_Catalog
     */
    public function __construct(array $supplier_Catalog = array())
    {
        $this
            ->setSupplier_Catalog($supplier_Catalog);
    }
    /**
     * Get Supplier_Catalog value
     * @return \StructType\Supplier_CatalogType[]|null
     */
    public function getSupplier_Catalog()
    {
        return $this->Supplier_Catalog;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Catalog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Catalog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_CatalogForArrayConstraintsFromSetSupplier_Catalog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Catalog_Response_DataTypeSupplier_CatalogItem) {
            // validation for constraint: itemType
            if (!$supplier_Catalog_Response_DataTypeSupplier_CatalogItem instanceof \StructType\Supplier_CatalogType) {
                $invalidValues[] = is_object($supplier_Catalog_Response_DataTypeSupplier_CatalogItem) ? get_class($supplier_Catalog_Response_DataTypeSupplier_CatalogItem) : sprintf('%s(%s)', gettype($supplier_Catalog_Response_DataTypeSupplier_CatalogItem), var_export($supplier_Catalog_Response_DataTypeSupplier_CatalogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Catalog property can only contain items of type \StructType\Supplier_CatalogType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Catalog value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogType[] $supplier_Catalog
     * @return \StructType\Supplier_Catalog_Response_DataType
     */
    public function setSupplier_Catalog(array $supplier_Catalog = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_CatalogArrayErrorMessage = self::validateSupplier_CatalogForArrayConstraintsFromSetSupplier_Catalog($supplier_Catalog))) {
            throw new \InvalidArgumentException($supplier_CatalogArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Catalog = $supplier_Catalog;
        return $this;
    }
    /**
     * Add item to Supplier_Catalog value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogType $item
     * @return \StructType\Supplier_Catalog_Response_DataType
     */
    public function addToSupplier_Catalog(\StructType\Supplier_CatalogType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CatalogType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Catalog property can only contain items of type \StructType\Supplier_CatalogType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Catalog[] = $item;
        return $this;
    }
}
