<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Refund_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element contains Supplier Refund Business Processing options, Supplier Refund Reference for update, Add Only to indicate if this operation is add-only, and all Supplier Refund data items required to create a complete Supplier Refund.
 * @subpackage Structs
 */
class Submit_Supplier_Refund_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Refund_Reference
     * Meta information extracted from the WSDL
     * - documentation: An existing supplier refund. Use this value for updates only.
     * - minOccurs: 0
     * @var \StructType\Supplier_RefundObjectType
     */
    public $Supplier_Refund_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Refund_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Refund Data
     * - minOccurs: 0
     * @var \StructType\Supplier_Refund_DataType
     */
    public $Supplier_Refund_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Refund_RequestType
     * @uses Submit_Supplier_Refund_RequestType::setSupplier_Refund_Reference()
     * @uses Submit_Supplier_Refund_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_Refund_RequestType::setSupplier_Refund_Data()
     * @uses Submit_Supplier_Refund_RequestType::setAdd_Only()
     * @uses Submit_Supplier_Refund_RequestType::setVersion()
     * @param \StructType\Supplier_RefundObjectType $supplier_Refund_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_Refund_DataType $supplier_Refund_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_RefundObjectType $supplier_Refund_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_Refund_DataType $supplier_Refund_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Refund_Reference($supplier_Refund_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Refund_Data($supplier_Refund_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Refund_Reference value
     * @return \StructType\Supplier_RefundObjectType|null
     */
    public function getSupplier_Refund_Reference()
    {
        return $this->Supplier_Refund_Reference;
    }
    /**
     * Set Supplier_Refund_Reference value
     * @param \StructType\Supplier_RefundObjectType $supplier_Refund_Reference
     * @return \StructType\Submit_Supplier_Refund_RequestType
     */
    public function setSupplier_Refund_Reference(\StructType\Supplier_RefundObjectType $supplier_Refund_Reference = null)
    {
        $this->Supplier_Refund_Reference = $supplier_Refund_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Supplier_Refund_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Refund_Data value
     * @return \StructType\Supplier_Refund_DataType|null
     */
    public function getSupplier_Refund_Data()
    {
        return $this->Supplier_Refund_Data;
    }
    /**
     * Set Supplier_Refund_Data value
     * @param \StructType\Supplier_Refund_DataType $supplier_Refund_Data
     * @return \StructType\Submit_Supplier_Refund_RequestType
     */
    public function setSupplier_Refund_Data(\StructType\Supplier_Refund_DataType $supplier_Refund_Data = null)
    {
        $this->Supplier_Refund_Data = $supplier_Refund_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Supplier_Refund_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Refund_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
