<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Contract_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't update the Supplier Contract sourced from a Requisition using this Web Service. | Supplier Contract cannot be updated using this Web Service. It has either already been Amended, or there are related Schedules or Business
 * Documents using the Contract. Or the Contract has been denied, closed or canceled. Or the Contract has accounting journal generated. | Create a new Supplier Contract, or change 'Add Only' to 'false' to edit the Supplier Contract. | Element containing
 * Supplier Contract reference for update and all Supplier Contract data items.
 * @subpackage Structs
 */
class Submit_Supplier_Contract_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Contract_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Data
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_DataType
     */
    public $Supplier_Contract_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Contract_RequestType
     * @uses Submit_Supplier_Contract_RequestType::setSupplier_Contract_Reference()
     * @uses Submit_Supplier_Contract_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_Contract_RequestType::setSupplier_Contract_Data()
     * @uses Submit_Supplier_Contract_RequestType::setAdd_Only()
     * @uses Submit_Supplier_Contract_RequestType::setVersion()
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_Contract_DataType $supplier_Contract_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_Contract_DataType $supplier_Contract_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Contract_Data($supplier_Contract_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Submit_Supplier_Contract_RequestType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Supplier_Contract_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Contract_Data value
     * @return \StructType\Supplier_Contract_DataType|null
     */
    public function getSupplier_Contract_Data()
    {
        return $this->Supplier_Contract_Data;
    }
    /**
     * Set Supplier_Contract_Data value
     * @param \StructType\Supplier_Contract_DataType $supplier_Contract_Data
     * @return \StructType\Submit_Supplier_Contract_RequestType
     */
    public function setSupplier_Contract_Data(\StructType\Supplier_Contract_DataType $supplier_Contract_Data = null)
    {
        $this->Supplier_Contract_Data = $supplier_Contract_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Supplier_Contract_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Contract_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
