<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Request_for_Quote_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing Request for Quote reference for update, Request for Quote Business Processing Options, Flag to indicate if this operation is add only and all
 * Request for Quote data items required to create a Request for Quote.
 * @subpackage Structs
 */
class Submit_Request_for_Quote_RequestType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Request for Quote.
     * - minOccurs: 0
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $Request_for_Quote_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Request_for_Quote_Data
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Data.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_DataType
     */
    public $Request_for_Quote_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Request_for_Quote_RequestType
     * @uses Submit_Request_for_Quote_RequestType::setRequest_for_Quote_Reference()
     * @uses Submit_Request_for_Quote_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Request_for_Quote_RequestType::setRequest_for_Quote_Data()
     * @uses Submit_Request_for_Quote_RequestType::setAdd_Only()
     * @uses Submit_Request_for_Quote_RequestType::setVersion()
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Request_for_Quote_DataType $request_for_Quote_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Request_for_Quote_DataType $request_for_Quote_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRequest_for_Quote_Reference($request_for_Quote_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setRequest_for_Quote_Data($request_for_Quote_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Request_for_Quote_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRequest_for_Quote_Reference()
    {
        return $this->Request_for_Quote_Reference;
    }
    /**
     * Set Request_for_Quote_Reference value
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @return \StructType\Submit_Request_for_Quote_RequestType
     */
    public function setRequest_for_Quote_Reference(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null)
    {
        $this->Request_for_Quote_Reference = $request_for_Quote_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Request_for_Quote_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Request_for_Quote_Data value
     * @return \StructType\Request_for_Quote_DataType|null
     */
    public function getRequest_for_Quote_Data()
    {
        return $this->Request_for_Quote_Data;
    }
    /**
     * Set Request_for_Quote_Data value
     * @param \StructType\Request_for_Quote_DataType $request_for_Quote_Data
     * @return \StructType\Submit_Request_for_Quote_RequestType
     */
    public function setRequest_for_Quote_Data(\StructType\Request_for_Quote_DataType $request_for_Quote_Data = null)
    {
        $this->Request_for_Quote_Data = $request_for_Quote_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Request_for_Quote_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Request_for_Quote_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
