<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Receipt_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This Receipt is not in Draft Status so it cannot be submitted. | The Web Service is set to Add Only; documents cannot be resubmitted. This may happen if you have a Receipt Number field that conflicts with an existing Receipt, or if
 * you have both the Add Only flag on and pass in a Receipt Reference. | Submit Receipt Request. Only goods and contingent worker receipt items can be submitted, but not for the same receipt.
 * @subpackage Structs
 */
class Submit_Receipt_RequestType extends AbstractStructBase
{
    /**
     * The Receipt_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receipt .
     * - minOccurs: 0
     * @var \StructType\ReceiptObjectType
     */
    public $Receipt_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Receipt_Data
     * Meta information extracted from the WSDL
     * - documentation: Receipt Data
     * - minOccurs: 0
     * @var \StructType\Receipt_DataType
     */
    public $Receipt_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Receipt_RequestType
     * @uses Submit_Receipt_RequestType::setReceipt_Reference()
     * @uses Submit_Receipt_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Receipt_RequestType::setReceipt_Data()
     * @uses Submit_Receipt_RequestType::setAdd_Only()
     * @uses Submit_Receipt_RequestType::setVersion()
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Receipt_DataType $receipt_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\ReceiptObjectType $receipt_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Receipt_DataType $receipt_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setReceipt_Reference($receipt_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setReceipt_Data($receipt_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Receipt_Reference value
     * @return \StructType\ReceiptObjectType|null
     */
    public function getReceipt_Reference()
    {
        return $this->Receipt_Reference;
    }
    /**
     * Set Receipt_Reference value
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @return \StructType\Submit_Receipt_RequestType
     */
    public function setReceipt_Reference(\StructType\ReceiptObjectType $receipt_Reference = null)
    {
        $this->Receipt_Reference = $receipt_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Receipt_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Receipt_Data value
     * @return \StructType\Receipt_DataType|null
     */
    public function getReceipt_Data()
    {
        return $this->Receipt_Data;
    }
    /**
     * Set Receipt_Data value
     * @param \StructType\Receipt_DataType $receipt_Data
     * @return \StructType\Submit_Receipt_RequestType
     */
    public function setReceipt_Data(\StructType\Receipt_DataType $receipt_Data = null)
    {
        $this->Receipt_Data = $receipt_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Receipt_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Receipt_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
