<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Order_From_Supplier_Connection_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Submit Order From Supplier Connection Response Data
 * @subpackage Structs
 */
class Submit_Order_From_Supplier_Connection_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Connection_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_Connection_DataType
     */
    public $Supplier_Connection_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Order_From_Supplier_Connection_ResponseType
     * @uses Submit_Order_From_Supplier_Connection_ResponseType::setSupplier_Reference()
     * @uses Submit_Order_From_Supplier_Connection_ResponseType::setSupplier_Connection_Data()
     * @uses Submit_Order_From_Supplier_Connection_ResponseType::setVersion()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Order_From_Supplier_Connection_DataType $supplier_Connection_Data
     * @param string $version
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Order_From_Supplier_Connection_DataType $supplier_Connection_Data = null, $version = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Connection_Data($supplier_Connection_Data)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Submit_Order_From_Supplier_Connection_ResponseType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_Data value
     * @return \StructType\Order_From_Supplier_Connection_DataType|null
     */
    public function getSupplier_Connection_Data()
    {
        return $this->Supplier_Connection_Data;
    }
    /**
     * Set Supplier_Connection_Data value
     * @param \StructType\Order_From_Supplier_Connection_DataType $supplier_Connection_Data
     * @return \StructType\Submit_Order_From_Supplier_Connection_ResponseType
     */
    public function setSupplier_Connection_Data(\StructType\Order_From_Supplier_Connection_DataType $supplier_Connection_Data = null)
    {
        $this->Supplier_Connection_Data = $supplier_Connection_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Order_From_Supplier_Connection_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
