<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_Hierarchy_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Spend Category Hierarchy
 * @subpackage Structs
 */
class Spend_Category_Hierarchy_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Spend_Category_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category Hierarchy.
     * - maxOccurs: unbounded
     * @var \StructType\Spend_Category_HierarchyObjectType[]
     */
    public $Spend_Category_Hierarchy_Reference;
    /**
     * Constructor method for Spend_Category_Hierarchy_Request_ReferencesType
     * @uses Spend_Category_Hierarchy_Request_ReferencesType::setSpend_Category_Hierarchy_Reference()
     * @param \StructType\Spend_Category_HierarchyObjectType[] $spend_Category_Hierarchy_Reference
     */
    public function __construct(array $spend_Category_Hierarchy_Reference = array())
    {
        $this
            ->setSpend_Category_Hierarchy_Reference($spend_Category_Hierarchy_Reference);
    }
    /**
     * Get Spend_Category_Hierarchy_Reference value
     * @return \StructType\Spend_Category_HierarchyObjectType[]|null
     */
    public function getSpend_Category_Hierarchy_Reference()
    {
        return $this->Spend_Category_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_Hierarchy_Request_ReferencesTypeSpend_Category_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Category_Hierarchy_Request_ReferencesTypeSpend_Category_Hierarchy_ReferenceItem instanceof \StructType\Spend_Category_HierarchyObjectType) {
                $invalidValues[] = is_object($spend_Category_Hierarchy_Request_ReferencesTypeSpend_Category_Hierarchy_ReferenceItem) ? get_class($spend_Category_Hierarchy_Request_ReferencesTypeSpend_Category_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Category_Hierarchy_Request_ReferencesTypeSpend_Category_Hierarchy_ReferenceItem), var_export($spend_Category_Hierarchy_Request_ReferencesTypeSpend_Category_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_HierarchyObjectType[] $spend_Category_Hierarchy_Reference
     * @return \StructType\Spend_Category_Hierarchy_Request_ReferencesType
     */
    public function setSpend_Category_Hierarchy_Reference(array $spend_Category_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_Hierarchy_ReferenceArrayErrorMessage = self::validateSpend_Category_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_Hierarchy_Reference($spend_Category_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($spend_Category_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Hierarchy_Reference = $spend_Category_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_HierarchyObjectType $item
     * @return \StructType\Spend_Category_Hierarchy_Request_ReferencesType
     */
    public function addToSpend_Category_Hierarchy_Reference(\StructType\Spend_Category_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Hierarchy_Reference[] = $item;
        return $this;
    }
}
