<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_Hierarchy_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Spend Category Hierarchy data
 * @subpackage Structs
 */
class Spend_Category_Hierarchy_DataType extends AbstractStructBase
{
    /**
     * The Spend_Category_Hierarchy_ID
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Reference Hierarchy ID. This is the Spend Category Hierarchy unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Category_Hierarchy_ID;
    /**
     * The Spend_Category_Hierarchy_Names
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for a meaningful Spend Category Hierarchy Name
     * - maxOccurs: 1
     * @var string
     */
    public $Spend_Category_Hierarchy_Names;
    /**
     * The Hierarchy_Level_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hierarchy Level needs to be valid for Spend Category Hierarchy. | Reference to an existing Hierarchy Level valid for Spend Category Hierarchies.
     * - minOccurs: 0
     * @var \StructType\Hierarchy_LevelObjectType
     */
    public $Hierarchy_Level_Reference;
    /**
     * The Parent_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the parent Spend Category Hierarchy.
     * - minOccurs: 0
     * @var \StructType\Spend_Category_HierarchyObjectType
     */
    public $Parent_Reference;
    /**
     * The Enable_for_External_Website
     * Meta information extracted from the WSDL
     * - documentation: As long as the parent hierarchy is enabled for this external website, this hierarchy must also be enabled. | If true, the spend categories included in this spend category hierarchy will be exposed on the supplier registration
     * external website. If false, they will not be exposed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_for_External_Website;
    /**
     * The Included_Spend_Categories_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Categories that are included in this Spend Category Hierarchy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Included_Spend_Categories_Reference;
    /**
     * The Commodity_Detail
     * Meta information extracted from the WSDL
     * - documentation: The commodity detail for the spend category. This field can be used as an alternative display name or code value to search for a spend category or spend category hierarchy in Workday.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Commodity_Detail;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description that is used in conjunction with the Commodity Code field.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Unable to inactivate this hierarchy because there are active included spend categories. Please move or inactivate them first. | Unable to inactivate this hierarchy because there are active child spend category hierarchies. Please
     * move or inactivate them first. | True if the Spend Category Hierarchy is Inactive. False otherwise.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Spend_Category_Hierarchy_Display_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Determines how the Spend Category Hierarchy label is displayed.
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType
     */
    public $Spend_Category_Hierarchy_Display_Option_Reference;
    /**
     * Constructor method for Spend_Category_Hierarchy_DataType
     * @uses Spend_Category_Hierarchy_DataType::setSpend_Category_Hierarchy_ID()
     * @uses Spend_Category_Hierarchy_DataType::setSpend_Category_Hierarchy_Names()
     * @uses Spend_Category_Hierarchy_DataType::setHierarchy_Level_Reference()
     * @uses Spend_Category_Hierarchy_DataType::setParent_Reference()
     * @uses Spend_Category_Hierarchy_DataType::setEnable_for_External_Website()
     * @uses Spend_Category_Hierarchy_DataType::setIncluded_Spend_Categories_Reference()
     * @uses Spend_Category_Hierarchy_DataType::setCommodity_Detail()
     * @uses Spend_Category_Hierarchy_DataType::setDescription()
     * @uses Spend_Category_Hierarchy_DataType::setInactive()
     * @uses Spend_Category_Hierarchy_DataType::setSpend_Category_Hierarchy_Display_Option_Reference()
     * @param string $spend_Category_Hierarchy_ID
     * @param string $spend_Category_Hierarchy_Names
     * @param \StructType\Hierarchy_LevelObjectType $hierarchy_Level_Reference
     * @param \StructType\Spend_Category_HierarchyObjectType $parent_Reference
     * @param bool $enable_for_External_Website
     * @param \StructType\Spend_CategoryObjectType[] $included_Spend_Categories_Reference
     * @param string $commodity_Detail
     * @param string $description
     * @param bool $inactive
     * @param \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Hierarchy_Display_Option_Reference
     */
    public function __construct($spend_Category_Hierarchy_ID = null, $spend_Category_Hierarchy_Names = null, \StructType\Hierarchy_LevelObjectType $hierarchy_Level_Reference = null, \StructType\Spend_Category_HierarchyObjectType $parent_Reference = null, $enable_for_External_Website = null, array $included_Spend_Categories_Reference = array(), $commodity_Detail = null, $description = null, $inactive = null, \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Hierarchy_Display_Option_Reference = null)
    {
        $this
            ->setSpend_Category_Hierarchy_ID($spend_Category_Hierarchy_ID)
            ->setSpend_Category_Hierarchy_Names($spend_Category_Hierarchy_Names)
            ->setHierarchy_Level_Reference($hierarchy_Level_Reference)
            ->setParent_Reference($parent_Reference)
            ->setEnable_for_External_Website($enable_for_External_Website)
            ->setIncluded_Spend_Categories_Reference($included_Spend_Categories_Reference)
            ->setCommodity_Detail($commodity_Detail)
            ->setDescription($description)
            ->setInactive($inactive)
            ->setSpend_Category_Hierarchy_Display_Option_Reference($spend_Category_Hierarchy_Display_Option_Reference);
    }
    /**
     * Get Spend_Category_Hierarchy_ID value
     * @return string|null
     */
    public function getSpend_Category_Hierarchy_ID()
    {
        return $this->Spend_Category_Hierarchy_ID;
    }
    /**
     * Set Spend_Category_Hierarchy_ID value
     * @param string $spend_Category_Hierarchy_ID
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setSpend_Category_Hierarchy_ID($spend_Category_Hierarchy_ID = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Category_Hierarchy_ID) && !is_string($spend_Category_Hierarchy_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Category_Hierarchy_ID, true), gettype($spend_Category_Hierarchy_ID)), __LINE__);
        }
        $this->Spend_Category_Hierarchy_ID = $spend_Category_Hierarchy_ID;
        return $this;
    }
    /**
     * Get Spend_Category_Hierarchy_Names value
     * @return string|null
     */
    public function getSpend_Category_Hierarchy_Names()
    {
        return $this->Spend_Category_Hierarchy_Names;
    }
    /**
     * Set Spend_Category_Hierarchy_Names value
     * @param string $spend_Category_Hierarchy_Names
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setSpend_Category_Hierarchy_Names($spend_Category_Hierarchy_Names = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Category_Hierarchy_Names) && !is_string($spend_Category_Hierarchy_Names)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Category_Hierarchy_Names, true), gettype($spend_Category_Hierarchy_Names)), __LINE__);
        }
        $this->Spend_Category_Hierarchy_Names = $spend_Category_Hierarchy_Names;
        return $this;
    }
    /**
     * Get Hierarchy_Level_Reference value
     * @return \StructType\Hierarchy_LevelObjectType|null
     */
    public function getHierarchy_Level_Reference()
    {
        return $this->Hierarchy_Level_Reference;
    }
    /**
     * Set Hierarchy_Level_Reference value
     * @param \StructType\Hierarchy_LevelObjectType $hierarchy_Level_Reference
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setHierarchy_Level_Reference(\StructType\Hierarchy_LevelObjectType $hierarchy_Level_Reference = null)
    {
        $this->Hierarchy_Level_Reference = $hierarchy_Level_Reference;
        return $this;
    }
    /**
     * Get Parent_Reference value
     * @return \StructType\Spend_Category_HierarchyObjectType|null
     */
    public function getParent_Reference()
    {
        return $this->Parent_Reference;
    }
    /**
     * Set Parent_Reference value
     * @param \StructType\Spend_Category_HierarchyObjectType $parent_Reference
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setParent_Reference(\StructType\Spend_Category_HierarchyObjectType $parent_Reference = null)
    {
        $this->Parent_Reference = $parent_Reference;
        return $this;
    }
    /**
     * Get Enable_for_External_Website value
     * @return bool|null
     */
    public function getEnable_for_External_Website()
    {
        return $this->Enable_for_External_Website;
    }
    /**
     * Set Enable_for_External_Website value
     * @param bool $enable_for_External_Website
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setEnable_for_External_Website($enable_for_External_Website = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_for_External_Website) && !is_bool($enable_for_External_Website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_for_External_Website, true), gettype($enable_for_External_Website)), __LINE__);
        }
        $this->Enable_for_External_Website = $enable_for_External_Website;
        return $this;
    }
    /**
     * Get Included_Spend_Categories_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getIncluded_Spend_Categories_Reference()
    {
        return $this->Included_Spend_Categories_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIncluded_Spend_Categories_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncluded_Spend_Categories_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncluded_Spend_Categories_ReferenceForArrayConstraintsFromSetIncluded_Spend_Categories_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_Hierarchy_DataTypeIncluded_Spend_Categories_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Category_Hierarchy_DataTypeIncluded_Spend_Categories_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($spend_Category_Hierarchy_DataTypeIncluded_Spend_Categories_ReferenceItem) ? get_class($spend_Category_Hierarchy_DataTypeIncluded_Spend_Categories_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Category_Hierarchy_DataTypeIncluded_Spend_Categories_ReferenceItem), var_export($spend_Category_Hierarchy_DataTypeIncluded_Spend_Categories_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Included_Spend_Categories_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Included_Spend_Categories_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $included_Spend_Categories_Reference
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setIncluded_Spend_Categories_Reference(array $included_Spend_Categories_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($included_Spend_Categories_ReferenceArrayErrorMessage = self::validateIncluded_Spend_Categories_ReferenceForArrayConstraintsFromSetIncluded_Spend_Categories_Reference($included_Spend_Categories_Reference))) {
            throw new \InvalidArgumentException($included_Spend_Categories_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Included_Spend_Categories_Reference = $included_Spend_Categories_Reference;
        return $this;
    }
    /**
     * Add item to Included_Spend_Categories_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function addToIncluded_Spend_Categories_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Included_Spend_Categories_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Included_Spend_Categories_Reference[] = $item;
        return $this;
    }
    /**
     * Get Commodity_Detail value
     * @return string|null
     */
    public function getCommodity_Detail()
    {
        return $this->Commodity_Detail;
    }
    /**
     * Set Commodity_Detail value
     * @param string $commodity_Detail
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setCommodity_Detail($commodity_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($commodity_Detail) && !is_string($commodity_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodity_Detail, true), gettype($commodity_Detail)), __LINE__);
        }
        $this->Commodity_Detail = $commodity_Detail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Spend_Category_Hierarchy_Display_Option_Reference value
     * @return \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType|null
     */
    public function getSpend_Category_Hierarchy_Display_Option_Reference()
    {
        return $this->Spend_Category_Hierarchy_Display_Option_Reference;
    }
    /**
     * Set Spend_Category_Hierarchy_Display_Option_Reference value
     * @param \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Hierarchy_Display_Option_Reference
     * @return \StructType\Spend_Category_Hierarchy_DataType
     */
    public function setSpend_Category_Hierarchy_Display_Option_Reference(\StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Hierarchy_Display_Option_Reference = null)
    {
        $this->Spend_Category_Hierarchy_Display_Option_Reference = $spend_Category_Hierarchy_Display_Option_Reference;
        return $this;
    }
}
