<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_AuthorizationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Spend Authorization instance and data
 * @subpackage Structs
 */
class Spend_AuthorizationType extends AbstractStructBase
{
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Reference
     * - minOccurs: 0
     * @var \StructType\Spend_AuthorizationObjectType
     */
    public $Spend_Authorization_Reference;
    /**
     * The Spend_Authorization_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that encapsulates all the data related to the Spend Authorization.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Authorization_DataType[]
     */
    public $Spend_Authorization_Data;
    /**
     * Constructor method for Spend_AuthorizationType
     * @uses Spend_AuthorizationType::setSpend_Authorization_Reference()
     * @uses Spend_AuthorizationType::setSpend_Authorization_Data()
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @param \StructType\Spend_Authorization_DataType[] $spend_Authorization_Data
     */
    public function __construct(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null, array $spend_Authorization_Data = array())
    {
        $this
            ->setSpend_Authorization_Reference($spend_Authorization_Reference)
            ->setSpend_Authorization_Data($spend_Authorization_Data);
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @return \StructType\Spend_AuthorizationType
     */
    public function setSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null)
    {
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Get Spend_Authorization_Data value
     * @return \StructType\Spend_Authorization_DataType[]|null
     */
    public function getSpend_Authorization_Data()
    {
        return $this->Spend_Authorization_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Authorization_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Authorization_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Authorization_DataForArrayConstraintsFromSetSpend_Authorization_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_AuthorizationTypeSpend_Authorization_DataItem) {
            // validation for constraint: itemType
            if (!$spend_AuthorizationTypeSpend_Authorization_DataItem instanceof \StructType\Spend_Authorization_DataType) {
                $invalidValues[] = is_object($spend_AuthorizationTypeSpend_Authorization_DataItem) ? get_class($spend_AuthorizationTypeSpend_Authorization_DataItem) : sprintf('%s(%s)', gettype($spend_AuthorizationTypeSpend_Authorization_DataItem), var_export($spend_AuthorizationTypeSpend_Authorization_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Authorization_Data property can only contain items of type \StructType\Spend_Authorization_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Authorization_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Authorization_DataType[] $spend_Authorization_Data
     * @return \StructType\Spend_AuthorizationType
     */
    public function setSpend_Authorization_Data(array $spend_Authorization_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Authorization_DataArrayErrorMessage = self::validateSpend_Authorization_DataForArrayConstraintsFromSetSpend_Authorization_Data($spend_Authorization_Data))) {
            throw new \InvalidArgumentException($spend_Authorization_DataArrayErrorMessage, __LINE__);
        }
        $this->Spend_Authorization_Data = $spend_Authorization_Data;
        return $this;
    }
    /**
     * Add item to Spend_Authorization_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Authorization_DataType $item
     * @return \StructType\Spend_AuthorizationType
     */
    public function addToSpend_Authorization_Data(\StructType\Spend_Authorization_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Authorization_DataType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Authorization_Data property can only contain items of type \StructType\Spend_Authorization_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Authorization_Data[] = $item;
        return $this;
    }
}
