<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Settlement_Account_WWS_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for all Bank Accounts. Here the customer can define if Bank Accounts are meant to be replaced by the ones on the request or added/deleted in a more granular way.
 * @subpackage Structs
 */
class Settlement_Account_WWS_Widget_DataType extends AbstractStructBase
{
    /**
     * The Settlement_Account_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Settlement_Bank_Account_WWS_DataType[]
     */
    public $Settlement_Account_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to True if you wish to allow the Settlement Bank Accounts to be Added or individually deleted, otherwise all of this object's Bank Accounts will be deleted and replaced by the bank accounts sent in the request.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Settlement_Account_WWS_Widget_DataType
     * @uses Settlement_Account_WWS_Widget_DataType::setSettlement_Account_Data()
     * @uses Settlement_Account_WWS_Widget_DataType::setReplace_All()
     * @param \StructType\Settlement_Bank_Account_WWS_DataType[] $settlement_Account_Data
     * @param bool $replace_All
     */
    public function __construct(array $settlement_Account_Data = array(), $replace_All = null)
    {
        $this
            ->setSettlement_Account_Data($settlement_Account_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Settlement_Account_Data value
     * @return \StructType\Settlement_Bank_Account_WWS_DataType[]|null
     */
    public function getSettlement_Account_Data()
    {
        return $this->Settlement_Account_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSettlement_Account_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlement_Account_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSettlement_Account_DataForArrayConstraintsFromSetSettlement_Account_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlement_Account_WWS_Widget_DataTypeSettlement_Account_DataItem) {
            // validation for constraint: itemType
            if (!$settlement_Account_WWS_Widget_DataTypeSettlement_Account_DataItem instanceof \StructType\Settlement_Bank_Account_WWS_DataType) {
                $invalidValues[] = is_object($settlement_Account_WWS_Widget_DataTypeSettlement_Account_DataItem) ? get_class($settlement_Account_WWS_Widget_DataTypeSettlement_Account_DataItem) : sprintf('%s(%s)', gettype($settlement_Account_WWS_Widget_DataTypeSettlement_Account_DataItem), var_export($settlement_Account_WWS_Widget_DataTypeSettlement_Account_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Settlement_Account_Data property can only contain items of type \StructType\Settlement_Bank_Account_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Settlement_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Settlement_Bank_Account_WWS_DataType[] $settlement_Account_Data
     * @return \StructType\Settlement_Account_WWS_Widget_DataType
     */
    public function setSettlement_Account_Data(array $settlement_Account_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($settlement_Account_DataArrayErrorMessage = self::validateSettlement_Account_DataForArrayConstraintsFromSetSettlement_Account_Data($settlement_Account_Data))) {
            throw new \InvalidArgumentException($settlement_Account_DataArrayErrorMessage, __LINE__);
        }
        $this->Settlement_Account_Data = $settlement_Account_Data;
        return $this;
    }
    /**
     * Add item to Settlement_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Settlement_Bank_Account_WWS_DataType $item
     * @return \StructType\Settlement_Account_WWS_Widget_DataType
     */
    public function addToSettlement_Account_Data(\StructType\Settlement_Bank_Account_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Settlement_Bank_Account_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Settlement_Account_Data property can only contain items of type \StructType\Settlement_Bank_Account_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Settlement_Account_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Settlement_Account_WWS_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
