<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the detailed information about a resource plan template.
 * @subpackage Structs
 */
class Resource_Plan_Template_DataType extends AbstractStructBase
{
    /**
     * The Template_ID
     * Meta information extracted from the WSDL
     * - documentation: Project Resource Plan Template ID. This is the Project Resource Plan Template unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Template_ID;
    /**
     * The Template_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for a meaningful Resource Plan Template Name
     * - maxOccurs: 1
     * @var string
     */
    public $Template_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text field describing Project Resource Plan Template
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Owner_Reference
     * Meta information extracted from the WSDL
     * - documentation: Template Owner Reference
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Owner_Reference;
    /**
     * The Use_Date_Offset
     * Meta information extracted from the WSDL
     * - documentation: Boolean value that says whether the appropriate dates should be offset by a specified Date Offset
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Date_Offset;
    /**
     * The Date_Offset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Field that specifies the increment (Days/Months, etc.) for the specified Date Offset when it's applied to the appropriate dates
     * - minOccurs: 0
     * @var \StructType\Project_Template_Date_Offset_TypeObjectType
     */
    public $Date_Offset_Type_Reference;
    /**
     * The Resource_Plan_Detail_for_Template_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains project resource plan detail template information, such as worker, percent allocation, currency, etc.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Plan_Detail_for_Template_DataType[]
     */
    public $Resource_Plan_Detail_for_Template_Data;
    /**
     * Constructor method for Resource_Plan_Template_DataType
     * @uses Resource_Plan_Template_DataType::setTemplate_ID()
     * @uses Resource_Plan_Template_DataType::setTemplate_Name()
     * @uses Resource_Plan_Template_DataType::setDescription()
     * @uses Resource_Plan_Template_DataType::setOwner_Reference()
     * @uses Resource_Plan_Template_DataType::setUse_Date_Offset()
     * @uses Resource_Plan_Template_DataType::setDate_Offset_Type_Reference()
     * @uses Resource_Plan_Template_DataType::setResource_Plan_Detail_for_Template_Data()
     * @param string $template_ID
     * @param string $template_Name
     * @param string $description
     * @param \StructType\WorkerObjectType $owner_Reference
     * @param bool $use_Date_Offset
     * @param \StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Type_Reference
     * @param \StructType\Resource_Plan_Detail_for_Template_DataType[] $resource_Plan_Detail_for_Template_Data
     */
    public function __construct($template_ID = null, $template_Name = null, $description = null, \StructType\WorkerObjectType $owner_Reference = null, $use_Date_Offset = null, \StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Type_Reference = null, array $resource_Plan_Detail_for_Template_Data = array())
    {
        $this
            ->setTemplate_ID($template_ID)
            ->setTemplate_Name($template_Name)
            ->setDescription($description)
            ->setOwner_Reference($owner_Reference)
            ->setUse_Date_Offset($use_Date_Offset)
            ->setDate_Offset_Type_Reference($date_Offset_Type_Reference)
            ->setResource_Plan_Detail_for_Template_Data($resource_Plan_Detail_for_Template_Data);
    }
    /**
     * Get Template_ID value
     * @return string|null
     */
    public function getTemplate_ID()
    {
        return $this->Template_ID;
    }
    /**
     * Set Template_ID value
     * @param string $template_ID
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setTemplate_ID($template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($template_ID) && !is_string($template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_ID, true), gettype($template_ID)), __LINE__);
        }
        $this->Template_ID = $template_ID;
        return $this;
    }
    /**
     * Get Template_Name value
     * @return string|null
     */
    public function getTemplate_Name()
    {
        return $this->Template_Name;
    }
    /**
     * Set Template_Name value
     * @param string $template_Name
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setTemplate_Name($template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Name) && !is_string($template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Name, true), gettype($template_Name)), __LINE__);
        }
        $this->Template_Name = $template_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Owner_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getOwner_Reference()
    {
        return $this->Owner_Reference;
    }
    /**
     * Set Owner_Reference value
     * @param \StructType\WorkerObjectType $owner_Reference
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setOwner_Reference(\StructType\WorkerObjectType $owner_Reference = null)
    {
        $this->Owner_Reference = $owner_Reference;
        return $this;
    }
    /**
     * Get Use_Date_Offset value
     * @return bool|null
     */
    public function getUse_Date_Offset()
    {
        return $this->Use_Date_Offset;
    }
    /**
     * Set Use_Date_Offset value
     * @param bool $use_Date_Offset
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setUse_Date_Offset($use_Date_Offset = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Date_Offset) && !is_bool($use_Date_Offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Date_Offset, true), gettype($use_Date_Offset)), __LINE__);
        }
        $this->Use_Date_Offset = $use_Date_Offset;
        return $this;
    }
    /**
     * Get Date_Offset_Type_Reference value
     * @return \StructType\Project_Template_Date_Offset_TypeObjectType|null
     */
    public function getDate_Offset_Type_Reference()
    {
        return $this->Date_Offset_Type_Reference;
    }
    /**
     * Set Date_Offset_Type_Reference value
     * @param \StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Type_Reference
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setDate_Offset_Type_Reference(\StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Type_Reference = null)
    {
        $this->Date_Offset_Type_Reference = $date_Offset_Type_Reference;
        return $this;
    }
    /**
     * Get Resource_Plan_Detail_for_Template_Data value
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType[]|null
     */
    public function getResource_Plan_Detail_for_Template_Data()
    {
        return $this->Resource_Plan_Detail_for_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Plan_Detail_for_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Plan_Detail_for_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Plan_Detail_for_Template_DataForArrayConstraintsFromSetResource_Plan_Detail_for_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_Template_DataTypeResource_Plan_Detail_for_Template_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_Template_DataTypeResource_Plan_Detail_for_Template_DataItem instanceof \StructType\Resource_Plan_Detail_for_Template_DataType) {
                $invalidValues[] = is_object($resource_Plan_Template_DataTypeResource_Plan_Detail_for_Template_DataItem) ? get_class($resource_Plan_Template_DataTypeResource_Plan_Detail_for_Template_DataItem) : sprintf('%s(%s)', gettype($resource_Plan_Template_DataTypeResource_Plan_Detail_for_Template_DataItem), var_export($resource_Plan_Template_DataTypeResource_Plan_Detail_for_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Plan_Detail_for_Template_Data property can only contain items of type \StructType\Resource_Plan_Detail_for_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Plan_Detail_for_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Detail_for_Template_DataType[] $resource_Plan_Detail_for_Template_Data
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function setResource_Plan_Detail_for_Template_Data(array $resource_Plan_Detail_for_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Plan_Detail_for_Template_DataArrayErrorMessage = self::validateResource_Plan_Detail_for_Template_DataForArrayConstraintsFromSetResource_Plan_Detail_for_Template_Data($resource_Plan_Detail_for_Template_Data))) {
            throw new \InvalidArgumentException($resource_Plan_Detail_for_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Plan_Detail_for_Template_Data = $resource_Plan_Detail_for_Template_Data;
        return $this;
    }
    /**
     * Add item to Resource_Plan_Detail_for_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Detail_for_Template_DataType $item
     * @return \StructType\Resource_Plan_Template_DataType
     */
    public function addToResource_Plan_Detail_for_Template_Data(\StructType\Resource_Plan_Detail_for_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Plan_Detail_for_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Plan_Detail_for_Template_Data property can only contain items of type \StructType\Resource_Plan_Detail_for_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Plan_Detail_for_Template_Data[] = $item;
        return $this;
    }
}
