<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Forecast_Line__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Forecast Line Data element for Import Resource Forecast High Volume Web Service.
 * @subpackage Structs
 */
class Resource_Forecast_Line__HV__DataType extends AbstractStructBase
{
    /**
     * The Resource_Forecast_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Line Reference
     * - minOccurs: 0
     * @var \StructType\Resource_Forecast_LineObjectType
     */
    public $Resource_Forecast_Line_Reference;
    /**
     * The Resource_Forecast_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Line ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Forecast_Line_ID;
    /**
     * The Project_Resource_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Resource for Resource Forecast Line
     * @var \StructType\Project_ResourceObjectType
     */
    public $Project_Resource_Reference;
    /**
     * The Resource_Plan_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Line for Resource Forecast Line
     * - minOccurs: 0
     * @var \StructType\Project_Resource_Plan_DetailObjectType
     */
    public $Resource_Plan_Line_Reference;
    /**
     * The Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Plan Task for Resource Forecast Line
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TaskObjectType
     */
    public $Task_Reference;
    /**
     * The Resource_Forecast_Line_Allocation_Data
     * Meta information extracted from the WSDL
     * - documentation: Weekly Allocation Data element for Resource Forecast Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Forecast_Line_Allocation__HV__DataType[]
     */
    public $Resource_Forecast_Line_Allocation_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Resource_Forecast_Line__HV__DataType
     * @uses Resource_Forecast_Line__HV__DataType::setResource_Forecast_Line_Reference()
     * @uses Resource_Forecast_Line__HV__DataType::setResource_Forecast_Line_ID()
     * @uses Resource_Forecast_Line__HV__DataType::setProject_Resource_Reference()
     * @uses Resource_Forecast_Line__HV__DataType::setResource_Plan_Line_Reference()
     * @uses Resource_Forecast_Line__HV__DataType::setTask_Reference()
     * @uses Resource_Forecast_Line__HV__DataType::setResource_Forecast_Line_Allocation_Data()
     * @uses Resource_Forecast_Line__HV__DataType::setDelete()
     * @param \StructType\Resource_Forecast_LineObjectType $resource_Forecast_Line_Reference
     * @param string $resource_Forecast_Line_ID
     * @param \StructType\Project_ResourceObjectType $project_Resource_Reference
     * @param \StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Line_Reference
     * @param \StructType\Project_Plan_TaskObjectType $task_Reference
     * @param \StructType\Resource_Forecast_Line_Allocation__HV__DataType[] $resource_Forecast_Line_Allocation_Data
     * @param bool $delete
     */
    public function __construct(\StructType\Resource_Forecast_LineObjectType $resource_Forecast_Line_Reference = null, $resource_Forecast_Line_ID = null, \StructType\Project_ResourceObjectType $project_Resource_Reference = null, \StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Line_Reference = null, \StructType\Project_Plan_TaskObjectType $task_Reference = null, array $resource_Forecast_Line_Allocation_Data = array(), $delete = null)
    {
        $this
            ->setResource_Forecast_Line_Reference($resource_Forecast_Line_Reference)
            ->setResource_Forecast_Line_ID($resource_Forecast_Line_ID)
            ->setProject_Resource_Reference($project_Resource_Reference)
            ->setResource_Plan_Line_Reference($resource_Plan_Line_Reference)
            ->setTask_Reference($task_Reference)
            ->setResource_Forecast_Line_Allocation_Data($resource_Forecast_Line_Allocation_Data)
            ->setDelete($delete);
    }
    /**
     * Get Resource_Forecast_Line_Reference value
     * @return \StructType\Resource_Forecast_LineObjectType|null
     */
    public function getResource_Forecast_Line_Reference()
    {
        return $this->Resource_Forecast_Line_Reference;
    }
    /**
     * Set Resource_Forecast_Line_Reference value
     * @param \StructType\Resource_Forecast_LineObjectType $resource_Forecast_Line_Reference
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setResource_Forecast_Line_Reference(\StructType\Resource_Forecast_LineObjectType $resource_Forecast_Line_Reference = null)
    {
        $this->Resource_Forecast_Line_Reference = $resource_Forecast_Line_Reference;
        return $this;
    }
    /**
     * Get Resource_Forecast_Line_ID value
     * @return string|null
     */
    public function getResource_Forecast_Line_ID()
    {
        return $this->Resource_Forecast_Line_ID;
    }
    /**
     * Set Resource_Forecast_Line_ID value
     * @param string $resource_Forecast_Line_ID
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setResource_Forecast_Line_ID($resource_Forecast_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Forecast_Line_ID) && !is_string($resource_Forecast_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Forecast_Line_ID, true), gettype($resource_Forecast_Line_ID)), __LINE__);
        }
        $this->Resource_Forecast_Line_ID = $resource_Forecast_Line_ID;
        return $this;
    }
    /**
     * Get Project_Resource_Reference value
     * @return \StructType\Project_ResourceObjectType|null
     */
    public function getProject_Resource_Reference()
    {
        return $this->Project_Resource_Reference;
    }
    /**
     * Set Project_Resource_Reference value
     * @param \StructType\Project_ResourceObjectType $project_Resource_Reference
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setProject_Resource_Reference(\StructType\Project_ResourceObjectType $project_Resource_Reference = null)
    {
        $this->Project_Resource_Reference = $project_Resource_Reference;
        return $this;
    }
    /**
     * Get Resource_Plan_Line_Reference value
     * @return \StructType\Project_Resource_Plan_DetailObjectType|null
     */
    public function getResource_Plan_Line_Reference()
    {
        return $this->Resource_Plan_Line_Reference;
    }
    /**
     * Set Resource_Plan_Line_Reference value
     * @param \StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Line_Reference
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setResource_Plan_Line_Reference(\StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Line_Reference = null)
    {
        $this->Resource_Plan_Line_Reference = $resource_Plan_Line_Reference;
        return $this;
    }
    /**
     * Get Task_Reference value
     * @return \StructType\Project_Plan_TaskObjectType|null
     */
    public function getTask_Reference()
    {
        return $this->Task_Reference;
    }
    /**
     * Set Task_Reference value
     * @param \StructType\Project_Plan_TaskObjectType $task_Reference
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setTask_Reference(\StructType\Project_Plan_TaskObjectType $task_Reference = null)
    {
        $this->Task_Reference = $task_Reference;
        return $this;
    }
    /**
     * Get Resource_Forecast_Line_Allocation_Data value
     * @return \StructType\Resource_Forecast_Line_Allocation__HV__DataType[]|null
     */
    public function getResource_Forecast_Line_Allocation_Data()
    {
        return $this->Resource_Forecast_Line_Allocation_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Line_Allocation_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Line_Allocation_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_Line_Allocation_DataForArrayConstraintsFromSetResource_Forecast_Line_Allocation_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Forecast_Line_HV_DataTypeResource_Forecast_Line_Allocation_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Forecast_Line_HV_DataTypeResource_Forecast_Line_Allocation_DataItem instanceof \StructType\Resource_Forecast_Line_Allocation__HV__DataType) {
                $invalidValues[] = is_object($resource_Forecast_Line_HV_DataTypeResource_Forecast_Line_Allocation_DataItem) ? get_class($resource_Forecast_Line_HV_DataTypeResource_Forecast_Line_Allocation_DataItem) : sprintf('%s(%s)', gettype($resource_Forecast_Line_HV_DataTypeResource_Forecast_Line_Allocation_DataItem), var_export($resource_Forecast_Line_HV_DataTypeResource_Forecast_Line_Allocation_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Line_Allocation_Data property can only contain items of type \StructType\Resource_Forecast_Line_Allocation__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Line_Allocation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Line_Allocation__HV__DataType[] $resource_Forecast_Line_Allocation_Data
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setResource_Forecast_Line_Allocation_Data(array $resource_Forecast_Line_Allocation_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_Line_Allocation_DataArrayErrorMessage = self::validateResource_Forecast_Line_Allocation_DataForArrayConstraintsFromSetResource_Forecast_Line_Allocation_Data($resource_Forecast_Line_Allocation_Data))) {
            throw new \InvalidArgumentException($resource_Forecast_Line_Allocation_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Line_Allocation_Data = $resource_Forecast_Line_Allocation_Data;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Line_Allocation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Line_Allocation__HV__DataType $item
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function addToResource_Forecast_Line_Allocation_Data(\StructType\Resource_Forecast_Line_Allocation__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Forecast_Line_Allocation__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Line_Allocation_Data property can only contain items of type \StructType\Resource_Forecast_Line_Allocation__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Line_Allocation_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Resource_Forecast_Line__HV__DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
