<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains criteria to search for Requisition Sourcing Rules. You can enter one or more criteria. If none are selected as true and if there are no Requisition Sourcing Rule References requested, then all sourcing rules
 * regardless of rule type are returned.
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Buyer_Sourcing_Rule
     * Meta information extracted from the WSDL
     * - documentation: True to return buyer sourcing rules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Buyer_Sourcing_Rule;
    /**
     * The Supplier_Sourcing_Rule
     * Meta information extracted from the WSDL
     * - documentation: True to return supplier sourcing rules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Supplier_Sourcing_Rule;
    /**
     * The Inventory_Site_Sourcing_Rule
     * Meta information extracted from the WSDL
     * - documentation: True to return inventory site sourcing rules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inventory_Site_Sourcing_Rule;
    /**
     * The Order_From_Connection_Sourcing_Rule
     * Meta information extracted from the WSDL
     * - documentation: True to return order-from connection sourcing rules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Order_From_Connection_Sourcing_Rule;
    /**
     * Constructor method for Requisition_Sourcing_Rule_Request_CriteriaType
     * @uses Requisition_Sourcing_Rule_Request_CriteriaType::setBuyer_Sourcing_Rule()
     * @uses Requisition_Sourcing_Rule_Request_CriteriaType::setSupplier_Sourcing_Rule()
     * @uses Requisition_Sourcing_Rule_Request_CriteriaType::setInventory_Site_Sourcing_Rule()
     * @uses Requisition_Sourcing_Rule_Request_CriteriaType::setOrder_From_Connection_Sourcing_Rule()
     * @param bool $buyer_Sourcing_Rule
     * @param bool $supplier_Sourcing_Rule
     * @param bool $inventory_Site_Sourcing_Rule
     * @param bool $order_From_Connection_Sourcing_Rule
     */
    public function __construct($buyer_Sourcing_Rule = null, $supplier_Sourcing_Rule = null, $inventory_Site_Sourcing_Rule = null, $order_From_Connection_Sourcing_Rule = null)
    {
        $this
            ->setBuyer_Sourcing_Rule($buyer_Sourcing_Rule)
            ->setSupplier_Sourcing_Rule($supplier_Sourcing_Rule)
            ->setInventory_Site_Sourcing_Rule($inventory_Site_Sourcing_Rule)
            ->setOrder_From_Connection_Sourcing_Rule($order_From_Connection_Sourcing_Rule);
    }
    /**
     * Get Buyer_Sourcing_Rule value
     * @return bool|null
     */
    public function getBuyer_Sourcing_Rule()
    {
        return $this->Buyer_Sourcing_Rule;
    }
    /**
     * Set Buyer_Sourcing_Rule value
     * @param bool $buyer_Sourcing_Rule
     * @return \StructType\Requisition_Sourcing_Rule_Request_CriteriaType
     */
    public function setBuyer_Sourcing_Rule($buyer_Sourcing_Rule = null)
    {
        // validation for constraint: boolean
        if (!is_null($buyer_Sourcing_Rule) && !is_bool($buyer_Sourcing_Rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($buyer_Sourcing_Rule, true), gettype($buyer_Sourcing_Rule)), __LINE__);
        }
        $this->Buyer_Sourcing_Rule = $buyer_Sourcing_Rule;
        return $this;
    }
    /**
     * Get Supplier_Sourcing_Rule value
     * @return bool|null
     */
    public function getSupplier_Sourcing_Rule()
    {
        return $this->Supplier_Sourcing_Rule;
    }
    /**
     * Set Supplier_Sourcing_Rule value
     * @param bool $supplier_Sourcing_Rule
     * @return \StructType\Requisition_Sourcing_Rule_Request_CriteriaType
     */
    public function setSupplier_Sourcing_Rule($supplier_Sourcing_Rule = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplier_Sourcing_Rule) && !is_bool($supplier_Sourcing_Rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplier_Sourcing_Rule, true), gettype($supplier_Sourcing_Rule)), __LINE__);
        }
        $this->Supplier_Sourcing_Rule = $supplier_Sourcing_Rule;
        return $this;
    }
    /**
     * Get Inventory_Site_Sourcing_Rule value
     * @return bool|null
     */
    public function getInventory_Site_Sourcing_Rule()
    {
        return $this->Inventory_Site_Sourcing_Rule;
    }
    /**
     * Set Inventory_Site_Sourcing_Rule value
     * @param bool $inventory_Site_Sourcing_Rule
     * @return \StructType\Requisition_Sourcing_Rule_Request_CriteriaType
     */
    public function setInventory_Site_Sourcing_Rule($inventory_Site_Sourcing_Rule = null)
    {
        // validation for constraint: boolean
        if (!is_null($inventory_Site_Sourcing_Rule) && !is_bool($inventory_Site_Sourcing_Rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inventory_Site_Sourcing_Rule, true), gettype($inventory_Site_Sourcing_Rule)), __LINE__);
        }
        $this->Inventory_Site_Sourcing_Rule = $inventory_Site_Sourcing_Rule;
        return $this;
    }
    /**
     * Get Order_From_Connection_Sourcing_Rule value
     * @return bool|null
     */
    public function getOrder_From_Connection_Sourcing_Rule()
    {
        return $this->{'Order-From_Connection_Sourcing_Rule'};
    }
    /**
     * Set Order_From_Connection_Sourcing_Rule value
     * @param bool $order_From_Connection_Sourcing_Rule
     * @return \StructType\Requisition_Sourcing_Rule_Request_CriteriaType
     */
    public function setOrder_From_Connection_Sourcing_Rule($order_From_Connection_Sourcing_Rule = null)
    {
        // validation for constraint: boolean
        if (!is_null($order_From_Connection_Sourcing_Rule) && !is_bool($order_From_Connection_Sourcing_Rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($order_From_Connection_Sourcing_Rule, true), gettype($order_From_Connection_Sourcing_Rule)), __LINE__);
        }
        $this->Order_From_Connection_Sourcing_Rule = $this->{'Order-From_Connection_Sourcing_Rule'} = $order_From_Connection_Sourcing_Rule;
        return $this;
    }
}
