<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of the requisition sourcing rule. There are four kinds of sourcing rules: buyer, supplier, inventory site, and order-from connection. Only one will be present at a time.
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_DataType extends AbstractStructBase
{
    /**
     * The Requisition_Sourcing_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Requisition Sourcing Rule.
     * - minOccurs: 0
     * @var \StructType\Requisition_Sourcing_RuleObjectType
     */
    public $Requisition_Sourcing_Rule_Reference;
    /**
     * The Requisition_Sourcing_Rule_Buyer_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for buyer sourcing rule
     * - choice: Requisition_Sourcing_Rule_Buyer_Data | Requisition_Sourcing_Rule_Supplier_Data | Requisition_Sourcing_Rule_Inventory_Site_Data | Requisition_Sourcing_Rule_Order_Connection_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public $Requisition_Sourcing_Rule_Buyer_Data;
    /**
     * The Requisition_Sourcing_Rule_Supplier_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for supplier sourcing rule.
     * - choice: Requisition_Sourcing_Rule_Buyer_Data | Requisition_Sourcing_Rule_Supplier_Data | Requisition_Sourcing_Rule_Inventory_Site_Data | Requisition_Sourcing_Rule_Order_Connection_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_Sourcing_Rule_Supplier_DataType[]
     */
    public $Requisition_Sourcing_Rule_Supplier_Data;
    /**
     * The Requisition_Sourcing_Rule_Inventory_Site_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for inventory site sourcing rule
     * - choice: Requisition_Sourcing_Rule_Buyer_Data | Requisition_Sourcing_Rule_Supplier_Data | Requisition_Sourcing_Rule_Inventory_Site_Data | Requisition_Sourcing_Rule_Order_Connection_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType[]
     */
    public $Requisition_Sourcing_Rule_Inventory_Site_Data;
    /**
     * The Requisition_Sourcing_Rule_Order_Connection_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for order-from connection sourcing rule.
     * - choice: Requisition_Sourcing_Rule_Buyer_Data | Requisition_Sourcing_Rule_Supplier_Data | Requisition_Sourcing_Rule_Inventory_Site_Data | Requisition_Sourcing_Rule_Order_Connection_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public $Requisition_Sourcing_Rule_Order_Connection_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If True is entered, the supplied Requisition Sourcing Rule reference will be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Requisition_Sourcing_Rule_DataType
     * @uses Requisition_Sourcing_Rule_DataType::setRequisition_Sourcing_Rule_Reference()
     * @uses Requisition_Sourcing_Rule_DataType::setRequisition_Sourcing_Rule_Buyer_Data()
     * @uses Requisition_Sourcing_Rule_DataType::setRequisition_Sourcing_Rule_Supplier_Data()
     * @uses Requisition_Sourcing_Rule_DataType::setRequisition_Sourcing_Rule_Inventory_Site_Data()
     * @uses Requisition_Sourcing_Rule_DataType::setRequisition_Sourcing_Rule_Order_Connection_Data()
     * @uses Requisition_Sourcing_Rule_DataType::setDelete()
     * @param \StructType\Requisition_Sourcing_RuleObjectType $requisition_Sourcing_Rule_Reference
     * @param \StructType\Requisition_Sourcing_Rule_Buyer_DataType $requisition_Sourcing_Rule_Buyer_Data
     * @param \StructType\Requisition_Sourcing_Rule_Supplier_DataType[] $requisition_Sourcing_Rule_Supplier_Data
     * @param \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType[] $requisition_Sourcing_Rule_Inventory_Site_Data
     * @param \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType $requisition_Sourcing_Rule_Order_Connection_Data
     * @param bool $delete
     */
    public function __construct(\StructType\Requisition_Sourcing_RuleObjectType $requisition_Sourcing_Rule_Reference = null, \StructType\Requisition_Sourcing_Rule_Buyer_DataType $requisition_Sourcing_Rule_Buyer_Data = null, array $requisition_Sourcing_Rule_Supplier_Data = array(), array $requisition_Sourcing_Rule_Inventory_Site_Data = array(), \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType $requisition_Sourcing_Rule_Order_Connection_Data = null, $delete = null)
    {
        $this
            ->setRequisition_Sourcing_Rule_Reference($requisition_Sourcing_Rule_Reference)
            ->setRequisition_Sourcing_Rule_Buyer_Data($requisition_Sourcing_Rule_Buyer_Data)
            ->setRequisition_Sourcing_Rule_Supplier_Data($requisition_Sourcing_Rule_Supplier_Data)
            ->setRequisition_Sourcing_Rule_Inventory_Site_Data($requisition_Sourcing_Rule_Inventory_Site_Data)
            ->setRequisition_Sourcing_Rule_Order_Connection_Data($requisition_Sourcing_Rule_Order_Connection_Data)
            ->setDelete($delete);
    }
    /**
     * Get Requisition_Sourcing_Rule_Reference value
     * @return \StructType\Requisition_Sourcing_RuleObjectType|null
     */
    public function getRequisition_Sourcing_Rule_Reference()
    {
        return $this->Requisition_Sourcing_Rule_Reference;
    }
    /**
     * Set Requisition_Sourcing_Rule_Reference value
     * @param \StructType\Requisition_Sourcing_RuleObjectType $requisition_Sourcing_Rule_Reference
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function setRequisition_Sourcing_Rule_Reference(\StructType\Requisition_Sourcing_RuleObjectType $requisition_Sourcing_Rule_Reference = null)
    {
        $this->Requisition_Sourcing_Rule_Reference = $requisition_Sourcing_Rule_Reference;
        return $this;
    }
    /**
     * Get Requisition_Sourcing_Rule_Buyer_Data value
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType|null
     */
    public function getRequisition_Sourcing_Rule_Buyer_Data()
    {
        return isset($this->Requisition_Sourcing_Rule_Buyer_Data) ? $this->Requisition_Sourcing_Rule_Buyer_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRequisition_Sourcing_Rule_Buyer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule_Buyer_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRequisition_Sourcing_Rule_Buyer_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Buyer_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Requisition_Sourcing_Rule_Supplier_Data',
            'Requisition_Sourcing_Rule_Inventory_Site_Data',
            'Requisition_Sourcing_Rule_Order_Connection_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Requisition_Sourcing_Rule_Buyer_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Requisition_Sourcing_Rule_Buyer_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Requisition_Sourcing_Rule_Buyer_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_Rule_Buyer_DataType $requisition_Sourcing_Rule_Buyer_Data
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function setRequisition_Sourcing_Rule_Buyer_Data(\StructType\Requisition_Sourcing_Rule_Buyer_DataType $requisition_Sourcing_Rule_Buyer_Data = null)
    {
        // validation for constraint: choice(Requisition_Sourcing_Rule_Buyer_Data, Requisition_Sourcing_Rule_Supplier_Data, Requisition_Sourcing_Rule_Inventory_Site_Data, Requisition_Sourcing_Rule_Order_Connection_Data)
        if ('' !== ($requisition_Sourcing_Rule_Buyer_DataChoiceErrorMessage = self::validateRequisition_Sourcing_Rule_Buyer_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Buyer_Data($requisition_Sourcing_Rule_Buyer_Data))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Rule_Buyer_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($requisition_Sourcing_Rule_Buyer_Data) || (is_array($requisition_Sourcing_Rule_Buyer_Data) && empty($requisition_Sourcing_Rule_Buyer_Data))) {
            unset($this->Requisition_Sourcing_Rule_Buyer_Data);
        } else {
            $this->Requisition_Sourcing_Rule_Buyer_Data = $requisition_Sourcing_Rule_Buyer_Data;
        }
        return $this;
    }
    /**
     * Get Requisition_Sourcing_Rule_Supplier_Data value
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType[]|null
     */
    public function getRequisition_Sourcing_Rule_Supplier_Data()
    {
        return isset($this->Requisition_Sourcing_Rule_Supplier_Data) ? $this->Requisition_Sourcing_Rule_Supplier_Data : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Sourcing_Rule_Supplier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule_Supplier_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Sourcing_Rule_Supplier_DataForArrayConstraintsFromSetRequisition_Sourcing_Rule_Supplier_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Supplier_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Supplier_DataItem instanceof \StructType\Requisition_Sourcing_Rule_Supplier_DataType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Supplier_DataItem) ? get_class($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Supplier_DataItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Supplier_DataItem), var_export($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Supplier_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Sourcing_Rule_Supplier_Data property can only contain items of type \StructType\Requisition_Sourcing_Rule_Supplier_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRequisition_Sourcing_Rule_Supplier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule_Supplier_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRequisition_Sourcing_Rule_Supplier_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Supplier_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Requisition_Sourcing_Rule_Buyer_Data',
            'Requisition_Sourcing_Rule_Inventory_Site_Data',
            'Requisition_Sourcing_Rule_Order_Connection_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Requisition_Sourcing_Rule_Supplier_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Requisition_Sourcing_Rule_Supplier_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Requisition_Sourcing_Rule_Supplier_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_Rule_Supplier_DataType[] $requisition_Sourcing_Rule_Supplier_Data
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function setRequisition_Sourcing_Rule_Supplier_Data(array $requisition_Sourcing_Rule_Supplier_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Sourcing_Rule_Supplier_DataArrayErrorMessage = self::validateRequisition_Sourcing_Rule_Supplier_DataForArrayConstraintsFromSetRequisition_Sourcing_Rule_Supplier_Data($requisition_Sourcing_Rule_Supplier_Data))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Rule_Supplier_DataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Requisition_Sourcing_Rule_Buyer_Data, Requisition_Sourcing_Rule_Supplier_Data, Requisition_Sourcing_Rule_Inventory_Site_Data, Requisition_Sourcing_Rule_Order_Connection_Data)
        if ('' !== ($requisition_Sourcing_Rule_Supplier_DataChoiceErrorMessage = self::validateRequisition_Sourcing_Rule_Supplier_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Supplier_Data($requisition_Sourcing_Rule_Supplier_Data))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Rule_Supplier_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($requisition_Sourcing_Rule_Supplier_Data) || (is_array($requisition_Sourcing_Rule_Supplier_Data) && empty($requisition_Sourcing_Rule_Supplier_Data))) {
            unset($this->Requisition_Sourcing_Rule_Supplier_Data);
        } else {
            $this->Requisition_Sourcing_Rule_Supplier_Data = $requisition_Sourcing_Rule_Supplier_Data;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToRequisition_Sourcing_Rule_Supplier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRequisition_Sourcing_Rule_Supplier_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRequisition_Sourcing_Rule_Supplier_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Requisition_Sourcing_Rule_Buyer_Data',
            'Requisition_Sourcing_Rule_Inventory_Site_Data',
            'Requisition_Sourcing_Rule_Order_Connection_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Requisition_Sourcing_Rule_Supplier_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Requisition_Sourcing_Rule_Supplier_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Requisition_Sourcing_Rule_Supplier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_Rule_Supplier_DataType $item
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function addToRequisition_Sourcing_Rule_Supplier_Data(\StructType\Requisition_Sourcing_Rule_Supplier_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_Sourcing_Rule_Supplier_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Sourcing_Rule_Supplier_Data property can only contain items of type \StructType\Requisition_Sourcing_Rule_Supplier_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Requisition_Sourcing_Rule_Buyer_Data, Requisition_Sourcing_Rule_Supplier_Data, Requisition_Sourcing_Rule_Inventory_Site_Data, Requisition_Sourcing_Rule_Order_Connection_Data)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRequisition_Sourcing_Rule_Supplier_Data($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Requisition_Sourcing_Rule_Supplier_Data[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Sourcing_Rule_Inventory_Site_Data value
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType[]|null
     */
    public function getRequisition_Sourcing_Rule_Inventory_Site_Data()
    {
        return isset($this->Requisition_Sourcing_Rule_Inventory_Site_Data) ? $this->Requisition_Sourcing_Rule_Inventory_Site_Data : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Sourcing_Rule_Inventory_Site_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule_Inventory_Site_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Sourcing_Rule_Inventory_Site_DataForArrayConstraintsFromSetRequisition_Sourcing_Rule_Inventory_Site_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Inventory_Site_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Inventory_Site_DataItem instanceof \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Inventory_Site_DataItem) ? get_class($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Inventory_Site_DataItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Inventory_Site_DataItem), var_export($requisition_Sourcing_Rule_DataTypeRequisition_Sourcing_Rule_Inventory_Site_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Sourcing_Rule_Inventory_Site_Data property can only contain items of type \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRequisition_Sourcing_Rule_Inventory_Site_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule_Inventory_Site_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRequisition_Sourcing_Rule_Inventory_Site_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Inventory_Site_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Requisition_Sourcing_Rule_Buyer_Data',
            'Requisition_Sourcing_Rule_Supplier_Data',
            'Requisition_Sourcing_Rule_Order_Connection_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Requisition_Sourcing_Rule_Inventory_Site_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Requisition_Sourcing_Rule_Inventory_Site_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Requisition_Sourcing_Rule_Inventory_Site_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType[] $requisition_Sourcing_Rule_Inventory_Site_Data
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function setRequisition_Sourcing_Rule_Inventory_Site_Data(array $requisition_Sourcing_Rule_Inventory_Site_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Sourcing_Rule_Inventory_Site_DataArrayErrorMessage = self::validateRequisition_Sourcing_Rule_Inventory_Site_DataForArrayConstraintsFromSetRequisition_Sourcing_Rule_Inventory_Site_Data($requisition_Sourcing_Rule_Inventory_Site_Data))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Rule_Inventory_Site_DataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Requisition_Sourcing_Rule_Buyer_Data, Requisition_Sourcing_Rule_Supplier_Data, Requisition_Sourcing_Rule_Inventory_Site_Data, Requisition_Sourcing_Rule_Order_Connection_Data)
        if ('' !== ($requisition_Sourcing_Rule_Inventory_Site_DataChoiceErrorMessage = self::validateRequisition_Sourcing_Rule_Inventory_Site_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Inventory_Site_Data($requisition_Sourcing_Rule_Inventory_Site_Data))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Rule_Inventory_Site_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($requisition_Sourcing_Rule_Inventory_Site_Data) || (is_array($requisition_Sourcing_Rule_Inventory_Site_Data) && empty($requisition_Sourcing_Rule_Inventory_Site_Data))) {
            unset($this->Requisition_Sourcing_Rule_Inventory_Site_Data);
        } else {
            $this->Requisition_Sourcing_Rule_Inventory_Site_Data = $requisition_Sourcing_Rule_Inventory_Site_Data;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToRequisition_Sourcing_Rule_Inventory_Site_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRequisition_Sourcing_Rule_Inventory_Site_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRequisition_Sourcing_Rule_Inventory_Site_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Requisition_Sourcing_Rule_Buyer_Data',
            'Requisition_Sourcing_Rule_Supplier_Data',
            'Requisition_Sourcing_Rule_Order_Connection_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Requisition_Sourcing_Rule_Inventory_Site_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Requisition_Sourcing_Rule_Inventory_Site_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Requisition_Sourcing_Rule_Inventory_Site_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType $item
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function addToRequisition_Sourcing_Rule_Inventory_Site_Data(\StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Sourcing_Rule_Inventory_Site_Data property can only contain items of type \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Requisition_Sourcing_Rule_Buyer_Data, Requisition_Sourcing_Rule_Supplier_Data, Requisition_Sourcing_Rule_Inventory_Site_Data, Requisition_Sourcing_Rule_Order_Connection_Data)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRequisition_Sourcing_Rule_Inventory_Site_Data($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Requisition_Sourcing_Rule_Inventory_Site_Data[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Sourcing_Rule_Order_Connection_Data value
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType|null
     */
    public function getRequisition_Sourcing_Rule_Order_Connection_Data()
    {
        return isset($this->Requisition_Sourcing_Rule_Order_Connection_Data) ? $this->Requisition_Sourcing_Rule_Order_Connection_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRequisition_Sourcing_Rule_Order_Connection_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule_Order_Connection_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRequisition_Sourcing_Rule_Order_Connection_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Order_Connection_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Requisition_Sourcing_Rule_Buyer_Data',
            'Requisition_Sourcing_Rule_Supplier_Data',
            'Requisition_Sourcing_Rule_Inventory_Site_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Requisition_Sourcing_Rule_Order_Connection_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Requisition_Sourcing_Rule_Order_Connection_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Requisition_Sourcing_Rule_Order_Connection_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType $requisition_Sourcing_Rule_Order_Connection_Data
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function setRequisition_Sourcing_Rule_Order_Connection_Data(\StructType\Requisition_Sourcing_Rule_Order_Connection_DataType $requisition_Sourcing_Rule_Order_Connection_Data = null)
    {
        // validation for constraint: choice(Requisition_Sourcing_Rule_Buyer_Data, Requisition_Sourcing_Rule_Supplier_Data, Requisition_Sourcing_Rule_Inventory_Site_Data, Requisition_Sourcing_Rule_Order_Connection_Data)
        if ('' !== ($requisition_Sourcing_Rule_Order_Connection_DataChoiceErrorMessage = self::validateRequisition_Sourcing_Rule_Order_Connection_DataForChoiceConstraintsFromSetRequisition_Sourcing_Rule_Order_Connection_Data($requisition_Sourcing_Rule_Order_Connection_Data))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Rule_Order_Connection_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($requisition_Sourcing_Rule_Order_Connection_Data) || (is_array($requisition_Sourcing_Rule_Order_Connection_Data) && empty($requisition_Sourcing_Rule_Order_Connection_Data))) {
            unset($this->Requisition_Sourcing_Rule_Order_Connection_Data);
        } else {
            $this->Requisition_Sourcing_Rule_Order_Connection_Data = $requisition_Sourcing_Rule_Order_Connection_Data;
        }
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Requisition_Sourcing_Rule_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
