<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Line_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the requisition-specific criteria needed to search for instances.
 * @subpackage Structs
 */
class Requisition_Line_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Requisition reference
     * - maxOccurs: unbounded
     * @var \StructType\RequisitionObjectType[]
     */
    public $Requisition_Reference;
    /**
     * Constructor method for Requisition_Line_Request_CriteriaType
     * @uses Requisition_Line_Request_CriteriaType::setRequisition_Reference()
     * @param \StructType\RequisitionObjectType[] $requisition_Reference
     */
    public function __construct(array $requisition_Reference = array())
    {
        $this
            ->setRequisition_Reference($requisition_Reference);
    }
    /**
     * Get Requisition_Reference value
     * @return \StructType\RequisitionObjectType[]|null
     */
    public function getRequisition_Reference()
    {
        return $this->Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_ReferenceForArrayConstraintsFromSetRequisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Line_Request_CriteriaTypeRequisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Line_Request_CriteriaTypeRequisition_ReferenceItem instanceof \StructType\RequisitionObjectType) {
                $invalidValues[] = is_object($requisition_Line_Request_CriteriaTypeRequisition_ReferenceItem) ? get_class($requisition_Line_Request_CriteriaTypeRequisition_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Line_Request_CriteriaTypeRequisition_ReferenceItem), var_export($requisition_Line_Request_CriteriaTypeRequisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Reference property can only contain items of type \StructType\RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RequisitionObjectType[] $requisition_Reference
     * @return \StructType\Requisition_Line_Request_CriteriaType
     */
    public function setRequisition_Reference(array $requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_ReferenceArrayErrorMessage = self::validateRequisition_ReferenceForArrayConstraintsFromSetRequisition_Reference($requisition_Reference))) {
            throw new \InvalidArgumentException($requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Reference = $requisition_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RequisitionObjectType $item
     * @return \StructType\Requisition_Line_Request_CriteriaType
     */
    public function addToRequisition_Reference(\StructType\RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Reference property can only contain items of type \StructType\RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Reference[] = $item;
        return $this;
    }
}
