<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Response_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures a reference to RFQ Response Document along with its content
 * @subpackage Structs
 */
class Request_for_Quote_Response_OutboundType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Response_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Response document
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_ResponseObjectType
     */
    public $Request_for_Quote_Response_Reference;
    /**
     * The Request_for_Quote_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Response_DataType[]
     */
    public $Request_for_Quote_Response_Data;
    /**
     * Constructor method for Request_for_Quote_Response_OutboundType
     * @uses Request_for_Quote_Response_OutboundType::setRequest_for_Quote_Response_Reference()
     * @uses Request_for_Quote_Response_OutboundType::setRequest_for_Quote_Response_Data()
     * @param \StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference
     * @param \StructType\RFQ_Response_DataType[] $request_for_Quote_Response_Data
     */
    public function __construct(\StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference = null, array $request_for_Quote_Response_Data = array())
    {
        $this
            ->setRequest_for_Quote_Response_Reference($request_for_Quote_Response_Reference)
            ->setRequest_for_Quote_Response_Data($request_for_Quote_Response_Data);
    }
    /**
     * Get Request_for_Quote_Response_Reference value
     * @return \StructType\Request_for_Quote_ResponseObjectType|null
     */
    public function getRequest_for_Quote_Response_Reference()
    {
        return $this->Request_for_Quote_Response_Reference;
    }
    /**
     * Set Request_for_Quote_Response_Reference value
     * @param \StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference
     * @return \StructType\Request_for_Quote_Response_OutboundType
     */
    public function setRequest_for_Quote_Response_Reference(\StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference = null)
    {
        $this->Request_for_Quote_Response_Reference = $request_for_Quote_Response_Reference;
        return $this;
    }
    /**
     * Get Request_for_Quote_Response_Data value
     * @return \StructType\RFQ_Response_DataType[]|null
     */
    public function getRequest_for_Quote_Response_Data()
    {
        return $this->Request_for_Quote_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Response_DataForArrayConstraintsFromSetRequest_for_Quote_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Response_OutboundTypeRequest_for_Quote_Response_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Response_OutboundTypeRequest_for_Quote_Response_DataItem instanceof \StructType\RFQ_Response_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Response_OutboundTypeRequest_for_Quote_Response_DataItem) ? get_class($request_for_Quote_Response_OutboundTypeRequest_for_Quote_Response_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Response_OutboundTypeRequest_for_Quote_Response_DataItem), var_export($request_for_Quote_Response_OutboundTypeRequest_for_Quote_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Response_Data property can only contain items of type \StructType\RFQ_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Response_DataType[] $request_for_Quote_Response_Data
     * @return \StructType\Request_for_Quote_Response_OutboundType
     */
    public function setRequest_for_Quote_Response_Data(array $request_for_Quote_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Response_DataArrayErrorMessage = self::validateRequest_for_Quote_Response_DataForArrayConstraintsFromSetRequest_for_Quote_Response_Data($request_for_Quote_Response_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Response_Data = $request_for_Quote_Response_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Response_DataType $item
     * @return \StructType\Request_for_Quote_Response_OutboundType
     */
    public function addToRequest_for_Quote_Response_Data(\StructType\RFQ_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Response_Data property can only contain items of type \StructType\RFQ_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Response_Data[] = $item;
        return $this;
    }
}
