<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reclassify_Asset_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data used to process the asset reclassification
 * @subpackage Structs
 */
class Reclassify_Asset_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The transaction effective date for the asset reclassification
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Proposed_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Proposed Item Descriptor Reference for the reclassification
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Proposed_Item_Reference;
    /**
     * The Proposed_Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The proposed Spend Category Reference for the reclassification
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Proposed_Spend_Category_Reference;
    /**
     * The Proposed_Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: The proposed Asset Class for the reclassification
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Proposed_Asset_Class_Reference;
    /**
     * The Proposed_Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The purposed Asset Type for the reclassification
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Proposed_Asset_Type_Reference;
    /**
     * The Proposed_Useful_Life_Per_Book
     * Meta information extracted from the WSDL
     * - documentation: Reference data to enter useful life per asset book for reclassification
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Useful_Life_for_Reclassify_DataType[]
     */
    public $Proposed_Useful_Life_Per_Book;
    /**
     * Constructor method for Reclassify_Asset_DataType
     * @uses Reclassify_Asset_DataType::setTransaction_Effective_Date()
     * @uses Reclassify_Asset_DataType::setProposed_Item_Reference()
     * @uses Reclassify_Asset_DataType::setProposed_Spend_Category_Reference()
     * @uses Reclassify_Asset_DataType::setProposed_Asset_Class_Reference()
     * @uses Reclassify_Asset_DataType::setProposed_Asset_Type_Reference()
     * @uses Reclassify_Asset_DataType::setProposed_Useful_Life_Per_Book()
     * @param string $transaction_Effective_Date
     * @param \StructType\Item_DescriptorObjectType $proposed_Item_Reference
     * @param \StructType\Spend_CategoryObjectType $proposed_Spend_Category_Reference
     * @param \StructType\Asset_ClassObjectType $proposed_Asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $proposed_Asset_Type_Reference
     * @param \StructType\Asset_Useful_Life_for_Reclassify_DataType[] $proposed_Useful_Life_Per_Book
     */
    public function __construct($transaction_Effective_Date = null, \StructType\Item_DescriptorObjectType $proposed_Item_Reference = null, \StructType\Spend_CategoryObjectType $proposed_Spend_Category_Reference = null, \StructType\Asset_ClassObjectType $proposed_Asset_Class_Reference = null, \StructType\Asset_TypeObjectType $proposed_Asset_Type_Reference = null, array $proposed_Useful_Life_Per_Book = array())
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setProposed_Item_Reference($proposed_Item_Reference)
            ->setProposed_Spend_Category_Reference($proposed_Spend_Category_Reference)
            ->setProposed_Asset_Class_Reference($proposed_Asset_Class_Reference)
            ->setProposed_Asset_Type_Reference($proposed_Asset_Type_Reference)
            ->setProposed_Useful_Life_Per_Book($proposed_Useful_Life_Per_Book);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Proposed_Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getProposed_Item_Reference()
    {
        return $this->Proposed_Item_Reference;
    }
    /**
     * Set Proposed_Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $proposed_Item_Reference
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function setProposed_Item_Reference(\StructType\Item_DescriptorObjectType $proposed_Item_Reference = null)
    {
        $this->Proposed_Item_Reference = $proposed_Item_Reference;
        return $this;
    }
    /**
     * Get Proposed_Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getProposed_Spend_Category_Reference()
    {
        return $this->Proposed_Spend_Category_Reference;
    }
    /**
     * Set Proposed_Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $proposed_Spend_Category_Reference
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function setProposed_Spend_Category_Reference(\StructType\Spend_CategoryObjectType $proposed_Spend_Category_Reference = null)
    {
        $this->Proposed_Spend_Category_Reference = $proposed_Spend_Category_Reference;
        return $this;
    }
    /**
     * Get Proposed_Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getProposed_Asset_Class_Reference()
    {
        return $this->Proposed_Asset_Class_Reference;
    }
    /**
     * Set Proposed_Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $proposed_Asset_Class_Reference
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function setProposed_Asset_Class_Reference(\StructType\Asset_ClassObjectType $proposed_Asset_Class_Reference = null)
    {
        $this->Proposed_Asset_Class_Reference = $proposed_Asset_Class_Reference;
        return $this;
    }
    /**
     * Get Proposed_Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getProposed_Asset_Type_Reference()
    {
        return $this->Proposed_Asset_Type_Reference;
    }
    /**
     * Set Proposed_Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $proposed_Asset_Type_Reference
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function setProposed_Asset_Type_Reference(\StructType\Asset_TypeObjectType $proposed_Asset_Type_Reference = null)
    {
        $this->Proposed_Asset_Type_Reference = $proposed_Asset_Type_Reference;
        return $this;
    }
    /**
     * Get Proposed_Useful_Life_Per_Book value
     * @return \StructType\Asset_Useful_Life_for_Reclassify_DataType[]|null
     */
    public function getProposed_Useful_Life_Per_Book()
    {
        return $this->Proposed_Useful_Life_Per_Book;
    }
    /**
     * This method is responsible for validating the values passed to the setProposed_Useful_Life_Per_Book method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProposed_Useful_Life_Per_Book method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProposed_Useful_Life_Per_BookForArrayConstraintsFromSetProposed_Useful_Life_Per_Book(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reclassify_Asset_DataTypeProposed_Useful_Life_Per_BookItem) {
            // validation for constraint: itemType
            if (!$reclassify_Asset_DataTypeProposed_Useful_Life_Per_BookItem instanceof \StructType\Asset_Useful_Life_for_Reclassify_DataType) {
                $invalidValues[] = is_object($reclassify_Asset_DataTypeProposed_Useful_Life_Per_BookItem) ? get_class($reclassify_Asset_DataTypeProposed_Useful_Life_Per_BookItem) : sprintf('%s(%s)', gettype($reclassify_Asset_DataTypeProposed_Useful_Life_Per_BookItem), var_export($reclassify_Asset_DataTypeProposed_Useful_Life_Per_BookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Proposed_Useful_Life_Per_Book property can only contain items of type \StructType\Asset_Useful_Life_for_Reclassify_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Proposed_Useful_Life_Per_Book value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Useful_Life_for_Reclassify_DataType[] $proposed_Useful_Life_Per_Book
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function setProposed_Useful_Life_Per_Book(array $proposed_Useful_Life_Per_Book = array())
    {
        // validation for constraint: array
        if ('' !== ($proposed_Useful_Life_Per_BookArrayErrorMessage = self::validateProposed_Useful_Life_Per_BookForArrayConstraintsFromSetProposed_Useful_Life_Per_Book($proposed_Useful_Life_Per_Book))) {
            throw new \InvalidArgumentException($proposed_Useful_Life_Per_BookArrayErrorMessage, __LINE__);
        }
        $this->Proposed_Useful_Life_Per_Book = $proposed_Useful_Life_Per_Book;
        return $this;
    }
    /**
     * Add item to Proposed_Useful_Life_Per_Book value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Useful_Life_for_Reclassify_DataType $item
     * @return \StructType\Reclassify_Asset_DataType
     */
    public function addToProposed_Useful_Life_Per_Book(\StructType\Asset_Useful_Life_for_Reclassify_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Useful_Life_for_Reclassify_DataType) {
            throw new \InvalidArgumentException(sprintf('The Proposed_Useful_Life_Per_Book property can only contain items of type \StructType\Asset_Useful_Life_for_Reclassify_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Proposed_Useful_Life_Per_Book[] = $item;
        return $this;
    }
}
