<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receivable Repayment Data contains all the information about Receivable Repayment.
 * @subpackage Structs
 */
class Receivable_Repayment_WWS_DataType extends AbstractStructBase
{
    /**
     * The Receivable_Repayment_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Report ID. This is the Expense Report unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receivable_Repayment_ID;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the person who the expense report is for.
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Expense_Payee_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the company the expense report is for.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Repayment_Date
     * Meta information extracted from the WSDL
     * - documentation: Repayment Date
     * - maxOccurs: 1
     * @var string
     */
    public $Repayment_Date;
    /**
     * The Repayment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount being repaid with this Cash Advance Repayment | Repayment Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Repayment_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receivable Repayment Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receivable Repayment Payment Type
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Repayment_Reference_Detail
     * Meta information extracted from the WSDL
     * - documentation: Repayment Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Repayment_Reference_Detail;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Receivable_Repayment_WWS_DataType
     * @uses Receivable_Repayment_WWS_DataType::setReceivable_Repayment_ID()
     * @uses Receivable_Repayment_WWS_DataType::setExpense_Payee_Reference()
     * @uses Receivable_Repayment_WWS_DataType::setCompany_Reference()
     * @uses Receivable_Repayment_WWS_DataType::setRepayment_Date()
     * @uses Receivable_Repayment_WWS_DataType::setRepayment_Amount()
     * @uses Receivable_Repayment_WWS_DataType::setCurrency_Reference()
     * @uses Receivable_Repayment_WWS_DataType::setPayment_Type_Reference()
     * @uses Receivable_Repayment_WWS_DataType::setRepayment_Reference_Detail()
     * @uses Receivable_Repayment_WWS_DataType::setMemo()
     * @param string $receivable_Repayment_ID
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $repayment_Date
     * @param float $repayment_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param string $repayment_Reference_Detail
     * @param string $memo
     */
    public function __construct($receivable_Repayment_ID = null, \StructType\Expense_PayeeObjectType $expense_Payee_Reference = null, \StructType\CompanyObjectType $company_Reference = null, $repayment_Date = null, $repayment_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $repayment_Reference_Detail = null, $memo = null)
    {
        $this
            ->setReceivable_Repayment_ID($receivable_Repayment_ID)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setCompany_Reference($company_Reference)
            ->setRepayment_Date($repayment_Date)
            ->setRepayment_Amount($repayment_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setRepayment_Reference_Detail($repayment_Reference_Detail)
            ->setMemo($memo);
    }
    /**
     * Get Receivable_Repayment_ID value
     * @return string|null
     */
    public function getReceivable_Repayment_ID()
    {
        return $this->Receivable_Repayment_ID;
    }
    /**
     * Set Receivable_Repayment_ID value
     * @param string $receivable_Repayment_ID
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setReceivable_Repayment_ID($receivable_Repayment_ID = null)
    {
        // validation for constraint: string
        if (!is_null($receivable_Repayment_ID) && !is_string($receivable_Repayment_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivable_Repayment_ID, true), gettype($receivable_Repayment_ID)), __LINE__);
        }
        $this->Receivable_Repayment_ID = $receivable_Repayment_ID;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * Set Expense_Payee_Reference value
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $expense_Payee_Reference = null)
    {
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Repayment_Date value
     * @return string|null
     */
    public function getRepayment_Date()
    {
        return $this->Repayment_Date;
    }
    /**
     * Set Repayment_Date value
     * @param string $repayment_Date
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setRepayment_Date($repayment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Date) && !is_string($repayment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Date, true), gettype($repayment_Date)), __LINE__);
        }
        $this->Repayment_Date = $repayment_Date;
        return $this;
    }
    /**
     * Get Repayment_Amount value
     * @return float|null
     */
    public function getRepayment_Amount()
    {
        return $this->Repayment_Amount;
    }
    /**
     * Set Repayment_Amount value
     * @param float $repayment_Amount
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setRepayment_Amount($repayment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($repayment_Amount) && !(is_float($repayment_Amount) || is_numeric($repayment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($repayment_Amount, true), gettype($repayment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($repayment_Amount) && mb_strlen(mb_substr($repayment_Amount, false !== mb_strpos($repayment_Amount, '.') ? mb_strpos($repayment_Amount, '.') + 1 : mb_strlen($repayment_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($repayment_Amount, true), mb_strlen(mb_substr($repayment_Amount, mb_strpos($repayment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($repayment_Amount) && $repayment_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($repayment_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($repayment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($repayment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount))), __LINE__);
        }
        $this->Repayment_Amount = $repayment_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Repayment_Reference_Detail value
     * @return string|null
     */
    public function getRepayment_Reference_Detail()
    {
        return $this->Repayment_Reference_Detail;
    }
    /**
     * Set Repayment_Reference_Detail value
     * @param string $repayment_Reference_Detail
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setRepayment_Reference_Detail($repayment_Reference_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Reference_Detail) && !is_string($repayment_Reference_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Reference_Detail, true), gettype($repayment_Reference_Detail)), __LINE__);
        }
        $this->Repayment_Reference_Detail = $repayment_Reference_Detail;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receivable_Repayment_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
