<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_Journal_LinesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Journal Lines Shown where there is Gain/Loss in the Receivable Repayment amount
 * @subpackage Structs
 */
class Receivable_Repayment_Journal_LinesType extends AbstractStructBase
{
    /**
     * The Accounting_Posting_Rule_Type_Name
     * Meta information extracted from the WSDL
     * - documentation: Account Posting Rule Type Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounting_Posting_Rule_Type_Name;
    /**
     * The Transaction_Debit_Amount_Override
     * Meta information extracted from the WSDL
     * - documentation: Transaction Debit Amount Override
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Transaction_Debit_Amount_Override;
    /**
     * The Transaction_Credit_Amount_Override
     * Meta information extracted from the WSDL
     * - documentation: Transaction Credit Amount Override
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Transaction_Credit_Amount_Override;
    /**
     * The Transaction_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Transaction Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Transaction_Currency_Reference;
    /**
     * The Debit_Amount
     * Meta information extracted from the WSDL
     * - documentation: Debit Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Debit_Amount;
    /**
     * The Credit_Amount
     * Meta information extracted from the WSDL
     * - documentation: Credit Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Credit_Amount;
    /**
     * The Base_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Base Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Base_Currency_Reference;
    /**
     * The Accounting_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Accounting Worktag(s)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Accounting_Worktag_Reference;
    /**
     * Constructor method for Receivable_Repayment_Journal_LinesType
     * @uses Receivable_Repayment_Journal_LinesType::setAccounting_Posting_Rule_Type_Name()
     * @uses Receivable_Repayment_Journal_LinesType::setTransaction_Debit_Amount_Override()
     * @uses Receivable_Repayment_Journal_LinesType::setTransaction_Credit_Amount_Override()
     * @uses Receivable_Repayment_Journal_LinesType::setTransaction_Currency_Reference()
     * @uses Receivable_Repayment_Journal_LinesType::setDebit_Amount()
     * @uses Receivable_Repayment_Journal_LinesType::setCredit_Amount()
     * @uses Receivable_Repayment_Journal_LinesType::setBase_Currency_Reference()
     * @uses Receivable_Repayment_Journal_LinesType::setAccounting_Worktag_Reference()
     * @param string $accounting_Posting_Rule_Type_Name
     * @param float $transaction_Debit_Amount_Override
     * @param float $transaction_Credit_Amount_Override
     * @param \StructType\CurrencyObjectType $transaction_Currency_Reference
     * @param float $debit_Amount
     * @param float $credit_Amount
     * @param \StructType\CurrencyObjectType $base_Currency_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $accounting_Worktag_Reference
     */
    public function __construct($accounting_Posting_Rule_Type_Name = null, $transaction_Debit_Amount_Override = null, $transaction_Credit_Amount_Override = null, \StructType\CurrencyObjectType $transaction_Currency_Reference = null, $debit_Amount = null, $credit_Amount = null, \StructType\CurrencyObjectType $base_Currency_Reference = null, array $accounting_Worktag_Reference = array())
    {
        $this
            ->setAccounting_Posting_Rule_Type_Name($accounting_Posting_Rule_Type_Name)
            ->setTransaction_Debit_Amount_Override($transaction_Debit_Amount_Override)
            ->setTransaction_Credit_Amount_Override($transaction_Credit_Amount_Override)
            ->setTransaction_Currency_Reference($transaction_Currency_Reference)
            ->setDebit_Amount($debit_Amount)
            ->setCredit_Amount($credit_Amount)
            ->setBase_Currency_Reference($base_Currency_Reference)
            ->setAccounting_Worktag_Reference($accounting_Worktag_Reference);
    }
    /**
     * Get Accounting_Posting_Rule_Type_Name value
     * @return string|null
     */
    public function getAccounting_Posting_Rule_Type_Name()
    {
        return $this->Accounting_Posting_Rule_Type_Name;
    }
    /**
     * Set Accounting_Posting_Rule_Type_Name value
     * @param string $accounting_Posting_Rule_Type_Name
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setAccounting_Posting_Rule_Type_Name($accounting_Posting_Rule_Type_Name = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Posting_Rule_Type_Name) && !is_string($accounting_Posting_Rule_Type_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Posting_Rule_Type_Name, true), gettype($accounting_Posting_Rule_Type_Name)), __LINE__);
        }
        $this->Accounting_Posting_Rule_Type_Name = $accounting_Posting_Rule_Type_Name;
        return $this;
    }
    /**
     * Get Transaction_Debit_Amount_Override value
     * @return float|null
     */
    public function getTransaction_Debit_Amount_Override()
    {
        return $this->Transaction_Debit_Amount_Override;
    }
    /**
     * Set Transaction_Debit_Amount_Override value
     * @param float $transaction_Debit_Amount_Override
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setTransaction_Debit_Amount_Override($transaction_Debit_Amount_Override = null)
    {
        // validation for constraint: float
        if (!is_null($transaction_Debit_Amount_Override) && !(is_float($transaction_Debit_Amount_Override) || is_numeric($transaction_Debit_Amount_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transaction_Debit_Amount_Override, true), gettype($transaction_Debit_Amount_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($transaction_Debit_Amount_Override) && mb_strlen(mb_substr($transaction_Debit_Amount_Override, false !== mb_strpos($transaction_Debit_Amount_Override, '.') ? mb_strpos($transaction_Debit_Amount_Override, '.') + 1 : mb_strlen($transaction_Debit_Amount_Override))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($transaction_Debit_Amount_Override, true), mb_strlen(mb_substr($transaction_Debit_Amount_Override, mb_strpos($transaction_Debit_Amount_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($transaction_Debit_Amount_Override) && mb_strlen(preg_replace('/(\D)/', '', $transaction_Debit_Amount_Override)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($transaction_Debit_Amount_Override, true), mb_strlen(preg_replace('/(\D)/', '', $transaction_Debit_Amount_Override))), __LINE__);
        }
        $this->Transaction_Debit_Amount_Override = $transaction_Debit_Amount_Override;
        return $this;
    }
    /**
     * Get Transaction_Credit_Amount_Override value
     * @return float|null
     */
    public function getTransaction_Credit_Amount_Override()
    {
        return $this->Transaction_Credit_Amount_Override;
    }
    /**
     * Set Transaction_Credit_Amount_Override value
     * @param float $transaction_Credit_Amount_Override
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setTransaction_Credit_Amount_Override($transaction_Credit_Amount_Override = null)
    {
        // validation for constraint: float
        if (!is_null($transaction_Credit_Amount_Override) && !(is_float($transaction_Credit_Amount_Override) || is_numeric($transaction_Credit_Amount_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transaction_Credit_Amount_Override, true), gettype($transaction_Credit_Amount_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($transaction_Credit_Amount_Override) && mb_strlen(mb_substr($transaction_Credit_Amount_Override, false !== mb_strpos($transaction_Credit_Amount_Override, '.') ? mb_strpos($transaction_Credit_Amount_Override, '.') + 1 : mb_strlen($transaction_Credit_Amount_Override))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($transaction_Credit_Amount_Override, true), mb_strlen(mb_substr($transaction_Credit_Amount_Override, mb_strpos($transaction_Credit_Amount_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($transaction_Credit_Amount_Override) && mb_strlen(preg_replace('/(\D)/', '', $transaction_Credit_Amount_Override)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($transaction_Credit_Amount_Override, true), mb_strlen(preg_replace('/(\D)/', '', $transaction_Credit_Amount_Override))), __LINE__);
        }
        $this->Transaction_Credit_Amount_Override = $transaction_Credit_Amount_Override;
        return $this;
    }
    /**
     * Get Transaction_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getTransaction_Currency_Reference()
    {
        return $this->Transaction_Currency_Reference;
    }
    /**
     * Set Transaction_Currency_Reference value
     * @param \StructType\CurrencyObjectType $transaction_Currency_Reference
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setTransaction_Currency_Reference(\StructType\CurrencyObjectType $transaction_Currency_Reference = null)
    {
        $this->Transaction_Currency_Reference = $transaction_Currency_Reference;
        return $this;
    }
    /**
     * Get Debit_Amount value
     * @return float|null
     */
    public function getDebit_Amount()
    {
        return $this->Debit_Amount;
    }
    /**
     * Set Debit_Amount value
     * @param float $debit_Amount
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setDebit_Amount($debit_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($debit_Amount) && !(is_float($debit_Amount) || is_numeric($debit_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debit_Amount, true), gettype($debit_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($debit_Amount) && mb_strlen(mb_substr($debit_Amount, false !== mb_strpos($debit_Amount, '.') ? mb_strpos($debit_Amount, '.') + 1 : mb_strlen($debit_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($debit_Amount, true), mb_strlen(mb_substr($debit_Amount, mb_strpos($debit_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($debit_Amount) && mb_strlen(preg_replace('/(\D)/', '', $debit_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($debit_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $debit_Amount))), __LINE__);
        }
        $this->Debit_Amount = $debit_Amount;
        return $this;
    }
    /**
     * Get Credit_Amount value
     * @return float|null
     */
    public function getCredit_Amount()
    {
        return $this->Credit_Amount;
    }
    /**
     * Set Credit_Amount value
     * @param float $credit_Amount
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setCredit_Amount($credit_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($credit_Amount) && !(is_float($credit_Amount) || is_numeric($credit_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit_Amount, true), gettype($credit_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($credit_Amount) && mb_strlen(mb_substr($credit_Amount, false !== mb_strpos($credit_Amount, '.') ? mb_strpos($credit_Amount, '.') + 1 : mb_strlen($credit_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($credit_Amount, true), mb_strlen(mb_substr($credit_Amount, mb_strpos($credit_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($credit_Amount) && mb_strlen(preg_replace('/(\D)/', '', $credit_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($credit_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $credit_Amount))), __LINE__);
        }
        $this->Credit_Amount = $credit_Amount;
        return $this;
    }
    /**
     * Get Base_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getBase_Currency_Reference()
    {
        return $this->Base_Currency_Reference;
    }
    /**
     * Set Base_Currency_Reference value
     * @param \StructType\CurrencyObjectType $base_Currency_Reference
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setBase_Currency_Reference(\StructType\CurrencyObjectType $base_Currency_Reference = null)
    {
        $this->Base_Currency_Reference = $base_Currency_Reference;
        return $this;
    }
    /**
     * Get Accounting_Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getAccounting_Worktag_Reference()
    {
        return $this->Accounting_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAccounting_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccounting_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccounting_Worktag_ReferenceForArrayConstraintsFromSetAccounting_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_Journal_LinesTypeAccounting_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_Journal_LinesTypeAccounting_Worktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($receivable_Repayment_Journal_LinesTypeAccounting_Worktag_ReferenceItem) ? get_class($receivable_Repayment_Journal_LinesTypeAccounting_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($receivable_Repayment_Journal_LinesTypeAccounting_Worktag_ReferenceItem), var_export($receivable_Repayment_Journal_LinesTypeAccounting_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accounting_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accounting_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $accounting_Worktag_Reference
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function setAccounting_Worktag_Reference(array $accounting_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($accounting_Worktag_ReferenceArrayErrorMessage = self::validateAccounting_Worktag_ReferenceForArrayConstraintsFromSetAccounting_Worktag_Reference($accounting_Worktag_Reference))) {
            throw new \InvalidArgumentException($accounting_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Accounting_Worktag_Reference = $accounting_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to Accounting_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Receivable_Repayment_Journal_LinesType
     */
    public function addToAccounting_Worktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Accounting_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accounting_Worktag_Reference[] = $item;
        return $this;
    }
}
