<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Organization Reference must be Companies or Company Hierarchies | Receipt Date On or After must be earlier than Receipt Date On or Before. | Supplier reference is for a supplier that can be used as a basic worktag only. | Utilize the
 * following element to find receipts in the Workday system.
 * @subpackage Structs
 */
class Receipt_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Receipt_Number
     * Meta information extracted from the WSDL
     * - documentation: Receipt Number. Allows for search for a partial sub-string match.
     * - base: xsd:string
     * - maxLength: 513
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Number;
    /**
     * The Receipt_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Receipt Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Date_On_or_After;
    /**
     * The Receipt_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Receipt Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Date_On_or_Before;
    /**
     * The Receipt_Status
     * Meta information extracted from the WSDL
     * - documentation: Receipt Status. Examples of valid statuses are In Progress, Canceled, Approved, Denied
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Status;
    /**
     * The Creating_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Creating Worker for the Receipt
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Creating_Worker_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Receipt_Last_Updated_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Search for Receipts Last Updated On or After this Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Last_Updated_Date_On_or_After;
    /**
     * The Receipt_Last_Updated_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Search for Receipts last updated On or Before this Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Last_Updated_Date_On_or_Before;
    /**
     * Constructor method for Receipt_Request_CriteriaType
     * @uses Receipt_Request_CriteriaType::setOrganization_Reference()
     * @uses Receipt_Request_CriteriaType::setSupplier_Reference()
     * @uses Receipt_Request_CriteriaType::setReceipt_Number()
     * @uses Receipt_Request_CriteriaType::setReceipt_Date_On_or_After()
     * @uses Receipt_Request_CriteriaType::setReceipt_Date_On_or_Before()
     * @uses Receipt_Request_CriteriaType::setReceipt_Status()
     * @uses Receipt_Request_CriteriaType::setCreating_Worker_Reference()
     * @uses Receipt_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Receipt_Request_CriteriaType::setSupplier_Invoice_Reference()
     * @uses Receipt_Request_CriteriaType::setReceipt_Last_Updated_Date_On_or_After()
     * @uses Receipt_Request_CriteriaType::setReceipt_Last_Updated_Date_On_or_Before()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param string $receipt_Number
     * @param string $receipt_Date_On_or_After
     * @param string $receipt_Date_On_or_Before
     * @param string $receipt_Status
     * @param \StructType\WorkerObjectType[] $creating_Worker_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param string $receipt_Last_Updated_Date_On_or_After
     * @param string $receipt_Last_Updated_Date_On_or_Before
     */
    public function __construct(array $organization_Reference = array(), array $supplier_Reference = array(), $receipt_Number = null, $receipt_Date_On_or_After = null, $receipt_Date_On_or_Before = null, $receipt_Status = null, array $creating_Worker_Reference = array(), \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, $receipt_Last_Updated_Date_On_or_After = null, $receipt_Last_Updated_Date_On_or_Before = null)
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setReceipt_Number($receipt_Number)
            ->setReceipt_Date_On_or_After($receipt_Date_On_or_After)
            ->setReceipt_Date_On_or_Before($receipt_Date_On_or_Before)
            ->setReceipt_Status($receipt_Status)
            ->setCreating_Worker_Reference($creating_Worker_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setReceipt_Last_Updated_Date_On_or_After($receipt_Last_Updated_Date_On_or_After)
            ->setReceipt_Last_Updated_Date_On_or_Before($receipt_Last_Updated_Date_On_or_Before);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($receipt_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($receipt_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Request_CriteriaTypeOrganization_ReferenceItem), var_export($receipt_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($receipt_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($receipt_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Request_CriteriaTypeSupplier_ReferenceItem), var_export($receipt_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Receipt_Number value
     * @return string|null
     */
    public function getReceipt_Number()
    {
        return $this->Receipt_Number;
    }
    /**
     * Set Receipt_Number value
     * @param string $receipt_Number
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setReceipt_Number($receipt_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Number) && !is_string($receipt_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Number, true), gettype($receipt_Number)), __LINE__);
        }
        // validation for constraint: maxLength(513)
        if (!is_null($receipt_Number) && mb_strlen($receipt_Number) > 513) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 513', mb_strlen($receipt_Number)), __LINE__);
        }
        $this->Receipt_Number = $receipt_Number;
        return $this;
    }
    /**
     * Get Receipt_Date_On_or_After value
     * @return string|null
     */
    public function getReceipt_Date_On_or_After()
    {
        return $this->Receipt_Date_On_or_After;
    }
    /**
     * Set Receipt_Date_On_or_After value
     * @param string $receipt_Date_On_or_After
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setReceipt_Date_On_or_After($receipt_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Date_On_or_After) && !is_string($receipt_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Date_On_or_After, true), gettype($receipt_Date_On_or_After)), __LINE__);
        }
        $this->Receipt_Date_On_or_After = $receipt_Date_On_or_After;
        return $this;
    }
    /**
     * Get Receipt_Date_On_or_Before value
     * @return string|null
     */
    public function getReceipt_Date_On_or_Before()
    {
        return $this->Receipt_Date_On_or_Before;
    }
    /**
     * Set Receipt_Date_On_or_Before value
     * @param string $receipt_Date_On_or_Before
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setReceipt_Date_On_or_Before($receipt_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Date_On_or_Before) && !is_string($receipt_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Date_On_or_Before, true), gettype($receipt_Date_On_or_Before)), __LINE__);
        }
        $this->Receipt_Date_On_or_Before = $receipt_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Receipt_Status value
     * @return string|null
     */
    public function getReceipt_Status()
    {
        return $this->Receipt_Status;
    }
    /**
     * Set Receipt_Status value
     * @param string $receipt_Status
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setReceipt_Status($receipt_Status = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Status) && !is_string($receipt_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Status, true), gettype($receipt_Status)), __LINE__);
        }
        $this->Receipt_Status = $receipt_Status;
        return $this;
    }
    /**
     * Get Creating_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreating_Worker_Reference()
    {
        return $this->Creating_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreating_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreating_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreating_Worker_ReferenceForArrayConstraintsFromSetCreating_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Request_CriteriaTypeCreating_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Request_CriteriaTypeCreating_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($receipt_Request_CriteriaTypeCreating_Worker_ReferenceItem) ? get_class($receipt_Request_CriteriaTypeCreating_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Request_CriteriaTypeCreating_Worker_ReferenceItem), var_export($receipt_Request_CriteriaTypeCreating_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Creating_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Creating_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $creating_Worker_Reference
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setCreating_Worker_Reference(array $creating_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($creating_Worker_ReferenceArrayErrorMessage = self::validateCreating_Worker_ReferenceForArrayConstraintsFromSetCreating_Worker_Reference($creating_Worker_Reference))) {
            throw new \InvalidArgumentException($creating_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Creating_Worker_Reference = $creating_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Creating_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function addToCreating_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Creating_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Creating_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Receipt_Last_Updated_Date_On_or_After value
     * @return string|null
     */
    public function getReceipt_Last_Updated_Date_On_or_After()
    {
        return $this->Receipt_Last_Updated_Date_On_or_After;
    }
    /**
     * Set Receipt_Last_Updated_Date_On_or_After value
     * @param string $receipt_Last_Updated_Date_On_or_After
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setReceipt_Last_Updated_Date_On_or_After($receipt_Last_Updated_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Last_Updated_Date_On_or_After) && !is_string($receipt_Last_Updated_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Last_Updated_Date_On_or_After, true), gettype($receipt_Last_Updated_Date_On_or_After)), __LINE__);
        }
        $this->Receipt_Last_Updated_Date_On_or_After = $receipt_Last_Updated_Date_On_or_After;
        return $this;
    }
    /**
     * Get Receipt_Last_Updated_Date_On_or_Before value
     * @return string|null
     */
    public function getReceipt_Last_Updated_Date_On_or_Before()
    {
        return $this->Receipt_Last_Updated_Date_On_or_Before;
    }
    /**
     * Set Receipt_Last_Updated_Date_On_or_Before value
     * @param string $receipt_Last_Updated_Date_On_or_Before
     * @return \StructType\Receipt_Request_CriteriaType
     */
    public function setReceipt_Last_Updated_Date_On_or_Before($receipt_Last_Updated_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Last_Updated_Date_On_or_Before) && !is_string($receipt_Last_Updated_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Last_Updated_Date_On_or_Before, true), gettype($receipt_Last_Updated_Date_On_or_Before)), __LINE__);
        }
        $this->Receipt_Last_Updated_Date_On_or_Before = $receipt_Last_Updated_Date_On_or_Before;
        return $this;
    }
}
