<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for all supplier request data
 * @subpackage Structs
 */
class Put_Supplier_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Data
     * Meta information extracted from the WSDL
     * - documentation: This Element contains Supplier attributes.
     * @var \StructType\Supplier_DataType
     */
    public $Supplier_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_RequestType
     * @uses Put_Supplier_RequestType::setSupplier_Reference()
     * @uses Put_Supplier_RequestType::setSupplier_Data()
     * @uses Put_Supplier_RequestType::setAdd_Only()
     * @uses Put_Supplier_RequestType::setVersion()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Supplier_DataType $supplier_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Supplier_DataType $supplier_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Data($supplier_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Put_Supplier_RequestType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Data value
     * @return \StructType\Supplier_DataType|null
     */
    public function getSupplier_Data()
    {
        return $this->Supplier_Data;
    }
    /**
     * Set Supplier_Data value
     * @param \StructType\Supplier_DataType $supplier_Data
     * @return \StructType\Put_Supplier_RequestType
     */
    public function setSupplier_Data(\StructType\Supplier_DataType $supplier_Data = null)
    {
        $this->Supplier_Data = $supplier_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Supplier_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
