<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Budget_Template_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request Element for adding or modifying a Project Budget Template.
 * @subpackage Structs
 */
class Put_Project_Budget_Template_RequestType extends AbstractStructBase
{
    /**
     * The Project_Budget_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Project Budget Template to edit.
     * - minOccurs: 0
     * @var \StructType\Project_Budget_TemplateObjectType
     */
    public $Project_Budget_Template_Reference;
    /**
     * The Project_Budget_Template_Data
     * @var \StructType\Project_Budget_Template_DataType
     */
    public $Project_Budget_Template_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Budget_Template_RequestType
     * @uses Put_Project_Budget_Template_RequestType::setProject_Budget_Template_Reference()
     * @uses Put_Project_Budget_Template_RequestType::setProject_Budget_Template_Data()
     * @uses Put_Project_Budget_Template_RequestType::setAdd_Only()
     * @uses Put_Project_Budget_Template_RequestType::setVersion()
     * @param \StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference
     * @param \StructType\Project_Budget_Template_DataType $project_Budget_Template_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference = null, \StructType\Project_Budget_Template_DataType $project_Budget_Template_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Budget_Template_Reference($project_Budget_Template_Reference)
            ->setProject_Budget_Template_Data($project_Budget_Template_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Budget_Template_Reference value
     * @return \StructType\Project_Budget_TemplateObjectType|null
     */
    public function getProject_Budget_Template_Reference()
    {
        return $this->Project_Budget_Template_Reference;
    }
    /**
     * Set Project_Budget_Template_Reference value
     * @param \StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference
     * @return \StructType\Put_Project_Budget_Template_RequestType
     */
    public function setProject_Budget_Template_Reference(\StructType\Project_Budget_TemplateObjectType $project_Budget_Template_Reference = null)
    {
        $this->Project_Budget_Template_Reference = $project_Budget_Template_Reference;
        return $this;
    }
    /**
     * Get Project_Budget_Template_Data value
     * @return \StructType\Project_Budget_Template_DataType|null
     */
    public function getProject_Budget_Template_Data()
    {
        return $this->Project_Budget_Template_Data;
    }
    /**
     * Set Project_Budget_Template_Data value
     * @param \StructType\Project_Budget_Template_DataType $project_Budget_Template_Data
     * @return \StructType\Put_Project_Budget_Template_RequestType
     */
    public function setProject_Budget_Template_Data(\StructType\Project_Budget_Template_DataType $project_Budget_Template_Data = null)
    {
        $this->Project_Budget_Template_Data = $project_Budget_Template_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Project_Budget_Template_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Budget_Template_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
