<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Item_Tag_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The element used for creating or updating the item tag.
 * @subpackage Structs
 */
class Put_Item_Tag_RequestType extends AbstractStructBase
{
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to item tag.
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType
     */
    public $Item_Tag_Reference;
    /**
     * The Item_Tag_Data
     * Meta information extracted from the WSDL
     * - documentation: The data associated to the item tag that you're creating or updating.
     * - minOccurs: 0
     * @var \StructType\Item_Tag_DataType
     */
    public $Item_Tag_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Item_Tag_RequestType
     * @uses Put_Item_Tag_RequestType::setItem_Tag_Reference()
     * @uses Put_Item_Tag_RequestType::setItem_Tag_Data()
     * @uses Put_Item_Tag_RequestType::setAdd_Only()
     * @uses Put_Item_Tag_RequestType::setVersion()
     * @param \StructType\Item_TagObjectType $item_Tag_Reference
     * @param \StructType\Item_Tag_DataType $item_Tag_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Item_TagObjectType $item_Tag_Reference = null, \StructType\Item_Tag_DataType $item_Tag_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setItem_Tag_Data($item_Tag_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * Set Item_Tag_Reference value
     * @param \StructType\Item_TagObjectType $item_Tag_Reference
     * @return \StructType\Put_Item_Tag_RequestType
     */
    public function setItem_Tag_Reference(\StructType\Item_TagObjectType $item_Tag_Reference = null)
    {
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Get Item_Tag_Data value
     * @return \StructType\Item_Tag_DataType|null
     */
    public function getItem_Tag_Data()
    {
        return $this->Item_Tag_Data;
    }
    /**
     * Set Item_Tag_Data value
     * @param \StructType\Item_Tag_DataType $item_Tag_Data
     * @return \StructType\Put_Item_Tag_RequestType
     */
    public function setItem_Tag_Data(\StructType\Item_Tag_DataType $item_Tag_Data = null)
    {
        $this->Item_Tag_Data = $item_Tag_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Item_Tag_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Item_Tag_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
