<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Item_Identifier_Type_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Item Identifier Type, or change 'Add Only' to 'false' to edit the existing Item Identifier Type. | The element containing put item identifier type request.
 * @subpackage Structs
 */
class Put_Item_Identifier_Type_RequestType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to item identifier type.
     * - minOccurs: 0
     * @var \StructType\Item_Identifier_TypeObjectType
     */
    public $Item_Identifier_Type_Reference;
    /**
     * The Item_Identifier_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: The element containing data associated with item identifier type.
     * @var \StructType\Item_Identifier_Type_DataType
     */
    public $Item_Identifier_Type_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if its add only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Item_Identifier_Type_RequestType
     * @uses Put_Item_Identifier_Type_RequestType::setItem_Identifier_Type_Reference()
     * @uses Put_Item_Identifier_Type_RequestType::setItem_Identifier_Type_Data()
     * @uses Put_Item_Identifier_Type_RequestType::setAdd_Only()
     * @uses Put_Item_Identifier_Type_RequestType::setVersion()
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @param \StructType\Item_Identifier_Type_DataType $item_Identifier_Type_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null, \StructType\Item_Identifier_Type_DataType $item_Identifier_Type_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setItem_Identifier_Type_Reference($item_Identifier_Type_Reference)
            ->setItem_Identifier_Type_Data($item_Identifier_Type_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Item_Identifier_Type_Reference value
     * @return \StructType\Item_Identifier_TypeObjectType|null
     */
    public function getItem_Identifier_Type_Reference()
    {
        return $this->Item_Identifier_Type_Reference;
    }
    /**
     * Set Item_Identifier_Type_Reference value
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @return \StructType\Put_Item_Identifier_Type_RequestType
     */
    public function setItem_Identifier_Type_Reference(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null)
    {
        $this->Item_Identifier_Type_Reference = $item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier_Type_Data value
     * @return \StructType\Item_Identifier_Type_DataType|null
     */
    public function getItem_Identifier_Type_Data()
    {
        return $this->Item_Identifier_Type_Data;
    }
    /**
     * Set Item_Identifier_Type_Data value
     * @param \StructType\Item_Identifier_Type_DataType $item_Identifier_Type_Data
     * @return \StructType\Put_Item_Identifier_Type_RequestType
     */
    public function setItem_Identifier_Type_Data(\StructType\Item_Identifier_Type_DataType $item_Identifier_Type_Data = null)
    {
        $this->Item_Identifier_Type_Data = $item_Identifier_Type_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Item_Identifier_Type_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Item_Identifier_Type_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
