<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Expense_Credit_Card_Transaction_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Expense Credit Card Transaction reference for update and all Expense Credit Card Transaction data items
 * @subpackage Structs
 */
class Put_Expense_Credit_Card_Transaction_RequestType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Credit Card Transaction for update only purposes
     * - minOccurs: 0
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Expense_Credit_Card_Transaction_Reference;
    /**
     * The Expense_Credit_Card_Transaction_Data
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction Data
     * @var \StructType\Credit_Card_Transaction_DataType
     */
    public $Expense_Credit_Card_Transaction_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Expense_Credit_Card_Transaction_RequestType
     * @uses Put_Expense_Credit_Card_Transaction_RequestType::setExpense_Credit_Card_Transaction_Reference()
     * @uses Put_Expense_Credit_Card_Transaction_RequestType::setExpense_Credit_Card_Transaction_Data()
     * @uses Put_Expense_Credit_Card_Transaction_RequestType::setAdd_Only()
     * @uses Put_Expense_Credit_Card_Transaction_RequestType::setVersion()
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @param \StructType\Credit_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null, \StructType\Credit_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference)
            ->setExpense_Credit_Card_Transaction_Data($expense_Credit_Card_Transaction_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getExpense_Credit_Card_Transaction_Reference()
    {
        return $this->Expense_Credit_Card_Transaction_Reference;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Reference value
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @return \StructType\Put_Expense_Credit_Card_Transaction_RequestType
     */
    public function setExpense_Credit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null)
    {
        $this->Expense_Credit_Card_Transaction_Reference = $expense_Credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Transaction_Data value
     * @return \StructType\Credit_Card_Transaction_DataType|null
     */
    public function getExpense_Credit_Card_Transaction_Data()
    {
        return $this->Expense_Credit_Card_Transaction_Data;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Data value
     * @param \StructType\Credit_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data
     * @return \StructType\Put_Expense_Credit_Card_Transaction_RequestType
     */
    public function setExpense_Credit_Card_Transaction_Data(\StructType\Credit_Card_Transaction_DataType $expense_Credit_Card_Transaction_Data = null)
    {
        $this->Expense_Credit_Card_Transaction_Data = $expense_Credit_Card_Transaction_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Expense_Credit_Card_Transaction_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Expense_Credit_Card_Transaction_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
