<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Corporate_Credit_Card_Billing_Account_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Put Corporate Credit Card Account Response Data
 * @subpackage Structs
 */
class Put_Corporate_Credit_Card_Billing_Account_ResponseType extends AbstractStructBase
{
    /**
     * The Corporate_Credit_Card_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Corporate Credit Card Account
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Credit_Card_Account_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Corporate_Credit_Card_Billing_Account_ResponseType
     * @uses Put_Corporate_Credit_Card_Billing_Account_ResponseType::setCorporate_Credit_Card_Account_Reference()
     * @uses Put_Corporate_Credit_Card_Billing_Account_ResponseType::setVersion()
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @param string $version
     */
    public function __construct(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null, $version = null)
    {
        $this
            ->setCorporate_Credit_Card_Account_Reference($corporate_Credit_Card_Account_Reference)
            ->setVersion($version);
    }
    /**
     * Get Corporate_Credit_Card_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Credit_Card_Account_Reference()
    {
        return $this->Corporate_Credit_Card_Account_Reference;
    }
    /**
     * Set Corporate_Credit_Card_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_ResponseType
     */
    public function setCorporate_Credit_Card_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null)
    {
        $this->Corporate_Credit_Card_Account_Reference = $corporate_Credit_Card_Account_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
