<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Line_Additional_Data_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains the specific instance set containing the requested purchase order line. The type attribute is either Reference ID type or Workday ID (GUI) and the ID is the value for the instance of the purchase order line.
 * @subpackage Structs
 */
class Purchase_Order_Line_Additional_Data_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The purchase order line reference
     * - maxOccurs: unbounded
     * @var \StructType\Purchase_Order_LineObjectType[]
     */
    public $Purchase_Order_Line_Reference;
    /**
     * Constructor method for
     * Purchase_Order_Line_Additional_Data_Request_ReferencesType
     * @uses Purchase_Order_Line_Additional_Data_Request_ReferencesType::setPurchase_Order_Line_Reference()
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     */
    public function __construct(array $purchase_Order_Line_Reference = array())
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType[]|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Line_Additional_Data_Request_ReferencesTypePurchase_Order_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Line_Additional_Data_Request_ReferencesTypePurchase_Order_Line_ReferenceItem instanceof \StructType\Purchase_Order_LineObjectType) {
                $invalidValues[] = is_object($purchase_Order_Line_Additional_Data_Request_ReferencesTypePurchase_Order_Line_ReferenceItem) ? get_class($purchase_Order_Line_Additional_Data_Request_ReferencesTypePurchase_Order_Line_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Line_Additional_Data_Request_ReferencesTypePurchase_Order_Line_ReferenceItem), var_export($purchase_Order_Line_Additional_Data_Request_ReferencesTypePurchase_Order_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     * @return \StructType\Purchase_Order_Line_Additional_Data_Request_ReferencesType
     */
    public function setPurchase_Order_Line_Reference(array $purchase_Order_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Line_ReferenceArrayErrorMessage = self::validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference($purchase_Order_Line_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType $item
     * @return \StructType\Purchase_Order_Line_Additional_Data_Request_ReferencesType
     */
    public function addToPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Line_Reference[] = $item;
        return $this;
    }
}
