<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Installment_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You may not update installments with status Canceled, Completed, or In Progress. | Element containing Purchase Order Installment Data
 * @subpackage Structs
 */
class Purchase_Order_Installment_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Installment_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Installment Reference ID. This is the Purchase Order Installment unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Installment_ID;
    /**
     * The Purchase_Order_Installment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Installment
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_InstallmentObjectType
     */
    public $Purchase_Order_Installment_Reference;
    /**
     * The Installment_Number
     * Meta information extracted from the WSDL
     * - documentation: Installment Number for Schedule.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Installment_Number;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Installment status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Status_Reference;
    /**
     * The Purchase_Order_Date
     * Meta information extracted from the WSDL
     * - documentation: Installment Date. This will be the Purchase Order Date for the Installment.
     * - maxOccurs: 1
     * @var string
     */
    public $Purchase_Order_Date;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: Installment From date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The To_Date
     * Meta information extracted from the WSDL
     * - documentation: Installment To date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To_Date;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Purchase Order created from this Installment.
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Installment On Hold flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $On_Hold;
    /**
     * The Use_Installment_Overrides
     * Meta information extracted from the WSDL
     * - documentation: Override Line flag. Use this to specify values on the installment line instead of using values derived from either the installment, the schedule, or the contract line. This must be on to specify overrides.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Installment_Overrides;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the named buyer for the purchase order to be used as an override.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Code to be use as an override.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Purchase_Order_Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Issue Option to be used as an override.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Purchase_Order_Issue_Option_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Payment Terms to be use as an override.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Bill_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Name of the Bill-To Contact to be used as an override.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_To_Contact;
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Bill-To Address to be used as an override.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Ship_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Name of the Ship-To Contact to be used as an override.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Contact;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To Address to be used as an override.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Payment Type to be use as an override.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Procurement_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Procurement Card to be used as an override.
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Procurement_Card_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Override Installment Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Internal_Memo
     * Meta information extracted from the WSDL
     * - documentation: Override Installment Internal Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Memo;
    /**
     * The Purchase_Order_Installment_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Installment_Line_DataType[]
     */
    public $Purchase_Order_Installment_Line_Data;
    /**
     * Constructor method for Purchase_Order_Installment_Replacement_DataType
     * @uses Purchase_Order_Installment_Replacement_DataType::setPurchase_Order_Installment_ID()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPurchase_Order_Installment_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setInstallment_Number()
     * @uses Purchase_Order_Installment_Replacement_DataType::setStatus_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPurchase_Order_Date()
     * @uses Purchase_Order_Installment_Replacement_DataType::setFrom_Date()
     * @uses Purchase_Order_Installment_Replacement_DataType::setTo_Date()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPurchase_Order_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setOn_Hold()
     * @uses Purchase_Order_Installment_Replacement_DataType::setUse_Installment_Overrides()
     * @uses Purchase_Order_Installment_Replacement_DataType::setBuyer_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setTax_Code_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPurchase_Order_Issue_Option_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPayment_Terms_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setBill_To_Contact()
     * @uses Purchase_Order_Installment_Replacement_DataType::setBill_To_Address_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setShip_To_Contact()
     * @uses Purchase_Order_Installment_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPayment_Type_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setProcurement_Card_Reference()
     * @uses Purchase_Order_Installment_Replacement_DataType::setMemo()
     * @uses Purchase_Order_Installment_Replacement_DataType::setInternal_Memo()
     * @uses Purchase_Order_Installment_Replacement_DataType::setPurchase_Order_Installment_Line_Data()
     * @param string $purchase_Order_Installment_ID
     * @param \StructType\Purchase_Order_InstallmentObjectType $purchase_Order_Installment_Reference
     * @param float $installment_Number
     * @param \StructType\Document_StatusObjectType[] $status_Reference
     * @param string $purchase_Order_Date
     * @param string $from_Date
     * @param string $to_Date
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param bool $on_Hold
     * @param bool $use_Installment_Overrides
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param string $bill_To_Contact
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @param string $ship_To_Contact
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Card_Reference
     * @param string $memo
     * @param string $internal_Memo
     * @param \StructType\Supplier_Contract_Installment_Line_DataType[] $purchase_Order_Installment_Line_Data
     */
    public function __construct($purchase_Order_Installment_ID = null, \StructType\Purchase_Order_InstallmentObjectType $purchase_Order_Installment_Reference = null, $installment_Number = null, array $status_Reference = array(), $purchase_Order_Date = null, $from_Date = null, $to_Date = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $on_Hold = null, $use_Installment_Overrides = null, \StructType\WorkerObjectType $buyer_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, $bill_To_Contact = null, \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null, $ship_To_Contact = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, \StructType\Worker_Credit_CardObjectType $procurement_Card_Reference = null, $memo = null, $internal_Memo = null, array $purchase_Order_Installment_Line_Data = array())
    {
        $this
            ->setPurchase_Order_Installment_ID($purchase_Order_Installment_ID)
            ->setPurchase_Order_Installment_Reference($purchase_Order_Installment_Reference)
            ->setInstallment_Number($installment_Number)
            ->setStatus_Reference($status_Reference)
            ->setPurchase_Order_Date($purchase_Order_Date)
            ->setFrom_Date($from_Date)
            ->setTo_Date($to_Date)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setOn_Hold($on_Hold)
            ->setUse_Installment_Overrides($use_Installment_Overrides)
            ->setBuyer_Reference($buyer_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setPurchase_Order_Issue_Option_Reference($purchase_Order_Issue_Option_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setBill_To_Contact($bill_To_Contact)
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setShip_To_Contact($ship_To_Contact)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setProcurement_Card_Reference($procurement_Card_Reference)
            ->setMemo($memo)
            ->setInternal_Memo($internal_Memo)
            ->setPurchase_Order_Installment_Line_Data($purchase_Order_Installment_Line_Data);
    }
    /**
     * Get Purchase_Order_Installment_ID value
     * @return string|null
     */
    public function getPurchase_Order_Installment_ID()
    {
        return $this->Purchase_Order_Installment_ID;
    }
    /**
     * Set Purchase_Order_Installment_ID value
     * @param string $purchase_Order_Installment_ID
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPurchase_Order_Installment_ID($purchase_Order_Installment_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Installment_ID) && !is_string($purchase_Order_Installment_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Installment_ID, true), gettype($purchase_Order_Installment_ID)), __LINE__);
        }
        $this->Purchase_Order_Installment_ID = $purchase_Order_Installment_ID;
        return $this;
    }
    /**
     * Get Purchase_Order_Installment_Reference value
     * @return \StructType\Purchase_Order_InstallmentObjectType|null
     */
    public function getPurchase_Order_Installment_Reference()
    {
        return $this->Purchase_Order_Installment_Reference;
    }
    /**
     * Set Purchase_Order_Installment_Reference value
     * @param \StructType\Purchase_Order_InstallmentObjectType $purchase_Order_Installment_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPurchase_Order_Installment_Reference(\StructType\Purchase_Order_InstallmentObjectType $purchase_Order_Installment_Reference = null)
    {
        $this->Purchase_Order_Installment_Reference = $purchase_Order_Installment_Reference;
        return $this;
    }
    /**
     * Get Installment_Number value
     * @return float|null
     */
    public function getInstallment_Number()
    {
        return $this->Installment_Number;
    }
    /**
     * Set Installment_Number value
     * @param float $installment_Number
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setInstallment_Number($installment_Number = null)
    {
        // validation for constraint: float
        if (!is_null($installment_Number) && !(is_float($installment_Number) || is_numeric($installment_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installment_Number, true), gettype($installment_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($installment_Number) && mb_strlen(mb_substr($installment_Number, false !== mb_strpos($installment_Number, '.') ? mb_strpos($installment_Number, '.') + 1 : mb_strlen($installment_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($installment_Number, true), mb_strlen(mb_substr($installment_Number, mb_strpos($installment_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($installment_Number) && mb_strlen(preg_replace('/(\D)/', '', $installment_Number)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($installment_Number, true), mb_strlen(preg_replace('/(\D)/', '', $installment_Number))), __LINE__);
        }
        $this->Installment_Number = $installment_Number;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatus_ReferenceForArrayConstraintsFromSetStatus_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Installment_Replacement_DataTypeStatus_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Installment_Replacement_DataTypeStatus_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($purchase_Order_Installment_Replacement_DataTypeStatus_ReferenceItem) ? get_class($purchase_Order_Installment_Replacement_DataTypeStatus_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Installment_Replacement_DataTypeStatus_ReferenceItem), var_export($purchase_Order_Installment_Replacement_DataTypeStatus_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $status_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setStatus_Reference(array $status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($status_ReferenceArrayErrorMessage = self::validateStatus_ReferenceForArrayConstraintsFromSetStatus_Reference($status_Reference))) {
            throw new \InvalidArgumentException($status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Add item to Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function addToStatus_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Date value
     * @return string|null
     */
    public function getPurchase_Order_Date()
    {
        return $this->Purchase_Order_Date;
    }
    /**
     * Set Purchase_Order_Date value
     * @param string $purchase_Order_Date
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPurchase_Order_Date($purchase_Order_Date = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Date) && !is_string($purchase_Order_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Date, true), gettype($purchase_Order_Date)), __LINE__);
        }
        $this->Purchase_Order_Date = $purchase_Order_Date;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get To_Date value
     * @return string|null
     */
    public function getTo_Date()
    {
        return $this->To_Date;
    }
    /**
     * Set To_Date value
     * @param string $to_Date
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setTo_Date($to_Date = null)
    {
        // validation for constraint: string
        if (!is_null($to_Date) && !is_string($to_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_Date, true), gettype($to_Date)), __LINE__);
        }
        $this->To_Date = $to_Date;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get On_Hold value
     * @return bool|null
     */
    public function getOn_Hold()
    {
        return $this->On_Hold;
    }
    /**
     * Set On_Hold value
     * @param bool $on_Hold
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setOn_Hold($on_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($on_Hold) && !is_bool($on_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($on_Hold, true), gettype($on_Hold)), __LINE__);
        }
        $this->On_Hold = $on_Hold;
        return $this;
    }
    /**
     * Get Use_Installment_Overrides value
     * @return bool|null
     */
    public function getUse_Installment_Overrides()
    {
        return $this->Use_Installment_Overrides;
    }
    /**
     * Set Use_Installment_Overrides value
     * @param bool $use_Installment_Overrides
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setUse_Installment_Overrides($use_Installment_Overrides = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Installment_Overrides) && !is_bool($use_Installment_Overrides)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Installment_Overrides, true), gettype($use_Installment_Overrides)), __LINE__);
        }
        $this->Use_Installment_Overrides = $use_Installment_Overrides;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getPurchase_Order_Issue_Option_Reference()
    {
        return $this->Purchase_Order_Issue_Option_Reference;
    }
    /**
     * Set Purchase_Order_Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPurchase_Order_Issue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null)
    {
        $this->Purchase_Order_Issue_Option_Reference = $purchase_Order_Issue_Option_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact value
     * @return string|null
     */
    public function getBill_To_Contact()
    {
        return $this->{'Bill-To_Contact'};
    }
    /**
     * Set Bill_To_Contact value
     * @param string $bill_To_Contact
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setBill_To_Contact($bill_To_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Contact) && !is_string($bill_To_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Contact, true), gettype($bill_To_Contact)), __LINE__);
        }
        $this->Bill_To_Contact = $this->{'Bill-To_Contact'} = $bill_To_Contact;
        return $this;
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->{'Bill-To_Address_Reference'};
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setBill_To_Address_Reference(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $this->{'Bill-To_Address_Reference'} = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact value
     * @return string|null
     */
    public function getShip_To_Contact()
    {
        return $this->{'Ship-To_Contact'};
    }
    /**
     * Set Ship_To_Contact value
     * @param string $ship_To_Contact
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setShip_To_Contact($ship_To_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Contact) && !is_string($ship_To_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Contact, true), gettype($ship_To_Contact)), __LINE__);
        }
        $this->Ship_To_Contact = $this->{'Ship-To_Contact'} = $ship_To_Contact;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Procurement_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getProcurement_Card_Reference()
    {
        return $this->Procurement_Card_Reference;
    }
    /**
     * Set Procurement_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Card_Reference
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setProcurement_Card_Reference(\StructType\Worker_Credit_CardObjectType $procurement_Card_Reference = null)
    {
        $this->Procurement_Card_Reference = $procurement_Card_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Internal_Memo value
     * @return string|null
     */
    public function getInternal_Memo()
    {
        return $this->Internal_Memo;
    }
    /**
     * Set Internal_Memo value
     * @param string $internal_Memo
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setInternal_Memo($internal_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Memo) && !is_string($internal_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Memo, true), gettype($internal_Memo)), __LINE__);
        }
        $this->Internal_Memo = $internal_Memo;
        return $this;
    }
    /**
     * Get Purchase_Order_Installment_Line_Data value
     * @return \StructType\Supplier_Contract_Installment_Line_DataType[]|null
     */
    public function getPurchase_Order_Installment_Line_Data()
    {
        return $this->Purchase_Order_Installment_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Installment_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Installment_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Installment_Line_DataForArrayConstraintsFromSetPurchase_Order_Installment_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Installment_Replacement_DataTypePurchase_Order_Installment_Line_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Installment_Replacement_DataTypePurchase_Order_Installment_Line_DataItem instanceof \StructType\Supplier_Contract_Installment_Line_DataType) {
                $invalidValues[] = is_object($purchase_Order_Installment_Replacement_DataTypePurchase_Order_Installment_Line_DataItem) ? get_class($purchase_Order_Installment_Replacement_DataTypePurchase_Order_Installment_Line_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Installment_Replacement_DataTypePurchase_Order_Installment_Line_DataItem), var_export($purchase_Order_Installment_Replacement_DataTypePurchase_Order_Installment_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Installment_Line_Data property can only contain items of type \StructType\Supplier_Contract_Installment_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Installment_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Installment_Line_DataType[] $purchase_Order_Installment_Line_Data
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function setPurchase_Order_Installment_Line_Data(array $purchase_Order_Installment_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Installment_Line_DataArrayErrorMessage = self::validatePurchase_Order_Installment_Line_DataForArrayConstraintsFromSetPurchase_Order_Installment_Line_Data($purchase_Order_Installment_Line_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Installment_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Installment_Line_Data = $purchase_Order_Installment_Line_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Installment_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Installment_Line_DataType $item
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType
     */
    public function addToPurchase_Order_Installment_Line_Data(\StructType\Supplier_Contract_Installment_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Installment_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Installment_Line_Data property can only contain items of type \StructType\Supplier_Contract_Installment_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Installment_Line_Data[] = $item;
        return $this;
    }
}
