<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Acknowledgement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Purchase Order cannot be acknowledged via this web service if any of the following are true: 1) it is not in an Issued status, 2) it contains contingent worker lines, 3) it is canceled, or 4) It contains lines closed for
 * receiving. | Contains purchase order acknowledgement header and line data.
 * @subpackage Structs
 */
class Purchase_Order_Acknowledgement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement_ID
     * Meta information extracted from the WSDL
     * - documentation: Refers to the unique purchase order acknowledgement identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Acknowledgement_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether or not the POA should be submitted to the business process.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Refers to a unique, non-editable purchase order acknowledgement number generated by Workday.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: Document Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to the purchase order for which the POA is created.
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Supplier_Acknowledgement_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Acknowledgement Number. This attribute along with purchase order is used to identify the Acknowledgement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Acknowledgement_Number;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to the Document Status on the Purchase Order Acknowledgement.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The PO_Acknowledgement_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to the Acknowledgement Type Code status in the EDI855 specification for POA.
     * - minOccurs: 0
     * @var \StructType\PO_Acknowledgement_StatusObjectType
     */
    public $PO_Acknowledgement_Type_Reference;
    /**
     * The Origin_Reference
     * Meta information extracted from the WSDL
     * - documentation: References how the Purchase Order Acknowledgement document got created. Possible values for the reference id (Origin_Reference_ID) are 'Web Service' , 'EDI', 'Manual'.
     * - minOccurs: 0
     * @var \StructType\Document_Creation_MethodObjectType
     */
    public $Origin_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Refers to POA document comment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates the Requisition Types for the backing Requisitions
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType[]
     */
    public $Requisition_Type_Reference;
    /**
     * The PO_Acknowledgement_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Refers to purchase order acknowledgement lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PO_Acknowledgement_Line_DataType[]
     */
    public $PO_Acknowledgement_Line_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Purchase_Order_Acknowledgement_DataType
     * @uses Purchase_Order_Acknowledgement_DataType::setPurchase_Order_Acknowledgement_ID()
     * @uses Purchase_Order_Acknowledgement_DataType::setSubmit()
     * @uses Purchase_Order_Acknowledgement_DataType::setDocument_Number()
     * @uses Purchase_Order_Acknowledgement_DataType::setDocument_Date()
     * @uses Purchase_Order_Acknowledgement_DataType::setPurchase_Order_Reference()
     * @uses Purchase_Order_Acknowledgement_DataType::setSupplier_Acknowledgement_Number()
     * @uses Purchase_Order_Acknowledgement_DataType::setDocument_Status_Reference()
     * @uses Purchase_Order_Acknowledgement_DataType::setPO_Acknowledgement_Type_Reference()
     * @uses Purchase_Order_Acknowledgement_DataType::setOrigin_Reference()
     * @uses Purchase_Order_Acknowledgement_DataType::setMemo()
     * @uses Purchase_Order_Acknowledgement_DataType::setRequisition_Type_Reference()
     * @uses Purchase_Order_Acknowledgement_DataType::setPO_Acknowledgement_Line_Data()
     * @uses Purchase_Order_Acknowledgement_DataType::setAttachment_Data()
     * @param string $purchase_Order_Acknowledgement_ID
     * @param bool $submit
     * @param string $document_Number
     * @param string $document_Date
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param string $supplier_Acknowledgement_Number
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Type_Reference
     * @param \StructType\Document_Creation_MethodObjectType $origin_Reference
     * @param string $memo
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @param \StructType\PO_Acknowledgement_Line_DataType[] $pO_Acknowledgement_Line_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct($purchase_Order_Acknowledgement_ID = null, $submit = null, $document_Number = null, $document_Date = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $supplier_Acknowledgement_Number = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Type_Reference = null, \StructType\Document_Creation_MethodObjectType $origin_Reference = null, $memo = null, array $requisition_Type_Reference = array(), array $pO_Acknowledgement_Line_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setPurchase_Order_Acknowledgement_ID($purchase_Order_Acknowledgement_ID)
            ->setSubmit($submit)
            ->setDocument_Number($document_Number)
            ->setDocument_Date($document_Date)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setSupplier_Acknowledgement_Number($supplier_Acknowledgement_Number)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setPO_Acknowledgement_Type_Reference($pO_Acknowledgement_Type_Reference)
            ->setOrigin_Reference($origin_Reference)
            ->setMemo($memo)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setPO_Acknowledgement_Line_Data($pO_Acknowledgement_Line_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Purchase_Order_Acknowledgement_ID value
     * @return string|null
     */
    public function getPurchase_Order_Acknowledgement_ID()
    {
        return $this->Purchase_Order_Acknowledgement_ID;
    }
    /**
     * Set Purchase_Order_Acknowledgement_ID value
     * @param string $purchase_Order_Acknowledgement_ID
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setPurchase_Order_Acknowledgement_ID($purchase_Order_Acknowledgement_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Acknowledgement_ID) && !is_string($purchase_Order_Acknowledgement_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Acknowledgement_ID, true), gettype($purchase_Order_Acknowledgement_ID)), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_ID = $purchase_Order_Acknowledgement_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Supplier_Acknowledgement_Number value
     * @return string|null
     */
    public function getSupplier_Acknowledgement_Number()
    {
        return $this->Supplier_Acknowledgement_Number;
    }
    /**
     * Set Supplier_Acknowledgement_Number value
     * @param string $supplier_Acknowledgement_Number
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setSupplier_Acknowledgement_Number($supplier_Acknowledgement_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Acknowledgement_Number) && !is_string($supplier_Acknowledgement_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Acknowledgement_Number, true), gettype($supplier_Acknowledgement_Number)), __LINE__);
        }
        $this->Supplier_Acknowledgement_Number = $supplier_Acknowledgement_Number;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get PO_Acknowledgement_Type_Reference value
     * @return \StructType\PO_Acknowledgement_StatusObjectType|null
     */
    public function getPO_Acknowledgement_Type_Reference()
    {
        return $this->PO_Acknowledgement_Type_Reference;
    }
    /**
     * Set PO_Acknowledgement_Type_Reference value
     * @param \StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Type_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setPO_Acknowledgement_Type_Reference(\StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Type_Reference = null)
    {
        $this->PO_Acknowledgement_Type_Reference = $pO_Acknowledgement_Type_Reference;
        return $this;
    }
    /**
     * Get Origin_Reference value
     * @return \StructType\Document_Creation_MethodObjectType|null
     */
    public function getOrigin_Reference()
    {
        return $this->Origin_Reference;
    }
    /**
     * Set Origin_Reference value
     * @param \StructType\Document_Creation_MethodObjectType $origin_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setOrigin_Reference(\StructType\Document_Creation_MethodObjectType $origin_Reference = null)
    {
        $this->Origin_Reference = $origin_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType[]|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_DataTypeRequisition_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_DataTypeRequisition_Type_ReferenceItem instanceof \StructType\Requisition_TypeObjectType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_DataTypeRequisition_Type_ReferenceItem) ? get_class($purchase_Order_Acknowledgement_DataTypeRequisition_Type_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_DataTypeRequisition_Type_ReferenceItem), var_export($purchase_Order_Acknowledgement_DataTypeRequisition_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setRequisition_Type_Reference(array $requisition_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Type_ReferenceArrayErrorMessage = self::validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference($requisition_Type_Reference))) {
            throw new \InvalidArgumentException($requisition_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType $item
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function addToRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get PO_Acknowledgement_Line_Data value
     * @return \StructType\PO_Acknowledgement_Line_DataType[]|null
     */
    public function getPO_Acknowledgement_Line_Data()
    {
        return $this->PO_Acknowledgement_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPO_Acknowledgement_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPO_Acknowledgement_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePO_Acknowledgement_Line_DataForArrayConstraintsFromSetPO_Acknowledgement_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_DataTypePO_Acknowledgement_Line_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_DataTypePO_Acknowledgement_Line_DataItem instanceof \StructType\PO_Acknowledgement_Line_DataType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_DataTypePO_Acknowledgement_Line_DataItem) ? get_class($purchase_Order_Acknowledgement_DataTypePO_Acknowledgement_Line_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_DataTypePO_Acknowledgement_Line_DataItem), var_export($purchase_Order_Acknowledgement_DataTypePO_Acknowledgement_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PO_Acknowledgement_Line_Data property can only contain items of type \StructType\PO_Acknowledgement_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PO_Acknowledgement_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\PO_Acknowledgement_Line_DataType[] $pO_Acknowledgement_Line_Data
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setPO_Acknowledgement_Line_Data(array $pO_Acknowledgement_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($pO_Acknowledgement_Line_DataArrayErrorMessage = self::validatePO_Acknowledgement_Line_DataForArrayConstraintsFromSetPO_Acknowledgement_Line_Data($pO_Acknowledgement_Line_Data))) {
            throw new \InvalidArgumentException($pO_Acknowledgement_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->PO_Acknowledgement_Line_Data = $pO_Acknowledgement_Line_Data;
        return $this;
    }
    /**
     * Add item to PO_Acknowledgement_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\PO_Acknowledgement_Line_DataType $item
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function addToPO_Acknowledgement_Line_Data(\StructType\PO_Acknowledgement_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PO_Acknowledgement_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The PO_Acknowledgement_Line_Data property can only contain items of type \StructType\PO_Acknowledgement_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PO_Acknowledgement_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_DataTypeAttachment_DataItem) ? get_class($purchase_Order_Acknowledgement_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_DataTypeAttachment_DataItem), var_export($purchase_Order_Acknowledgement_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
