<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Purchase Item request criteria
 * @subpackage Structs
 */
class Purchase_Item_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: We return all purchase items associated with the supplier you enter. We also return all the information set up for the purchase item, including supplier information for all associated suppliers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: We return all purchase items that have the supplier contract defined as a Preferred Supplier Contract, or an attribute for Advanced Pricing
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Supplier_Contract_Reference;
    /**
     * The Item_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item Group. Assign purchase items to item groups to make it easier to search for and select items. Purchase items can belong to multiple groups.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_GroupObjectType[]
     */
    public $Item_Group_Reference;
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item tags for the Purchase Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType[]
     */
    public $Item_Tag_Reference;
    /**
     * The Return_All_Advanced_Pricing
     * Meta information extracted from the WSDL
     * - documentation: Select Yes to return all advance prices. When you don't select this and you don't enter an effective date, we return advance prices that are effective at the time this web service runs. When you don't select this and you enter an
     * effective date, then we return prices that are active for the effective date entered.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Return_All_Advanced_Pricing;
    /**
     * The Return_Active_Advanced_Pricing
     * Meta information extracted from the WSDL
     * - documentation: Only retrieve Supplier Items considered active (that have active unit of measure pricing information.)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Return_Active_Advanced_Pricing;
    /**
     * The Exclude_Pricing_Calculated_by_Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: Select to exclude pricing that’s calculated based on the conversion factor. When you enable Calculate Price based on Conversion Factor, Workday only returns pricing that is not calculated based on the conversion factor and the also
     * the default price. This enables you to quickly view and edit relevant pricing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Pricing_Calculated_by_Conversion_Factor;
    /**
     * The Item_Updated_From
     * Meta information extracted from the WSDL
     * - documentation: Select a date to return purchase items edited after this time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Updated_From;
    /**
     * The Item_Updated_To
     * Meta information extracted from the WSDL
     * - documentation: Select a date to return purchase items edited before this time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Updated_To;
    /**
     * The Item_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Select one or more purchase item statuses to return purchase items with the specified statuses.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Item_StatusObjectType[]
     */
    public $Item_Status_Reference;
    /**
     * Constructor method for Purchase_Item_Request_CriteriaType
     * @uses Purchase_Item_Request_CriteriaType::setSupplier_Reference()
     * @uses Purchase_Item_Request_CriteriaType::setSupplier_Contract_Reference()
     * @uses Purchase_Item_Request_CriteriaType::setItem_Group_Reference()
     * @uses Purchase_Item_Request_CriteriaType::setItem_Tag_Reference()
     * @uses Purchase_Item_Request_CriteriaType::setReturn_All_Advanced_Pricing()
     * @uses Purchase_Item_Request_CriteriaType::setReturn_Active_Advanced_Pricing()
     * @uses Purchase_Item_Request_CriteriaType::setExclude_Pricing_Calculated_by_Conversion_Factor()
     * @uses Purchase_Item_Request_CriteriaType::setItem_Updated_From()
     * @uses Purchase_Item_Request_CriteriaType::setItem_Updated_To()
     * @uses Purchase_Item_Request_CriteriaType::setItem_Status_Reference()
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @param \StructType\Purchase_Item_GroupObjectType[] $item_Group_Reference
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @param bool $return_All_Advanced_Pricing
     * @param bool $return_Active_Advanced_Pricing
     * @param bool $exclude_Pricing_Calculated_by_Conversion_Factor
     * @param string $item_Updated_From
     * @param string $item_Updated_To
     * @param \StructType\Spend_Item_StatusObjectType[] $item_Status_Reference
     */
    public function __construct(array $supplier_Reference = array(), array $supplier_Contract_Reference = array(), array $item_Group_Reference = array(), array $item_Tag_Reference = array(), $return_All_Advanced_Pricing = null, $return_Active_Advanced_Pricing = null, $exclude_Pricing_Calculated_by_Conversion_Factor = null, $item_Updated_From = null, $item_Updated_To = null, array $item_Status_Reference = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setItem_Group_Reference($item_Group_Reference)
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setReturn_All_Advanced_Pricing($return_All_Advanced_Pricing)
            ->setReturn_Active_Advanced_Pricing($return_Active_Advanced_Pricing)
            ->setExclude_Pricing_Calculated_by_Conversion_Factor($exclude_Pricing_Calculated_by_Conversion_Factor)
            ->setItem_Updated_From($item_Updated_From)
            ->setItem_Updated_To($item_Updated_To)
            ->setItem_Status_Reference($item_Status_Reference);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($purchase_Item_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_CriteriaTypeSupplier_ReferenceItem), var_export($purchase_Item_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem) ? get_class($purchase_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem), var_export($purchase_Item_Request_CriteriaTypeSupplier_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setSupplier_Contract_Reference(array $supplier_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_ReferenceArrayErrorMessage = self::validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference($supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function addToSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_Group_Reference value
     * @return \StructType\Purchase_Item_GroupObjectType[]|null
     */
    public function getItem_Group_Reference()
    {
        return $this->Item_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Group_ReferenceForArrayConstraintsFromSetItem_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_CriteriaTypeItem_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_CriteriaTypeItem_Group_ReferenceItem instanceof \StructType\Purchase_Item_GroupObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_CriteriaTypeItem_Group_ReferenceItem) ? get_class($purchase_Item_Request_CriteriaTypeItem_Group_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_CriteriaTypeItem_Group_ReferenceItem), var_export($purchase_Item_Request_CriteriaTypeItem_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Group_Reference property can only contain items of type \StructType\Purchase_Item_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_GroupObjectType[] $item_Group_Reference
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setItem_Group_Reference(array $item_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Group_ReferenceArrayErrorMessage = self::validateItem_Group_ReferenceForArrayConstraintsFromSetItem_Group_Reference($item_Group_Reference))) {
            throw new \InvalidArgumentException($item_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Group_Reference = $item_Group_Reference;
        return $this;
    }
    /**
     * Add item to Item_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_GroupObjectType $item
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function addToItem_Group_Reference(\StructType\Purchase_Item_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Group_Reference property can only contain items of type \StructType\Purchase_Item_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType[]|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_CriteriaTypeItem_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_CriteriaTypeItem_Tag_ReferenceItem instanceof \StructType\Item_TagObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_CriteriaTypeItem_Tag_ReferenceItem) ? get_class($purchase_Item_Request_CriteriaTypeItem_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_CriteriaTypeItem_Tag_ReferenceItem), var_export($purchase_Item_Request_CriteriaTypeItem_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setItem_Tag_Reference(array $item_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_ReferenceArrayErrorMessage = self::validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference($item_Tag_Reference))) {
            throw new \InvalidArgumentException($item_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType $item
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function addToItem_Tag_Reference(\StructType\Item_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Return_All_Advanced_Pricing value
     * @return bool|null
     */
    public function getReturn_All_Advanced_Pricing()
    {
        return $this->Return_All_Advanced_Pricing;
    }
    /**
     * Set Return_All_Advanced_Pricing value
     * @param bool $return_All_Advanced_Pricing
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setReturn_All_Advanced_Pricing($return_All_Advanced_Pricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($return_All_Advanced_Pricing) && !is_bool($return_All_Advanced_Pricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($return_All_Advanced_Pricing, true), gettype($return_All_Advanced_Pricing)), __LINE__);
        }
        $this->Return_All_Advanced_Pricing = $return_All_Advanced_Pricing;
        return $this;
    }
    /**
     * Get Return_Active_Advanced_Pricing value
     * @return bool|null
     */
    public function getReturn_Active_Advanced_Pricing()
    {
        return $this->Return_Active_Advanced_Pricing;
    }
    /**
     * Set Return_Active_Advanced_Pricing value
     * @param bool $return_Active_Advanced_Pricing
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setReturn_Active_Advanced_Pricing($return_Active_Advanced_Pricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($return_Active_Advanced_Pricing) && !is_bool($return_Active_Advanced_Pricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($return_Active_Advanced_Pricing, true), gettype($return_Active_Advanced_Pricing)), __LINE__);
        }
        $this->Return_Active_Advanced_Pricing = $return_Active_Advanced_Pricing;
        return $this;
    }
    /**
     * Get Exclude_Pricing_Calculated_by_Conversion_Factor value
     * @return bool|null
     */
    public function getExclude_Pricing_Calculated_by_Conversion_Factor()
    {
        return $this->Exclude_Pricing_Calculated_by_Conversion_Factor;
    }
    /**
     * Set Exclude_Pricing_Calculated_by_Conversion_Factor value
     * @param bool $exclude_Pricing_Calculated_by_Conversion_Factor
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setExclude_Pricing_Calculated_by_Conversion_Factor($exclude_Pricing_Calculated_by_Conversion_Factor = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Pricing_Calculated_by_Conversion_Factor) && !is_bool($exclude_Pricing_Calculated_by_Conversion_Factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Pricing_Calculated_by_Conversion_Factor, true), gettype($exclude_Pricing_Calculated_by_Conversion_Factor)), __LINE__);
        }
        $this->Exclude_Pricing_Calculated_by_Conversion_Factor = $exclude_Pricing_Calculated_by_Conversion_Factor;
        return $this;
    }
    /**
     * Get Item_Updated_From value
     * @return string|null
     */
    public function getItem_Updated_From()
    {
        return $this->Item_Updated_From;
    }
    /**
     * Set Item_Updated_From value
     * @param string $item_Updated_From
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setItem_Updated_From($item_Updated_From = null)
    {
        // validation for constraint: string
        if (!is_null($item_Updated_From) && !is_string($item_Updated_From)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Updated_From, true), gettype($item_Updated_From)), __LINE__);
        }
        $this->Item_Updated_From = $item_Updated_From;
        return $this;
    }
    /**
     * Get Item_Updated_To value
     * @return string|null
     */
    public function getItem_Updated_To()
    {
        return $this->Item_Updated_To;
    }
    /**
     * Set Item_Updated_To value
     * @param string $item_Updated_To
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setItem_Updated_To($item_Updated_To = null)
    {
        // validation for constraint: string
        if (!is_null($item_Updated_To) && !is_string($item_Updated_To)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Updated_To, true), gettype($item_Updated_To)), __LINE__);
        }
        $this->Item_Updated_To = $item_Updated_To;
        return $this;
    }
    /**
     * Get Item_Status_Reference value
     * @return \StructType\Spend_Item_StatusObjectType[]|null
     */
    public function getItem_Status_Reference()
    {
        return $this->Item_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Status_ReferenceForArrayConstraintsFromSetItem_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_CriteriaTypeItem_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_CriteriaTypeItem_Status_ReferenceItem instanceof \StructType\Spend_Item_StatusObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_CriteriaTypeItem_Status_ReferenceItem) ? get_class($purchase_Item_Request_CriteriaTypeItem_Status_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_CriteriaTypeItem_Status_ReferenceItem), var_export($purchase_Item_Request_CriteriaTypeItem_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Status_Reference property can only contain items of type \StructType\Spend_Item_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Item_StatusObjectType[] $item_Status_Reference
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function setItem_Status_Reference(array $item_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Status_ReferenceArrayErrorMessage = self::validateItem_Status_ReferenceForArrayConstraintsFromSetItem_Status_Reference($item_Status_Reference))) {
            throw new \InvalidArgumentException($item_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Status_Reference = $item_Status_Reference;
        return $this;
    }
    /**
     * Add item to Item_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Item_StatusObjectType $item
     * @return \StructType\Purchase_Item_Request_CriteriaType
     */
    public function addToItem_Status_Reference(\StructType\Spend_Item_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Item_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Status_Reference property can only contain items of type \StructType\Spend_Item_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Status_Reference[] = $item;
        return $this;
    }
}
