<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_Snapshot_DetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Standard Cost Rate Sheet Snapshot Details
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_Snapshot_DetailsType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * - maxOccurs: unbounded
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date
     * - maxOccurs: 1
     * @var string
     */
    public $Effective_Date;
    /**
     * The Default_Hourly_Rate
     * Meta information extracted from the WSDL
     * - documentation: Hourly rate for the project role.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Default_Hourly_Rate;
    /**
     * The XMLNAME_1st_Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: 1st Priority for Project Standard Cost Rate Sheet
     * @var \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType
     */
    public $XMLNAME_1st_Priority_Reference;
    /**
     * The XMLNAME_2nd_Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: 2nd Priority for Project Standard Cost Rate Sheet
     * - minOccurs: 0
     * @var \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType
     */
    public $XMLNAME_2nd_Priority_Reference;
    /**
     * The XMLNAME_3rd_Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: 3rd Priority for Project Standard Cost Rate Sheet
     * - minOccurs: 0
     * @var \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType
     */
    public $XMLNAME_3rd_Priority_Reference;
    /**
     * The Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Cost Rate Rule Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType[]
     */
    public $Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data;
    /**
     * The Project_Worker_Rate_Standard_Cost_Rate_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Worker rates
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType[]
     */
    public $Project_Worker_Rate_Standard_Cost_Rate_Detail_Data;
    /**
     * The Project_Role_Standard_Cost_Rate_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Role rates
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Role_Standard_Cost_Rate_DetailsType[]
     */
    public $Project_Role_Standard_Cost_Rate_Detail_Data;
    /**
     * Constructor method for Project_Standard_Cost_Rate_Snapshot_DetailsType
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setCompany_Reference()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setEffective_Date()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setDefault_Hourly_Rate()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setXMLNAME_1st_Priority_Reference()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setXMLNAME_2nd_Priority_Reference()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setXMLNAME_3rd_Priority_Reference()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setProject_Worker_Rate_Standard_Cost_Rate_Detail_Data()
     * @uses Project_Standard_Cost_Rate_Snapshot_DetailsType::setProject_Role_Standard_Cost_Rate_Detail_Data()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param string $effective_Date
     * @param float $default_Hourly_Rate
     * @param \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_1st_Priority_Reference
     * @param \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_2nd_Priority_Reference
     * @param \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_3rd_Priority_Reference
     * @param \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType[] $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data
     * @param \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType[] $project_Worker_Rate_Standard_Cost_Rate_Detail_Data
     * @param \StructType\Project_Role_Standard_Cost_Rate_DetailsType[] $project_Role_Standard_Cost_Rate_Detail_Data
     */
    public function __construct(array $company_Reference = array(), $effective_Date = null, $default_Hourly_Rate = null, \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_1st_Priority_Reference = null, \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_2nd_Priority_Reference = null, \StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_3rd_Priority_Reference = null, array $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data = array(), array $project_Worker_Rate_Standard_Cost_Rate_Detail_Data = array(), array $project_Role_Standard_Cost_Rate_Detail_Data = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setEffective_Date($effective_Date)
            ->setDefault_Hourly_Rate($default_Hourly_Rate)
            ->setXMLNAME_1st_Priority_Reference($xMLNAME_1st_Priority_Reference)
            ->setXMLNAME_2nd_Priority_Reference($xMLNAME_2nd_Priority_Reference)
            ->setXMLNAME_3rd_Priority_Reference($xMLNAME_3rd_Priority_Reference)
            ->setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data)
            ->setProject_Worker_Rate_Standard_Cost_Rate_Detail_Data($project_Worker_Rate_Standard_Cost_Rate_Detail_Data)
            ->setProject_Role_Standard_Cost_Rate_Detail_Data($project_Role_Standard_Cost_Rate_Detail_Data);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Snapshot_DetailsTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Snapshot_DetailsTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Snapshot_DetailsTypeCompany_ReferenceItem) ? get_class($project_Standard_Cost_Rate_Snapshot_DetailsTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Snapshot_DetailsTypeCompany_ReferenceItem), var_export($project_Standard_Cost_Rate_Snapshot_DetailsTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Default_Hourly_Rate value
     * @return float|null
     */
    public function getDefault_Hourly_Rate()
    {
        return $this->Default_Hourly_Rate;
    }
    /**
     * Set Default_Hourly_Rate value
     * @param float $default_Hourly_Rate
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setDefault_Hourly_Rate($default_Hourly_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($default_Hourly_Rate) && !(is_float($default_Hourly_Rate) || is_numeric($default_Hourly_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Hourly_Rate, true), gettype($default_Hourly_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($default_Hourly_Rate) && mb_strlen(mb_substr($default_Hourly_Rate, false !== mb_strpos($default_Hourly_Rate, '.') ? mb_strpos($default_Hourly_Rate, '.') + 1 : mb_strlen($default_Hourly_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($default_Hourly_Rate, true), mb_strlen(mb_substr($default_Hourly_Rate, mb_strpos($default_Hourly_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($default_Hourly_Rate) && $default_Hourly_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($default_Hourly_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($default_Hourly_Rate) && mb_strlen(preg_replace('/(\D)/', '', $default_Hourly_Rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($default_Hourly_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $default_Hourly_Rate))), __LINE__);
        }
        $this->Default_Hourly_Rate = $default_Hourly_Rate;
        return $this;
    }
    /**
     * Get xMLNAMEst_Priority_Reference value
     * @return xMLNAMEst_Priority_Reference
     */
    public function getXMLNAME_1st_Priority_Reference()
    {
        return $this->XMLNAME_1st_Priority_Reference;
    }
    /**
     * Set xMLNAMEst_Priority_Reference value
     * @param xMLNAMEst_Priority_Reference $xMLNAMEst_Priority_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setXMLNAME_1st_Priority_Reference(\StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_1st_Priority_Reference = null)
    {
        $this->XMLNAME_1st_Priority_Reference = $xMLNAME_1st_Priority_Reference;
        return $this;
    }
    /**
     * Get xMLNAMEnd_Priority_Reference value
     * @return xMLNAMEnd_Priority_Reference
     */
    public function getXMLNAME_2nd_Priority_Reference()
    {
        return $this->XMLNAME_2nd_Priority_Reference;
    }
    /**
     * Set xMLNAMEnd_Priority_Reference value
     * @param xMLNAMEnd_Priority_Reference $xMLNAMEnd_Priority_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setXMLNAME_2nd_Priority_Reference(\StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_2nd_Priority_Reference = null)
    {
        $this->XMLNAME_2nd_Priority_Reference = $xMLNAME_2nd_Priority_Reference;
        return $this;
    }
    /**
     * Get xMLNAMErd_Priority_Reference value
     * @return xMLNAMErd_Priority_Reference
     */
    public function getXMLNAME_3rd_Priority_Reference()
    {
        return $this->XMLNAME_3rd_Priority_Reference;
    }
    /**
     * Set xMLNAMErd_Priority_Reference value
     * @param xMLNAMErd_Priority_Reference $xMLNAMErd_Priority_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setXMLNAME_3rd_Priority_Reference(\StructType\Project_Worker_Rate_Standard_Cost_Rate_PriorityObjectType $xMLNAME_3rd_Priority_Reference = null)
    {
        $this->XMLNAME_3rd_Priority_Reference = $xMLNAME_3rd_Priority_Reference;
        return $this;
    }
    /**
     * Get Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data value
     * @return \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType[]|null
     */
    public function getProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data()
    {
        return $this->Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataForArrayConstraintsFromSetProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataItem instanceof \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataItem) ? get_class($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataItem), var_export($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data property can only contain items of type \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType[] $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data(array $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataArrayErrorMessage = self::validateProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataForArrayConstraintsFromSetProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data))) {
            throw new \InvalidArgumentException($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data = $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data;
        return $this;
    }
    /**
     * Add item to Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType $item
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function addToProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data(\StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType) {
            throw new \InvalidArgumentException(sprintf('The Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data property can only contain items of type \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_Data[] = $item;
        return $this;
    }
    /**
     * Get Project_Worker_Rate_Standard_Cost_Rate_Detail_Data value
     * @return \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType[]|null
     */
    public function getProject_Worker_Rate_Standard_Cost_Rate_Detail_Data()
    {
        return $this->Project_Worker_Rate_Standard_Cost_Rate_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Worker_Rate_Standard_Cost_Rate_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Worker_Rate_Standard_Cost_Rate_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Worker_Rate_Standard_Cost_Rate_Detail_DataForArrayConstraintsFromSetProject_Worker_Rate_Standard_Cost_Rate_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Worker_Rate_Standard_Cost_Rate_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Worker_Rate_Standard_Cost_Rate_Detail_DataItem instanceof \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Worker_Rate_Standard_Cost_Rate_Detail_DataItem) ? get_class($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Worker_Rate_Standard_Cost_Rate_Detail_DataItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Worker_Rate_Standard_Cost_Rate_Detail_DataItem), var_export($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Worker_Rate_Standard_Cost_Rate_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Worker_Rate_Standard_Cost_Rate_Detail_Data property can only contain items of type \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Worker_Rate_Standard_Cost_Rate_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType[] $project_Worker_Rate_Standard_Cost_Rate_Detail_Data
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setProject_Worker_Rate_Standard_Cost_Rate_Detail_Data(array $project_Worker_Rate_Standard_Cost_Rate_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Worker_Rate_Standard_Cost_Rate_Detail_DataArrayErrorMessage = self::validateProject_Worker_Rate_Standard_Cost_Rate_Detail_DataForArrayConstraintsFromSetProject_Worker_Rate_Standard_Cost_Rate_Detail_Data($project_Worker_Rate_Standard_Cost_Rate_Detail_Data))) {
            throw new \InvalidArgumentException($project_Worker_Rate_Standard_Cost_Rate_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Worker_Rate_Standard_Cost_Rate_Detail_Data = $project_Worker_Rate_Standard_Cost_Rate_Detail_Data;
        return $this;
    }
    /**
     * Add item to Project_Worker_Rate_Standard_Cost_Rate_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType $item
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function addToProject_Worker_Rate_Standard_Cost_Rate_Detail_Data(\StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType) {
            throw new \InvalidArgumentException(sprintf('The Project_Worker_Rate_Standard_Cost_Rate_Detail_Data property can only contain items of type \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Worker_Rate_Standard_Cost_Rate_Detail_Data[] = $item;
        return $this;
    }
    /**
     * Get Project_Role_Standard_Cost_Rate_Detail_Data value
     * @return \StructType\Project_Role_Standard_Cost_Rate_DetailsType[]|null
     */
    public function getProject_Role_Standard_Cost_Rate_Detail_Data()
    {
        return $this->Project_Role_Standard_Cost_Rate_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Role_Standard_Cost_Rate_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Role_Standard_Cost_Rate_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Role_Standard_Cost_Rate_Detail_DataForArrayConstraintsFromSetProject_Role_Standard_Cost_Rate_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Role_Standard_Cost_Rate_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Role_Standard_Cost_Rate_Detail_DataItem instanceof \StructType\Project_Role_Standard_Cost_Rate_DetailsType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Role_Standard_Cost_Rate_Detail_DataItem) ? get_class($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Role_Standard_Cost_Rate_Detail_DataItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Role_Standard_Cost_Rate_Detail_DataItem), var_export($project_Standard_Cost_Rate_Snapshot_DetailsTypeProject_Role_Standard_Cost_Rate_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Role_Standard_Cost_Rate_Detail_Data property can only contain items of type \StructType\Project_Role_Standard_Cost_Rate_DetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Role_Standard_Cost_Rate_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Role_Standard_Cost_Rate_DetailsType[] $project_Role_Standard_Cost_Rate_Detail_Data
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function setProject_Role_Standard_Cost_Rate_Detail_Data(array $project_Role_Standard_Cost_Rate_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Role_Standard_Cost_Rate_Detail_DataArrayErrorMessage = self::validateProject_Role_Standard_Cost_Rate_Detail_DataForArrayConstraintsFromSetProject_Role_Standard_Cost_Rate_Detail_Data($project_Role_Standard_Cost_Rate_Detail_Data))) {
            throw new \InvalidArgumentException($project_Role_Standard_Cost_Rate_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Role_Standard_Cost_Rate_Detail_Data = $project_Role_Standard_Cost_Rate_Detail_Data;
        return $this;
    }
    /**
     * Add item to Project_Role_Standard_Cost_Rate_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Role_Standard_Cost_Rate_DetailsType $item
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType
     */
    public function addToProject_Role_Standard_Cost_Rate_Detail_Data(\StructType\Project_Role_Standard_Cost_Rate_DetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Role_Standard_Cost_Rate_DetailsType) {
            throw new \InvalidArgumentException(sprintf('The Project_Role_Standard_Cost_Rate_Detail_Data property can only contain items of type \StructType\Project_Role_Standard_Cost_Rate_DetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Role_Standard_Cost_Rate_Detail_Data[] = $item;
        return $this;
    }
}
