<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_TemplateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all project plan template references and data.
 * @subpackage Structs
 */
class Project_Plan_TemplateType extends AbstractStructBase
{
    /**
     * The Project_Plan_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The instance of a project plan template.
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TemplateObjectType
     */
    public $Project_Plan_Template_Reference;
    /**
     * The Project_Plan_Template_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the detailed information about a project plan template.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Template_DataType[]
     */
    public $Project_Plan_Template_Data;
    /**
     * Constructor method for Project_Plan_TemplateType
     * @uses Project_Plan_TemplateType::setProject_Plan_Template_Reference()
     * @uses Project_Plan_TemplateType::setProject_Plan_Template_Data()
     * @param \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference
     * @param \StructType\Project_Plan_Template_DataType[] $project_Plan_Template_Data
     */
    public function __construct(\StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference = null, array $project_Plan_Template_Data = array())
    {
        $this
            ->setProject_Plan_Template_Reference($project_Plan_Template_Reference)
            ->setProject_Plan_Template_Data($project_Plan_Template_Data);
    }
    /**
     * Get Project_Plan_Template_Reference value
     * @return \StructType\Project_Plan_TemplateObjectType|null
     */
    public function getProject_Plan_Template_Reference()
    {
        return $this->Project_Plan_Template_Reference;
    }
    /**
     * Set Project_Plan_Template_Reference value
     * @param \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference
     * @return \StructType\Project_Plan_TemplateType
     */
    public function setProject_Plan_Template_Reference(\StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference = null)
    {
        $this->Project_Plan_Template_Reference = $project_Plan_Template_Reference;
        return $this;
    }
    /**
     * Get Project_Plan_Template_Data value
     * @return \StructType\Project_Plan_Template_DataType[]|null
     */
    public function getProject_Plan_Template_Data()
    {
        return $this->Project_Plan_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Plan_Template_DataForArrayConstraintsFromSetProject_Plan_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_TemplateTypeProject_Plan_Template_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_TemplateTypeProject_Plan_Template_DataItem instanceof \StructType\Project_Plan_Template_DataType) {
                $invalidValues[] = is_object($project_Plan_TemplateTypeProject_Plan_Template_DataItem) ? get_class($project_Plan_TemplateTypeProject_Plan_Template_DataItem) : sprintf('%s(%s)', gettype($project_Plan_TemplateTypeProject_Plan_Template_DataItem), var_export($project_Plan_TemplateTypeProject_Plan_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan_Template_Data property can only contain items of type \StructType\Project_Plan_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Template_DataType[] $project_Plan_Template_Data
     * @return \StructType\Project_Plan_TemplateType
     */
    public function setProject_Plan_Template_Data(array $project_Plan_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Plan_Template_DataArrayErrorMessage = self::validateProject_Plan_Template_DataForArrayConstraintsFromSetProject_Plan_Template_Data($project_Plan_Template_Data))) {
            throw new \InvalidArgumentException($project_Plan_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan_Template_Data = $project_Plan_Template_Data;
        return $this;
    }
    /**
     * Add item to Project_Plan_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Template_DataType $item
     * @return \StructType\Project_Plan_TemplateType
     */
    public function addToProject_Plan_Template_Data(\StructType\Project_Plan_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan_Template_Data property can only contain items of type \StructType\Project_Plan_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan_Template_Data[] = $item;
        return $this;
    }
}
