<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Task_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Plan Task must be a Project Plan Task of the selected Project Plan Phase. | Element Containing Project Plan Task Data. A Project-Based Requisition Line may have multiple project subtasks of multiple project plan tasks.
 * @subpackage Structs
 */
class Project_Plan_Task_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan_Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Plan Task.
     * @var \StructType\Project_Plan_TaskObjectType
     */
    public $Project_Plan_Task_Reference;
    /**
     * The Project_Subtask_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Project Subtask data. A Project-Based Requisition Line may have multiple project subtasks.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Subtask_DataType[]
     */
    public $Project_Subtask_Data;
    /**
     * Constructor method for Project_Plan_Task_Requisition_DataType
     * @uses Project_Plan_Task_Requisition_DataType::setProject_Plan_Task_Reference()
     * @uses Project_Plan_Task_Requisition_DataType::setProject_Subtask_Data()
     * @param \StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference
     * @param \StructType\Project_Subtask_DataType[] $project_Subtask_Data
     */
    public function __construct(\StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference = null, array $project_Subtask_Data = array())
    {
        $this
            ->setProject_Plan_Task_Reference($project_Plan_Task_Reference)
            ->setProject_Subtask_Data($project_Subtask_Data);
    }
    /**
     * Get Project_Plan_Task_Reference value
     * @return \StructType\Project_Plan_TaskObjectType|null
     */
    public function getProject_Plan_Task_Reference()
    {
        return $this->Project_Plan_Task_Reference;
    }
    /**
     * Set Project_Plan_Task_Reference value
     * @param \StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference
     * @return \StructType\Project_Plan_Task_Requisition_DataType
     */
    public function setProject_Plan_Task_Reference(\StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference = null)
    {
        $this->Project_Plan_Task_Reference = $project_Plan_Task_Reference;
        return $this;
    }
    /**
     * Get Project_Subtask_Data value
     * @return \StructType\Project_Subtask_DataType[]|null
     */
    public function getProject_Subtask_Data()
    {
        return $this->Project_Subtask_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Subtask_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Subtask_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Subtask_DataForArrayConstraintsFromSetProject_Subtask_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Task_Requisition_DataTypeProject_Subtask_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Task_Requisition_DataTypeProject_Subtask_DataItem instanceof \StructType\Project_Subtask_DataType) {
                $invalidValues[] = is_object($project_Plan_Task_Requisition_DataTypeProject_Subtask_DataItem) ? get_class($project_Plan_Task_Requisition_DataTypeProject_Subtask_DataItem) : sprintf('%s(%s)', gettype($project_Plan_Task_Requisition_DataTypeProject_Subtask_DataItem), var_export($project_Plan_Task_Requisition_DataTypeProject_Subtask_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Subtask_Data property can only contain items of type \StructType\Project_Subtask_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Subtask_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Subtask_DataType[] $project_Subtask_Data
     * @return \StructType\Project_Plan_Task_Requisition_DataType
     */
    public function setProject_Subtask_Data(array $project_Subtask_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Subtask_DataArrayErrorMessage = self::validateProject_Subtask_DataForArrayConstraintsFromSetProject_Subtask_Data($project_Subtask_Data))) {
            throw new \InvalidArgumentException($project_Subtask_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Subtask_Data = $project_Subtask_Data;
        return $this;
    }
    /**
     * Add item to Project_Subtask_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Subtask_DataType $item
     * @return \StructType\Project_Plan_Task_Requisition_DataType
     */
    public function addToProject_Subtask_Data(\StructType\Project_Subtask_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Subtask_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Subtask_Data property can only contain items of type \StructType\Project_Subtask_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Subtask_Data[] = $item;
        return $this;
    }
}
