<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Phase_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request References element contains the specific instance set that should be returned in the Get operation. Either a Reference ID or the Workday ID (GUID) should be specified for each instance to be returned.
 * @subpackage Structs
 */
class Project_Phase_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Project_Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Phase Reference
     * - maxOccurs: unbounded
     * @var \StructType\Project_PhaseObjectType[]
     */
    public $Project_Phase_Reference;
    /**
     * Constructor method for Project_Phase_Request_ReferencesType
     * @uses Project_Phase_Request_ReferencesType::setProject_Phase_Reference()
     * @param \StructType\Project_PhaseObjectType[] $project_Phase_Reference
     */
    public function __construct(array $project_Phase_Reference = array())
    {
        $this
            ->setProject_Phase_Reference($project_Phase_Reference);
    }
    /**
     * Get Project_Phase_Reference value
     * @return \StructType\Project_PhaseObjectType[]|null
     */
    public function getProject_Phase_Reference()
    {
        return $this->Project_Phase_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Phase_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Phase_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Phase_ReferenceForArrayConstraintsFromSetProject_Phase_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Phase_Request_ReferencesTypeProject_Phase_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Phase_Request_ReferencesTypeProject_Phase_ReferenceItem instanceof \StructType\Project_PhaseObjectType) {
                $invalidValues[] = is_object($project_Phase_Request_ReferencesTypeProject_Phase_ReferenceItem) ? get_class($project_Phase_Request_ReferencesTypeProject_Phase_ReferenceItem) : sprintf('%s(%s)', gettype($project_Phase_Request_ReferencesTypeProject_Phase_ReferenceItem), var_export($project_Phase_Request_ReferencesTypeProject_Phase_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Phase_Reference property can only contain items of type \StructType\Project_PhaseObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Phase_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_PhaseObjectType[] $project_Phase_Reference
     * @return \StructType\Project_Phase_Request_ReferencesType
     */
    public function setProject_Phase_Reference(array $project_Phase_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Phase_ReferenceArrayErrorMessage = self::validateProject_Phase_ReferenceForArrayConstraintsFromSetProject_Phase_Reference($project_Phase_Reference))) {
            throw new \InvalidArgumentException($project_Phase_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Phase_Reference = $project_Phase_Reference;
        return $this;
    }
    /**
     * Add item to Project_Phase_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_PhaseObjectType $item
     * @return \StructType\Project_Phase_Request_ReferencesType
     */
    public function addToProject_Phase_Reference(\StructType\Project_PhaseObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_PhaseObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Phase_Reference property can only contain items of type \StructType\Project_PhaseObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Phase_Reference[] = $item;
        return $this;
    }
}
