<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Mass_Close_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains criteria to find Procurement Mass Close requests.
 * @subpackage Structs
 */
class Procurement_Mass_Close_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_or_Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company or Company Hierarchy
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType
     */
    public $Company_or_Company_Hierarchy_Reference;
    /**
     * The Procurement_Document_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Document Type
     * - minOccurs: 0
     * @var \StructType\Procurement_Document_TypeObjectType
     */
    public $Procurement_Document_Type_Reference;
    /**
     * The Creation_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Creation Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Creation_Date_On_or_After;
    /**
     * The Creation_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Creation Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Creation_Date_On_or_Before;
    /**
     * Constructor method for Procurement_Mass_Close_Request_CriteriaType
     * @uses Procurement_Mass_Close_Request_CriteriaType::setCompany_or_Company_Hierarchy_Reference()
     * @uses Procurement_Mass_Close_Request_CriteriaType::setProcurement_Document_Type_Reference()
     * @uses Procurement_Mass_Close_Request_CriteriaType::setCreation_Date_On_or_After()
     * @uses Procurement_Mass_Close_Request_CriteriaType::setCreation_Date_On_or_Before()
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference
     * @param \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference
     * @param string $creation_Date_On_or_After
     * @param string $creation_Date_On_or_Before
     */
    public function __construct(\StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference = null, \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference = null, $creation_Date_On_or_After = null, $creation_Date_On_or_Before = null)
    {
        $this
            ->setCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference)
            ->setProcurement_Document_Type_Reference($procurement_Document_Type_Reference)
            ->setCreation_Date_On_or_After($creation_Date_On_or_After)
            ->setCreation_Date_On_or_Before($creation_Date_On_or_Before);
    }
    /**
     * Get Company_or_Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_or_Company_Hierarchy_Reference()
    {
        return $this->Company_or_Company_Hierarchy_Reference;
    }
    /**
     * Set Company_or_Company_Hierarchy_Reference value
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference
     * @return \StructType\Procurement_Mass_Close_Request_CriteriaType
     */
    public function setCompany_or_Company_Hierarchy_Reference(\StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference = null)
    {
        $this->Company_or_Company_Hierarchy_Reference = $company_or_Company_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Procurement_Document_Type_Reference value
     * @return \StructType\Procurement_Document_TypeObjectType|null
     */
    public function getProcurement_Document_Type_Reference()
    {
        return $this->Procurement_Document_Type_Reference;
    }
    /**
     * Set Procurement_Document_Type_Reference value
     * @param \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference
     * @return \StructType\Procurement_Mass_Close_Request_CriteriaType
     */
    public function setProcurement_Document_Type_Reference(\StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference = null)
    {
        $this->Procurement_Document_Type_Reference = $procurement_Document_Type_Reference;
        return $this;
    }
    /**
     * Get Creation_Date_On_or_After value
     * @return string|null
     */
    public function getCreation_Date_On_or_After()
    {
        return $this->Creation_Date_On_or_After;
    }
    /**
     * Set Creation_Date_On_or_After value
     * @param string $creation_Date_On_or_After
     * @return \StructType\Procurement_Mass_Close_Request_CriteriaType
     */
    public function setCreation_Date_On_or_After($creation_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($creation_Date_On_or_After) && !is_string($creation_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creation_Date_On_or_After, true), gettype($creation_Date_On_or_After)), __LINE__);
        }
        $this->Creation_Date_On_or_After = $creation_Date_On_or_After;
        return $this;
    }
    /**
     * Get Creation_Date_On_or_Before value
     * @return string|null
     */
    public function getCreation_Date_On_or_Before()
    {
        return $this->Creation_Date_On_or_Before;
    }
    /**
     * Set Creation_Date_On_or_Before value
     * @param string $creation_Date_On_or_Before
     * @return \StructType\Procurement_Mass_Close_Request_CriteriaType
     */
    public function setCreation_Date_On_or_Before($creation_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($creation_Date_On_or_Before) && !is_string($creation_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creation_Date_On_or_Before, true), gettype($creation_Date_On_or_Before)), __LINE__);
        }
        $this->Creation_Date_On_or_Before = $creation_Date_On_or_Before;
        return $this;
    }
}
