<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Condition_Rule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for Procurement Condition Rule.
 * @subpackage Structs
 */
class Procurement_Condition_Rule_DataType extends AbstractStructBase
{
    /**
     * The Label_for_the_Procurement_Conditional_Rule_Context
     * Meta information extracted from the WSDL
     * - documentation: Label for Class of this Instance
     * @var string
     */
    public $Label_for_the_Procurement_Conditional_Rule_Context;
    /**
     * The Condition_Rule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Condition_Rule_Data_WWSType[]
     */
    public $Condition_Rule_Data;
    /**
     * Constructor method for Procurement_Condition_Rule_DataType
     * @uses Procurement_Condition_Rule_DataType::setLabel_for_the_Procurement_Conditional_Rule_Context()
     * @uses Procurement_Condition_Rule_DataType::setCondition_Rule_Data()
     * @param string $label_for_the_Procurement_Conditional_Rule_Context
     * @param \StructType\Condition_Rule_Data_WWSType[] $condition_Rule_Data
     */
    public function __construct($label_for_the_Procurement_Conditional_Rule_Context = null, array $condition_Rule_Data = array())
    {
        $this
            ->setLabel_for_the_Procurement_Conditional_Rule_Context($label_for_the_Procurement_Conditional_Rule_Context)
            ->setCondition_Rule_Data($condition_Rule_Data);
    }
    /**
     * Get Label_for_the_Procurement_Conditional_Rule_Context value
     * @return string|null
     */
    public function getLabel_for_the_Procurement_Conditional_Rule_Context()
    {
        return $this->Label_for_the_Procurement_Conditional_Rule_Context;
    }
    /**
     * Set Label_for_the_Procurement_Conditional_Rule_Context value
     * @param string $label_for_the_Procurement_Conditional_Rule_Context
     * @return \StructType\Procurement_Condition_Rule_DataType
     */
    public function setLabel_for_the_Procurement_Conditional_Rule_Context($label_for_the_Procurement_Conditional_Rule_Context = null)
    {
        // validation for constraint: string
        if (!is_null($label_for_the_Procurement_Conditional_Rule_Context) && !is_string($label_for_the_Procurement_Conditional_Rule_Context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label_for_the_Procurement_Conditional_Rule_Context, true), gettype($label_for_the_Procurement_Conditional_Rule_Context)), __LINE__);
        }
        $this->Label_for_the_Procurement_Conditional_Rule_Context = $label_for_the_Procurement_Conditional_Rule_Context;
        return $this;
    }
    /**
     * Get Condition_Rule_Data value
     * @return \StructType\Condition_Rule_Data_WWSType[]|null
     */
    public function getCondition_Rule_Data()
    {
        return $this->Condition_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCondition_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCondition_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCondition_Rule_DataForArrayConstraintsFromSetCondition_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Condition_Rule_DataTypeCondition_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Condition_Rule_DataTypeCondition_Rule_DataItem instanceof \StructType\Condition_Rule_Data_WWSType) {
                $invalidValues[] = is_object($procurement_Condition_Rule_DataTypeCondition_Rule_DataItem) ? get_class($procurement_Condition_Rule_DataTypeCondition_Rule_DataItem) : sprintf('%s(%s)', gettype($procurement_Condition_Rule_DataTypeCondition_Rule_DataItem), var_export($procurement_Condition_Rule_DataTypeCondition_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Condition_Rule_Data property can only contain items of type \StructType\Condition_Rule_Data_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Condition_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_Rule_Data_WWSType[] $condition_Rule_Data
     * @return \StructType\Procurement_Condition_Rule_DataType
     */
    public function setCondition_Rule_Data(array $condition_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($condition_Rule_DataArrayErrorMessage = self::validateCondition_Rule_DataForArrayConstraintsFromSetCondition_Rule_Data($condition_Rule_Data))) {
            throw new \InvalidArgumentException($condition_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Condition_Rule_Data = $condition_Rule_Data;
        return $this;
    }
    /**
     * Add item to Condition_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_Rule_Data_WWSType $item
     * @return \StructType\Procurement_Condition_Rule_DataType
     */
    public function addToCondition_Rule_Data(\StructType\Condition_Rule_Data_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Condition_Rule_Data_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Condition_Rule_Data property can only contain items of type \StructType\Condition_Rule_Data_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Condition_Rule_Data[] = $item;
        return $this;
    }
}
