<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_Amortization_Schedule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: An element containing a set of installments.
 * @subpackage Structs
 */
class Prepaid_Spend_Amortization_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Schedule_ID
     * Meta information extracted from the WSDL
     * - documentation: The reference id of the prepaid spend amortization schedule. If this is entered, then the Supplier Invoice ID cannot.
     * - choice: Prepaid_Spend_Amortization_Schedule_ID | Supplier_Invoice_ID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prepaid_Spend_Amortization_Schedule_ID;
    /**
     * The Supplier_Invoice_ID
     * Meta information extracted from the WSDL
     * - documentation: The reference id of the supplier invoice this schedule is connected to. If this is entered than the Schedule ID cannot.
     * - choice: Prepaid_Spend_Amortization_Schedule_ID | Supplier_Invoice_ID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_ID;
    /**
     * The Prepaid_Spend_Amortization_Installment_Data
     * Meta information extracted from the WSDL
     * - documentation: The set of installments that make up this schedule.
     * - maxOccurs: unbounded
     * @var \StructType\Prepaid_Spend_Amortization_Installment_DataType[]
     */
    public $Prepaid_Spend_Amortization_Installment_Data;
    /**
     * Constructor method for Prepaid_Spend_Amortization_Schedule_DataType
     * @uses Prepaid_Spend_Amortization_Schedule_DataType::setPrepaid_Spend_Amortization_Schedule_ID()
     * @uses Prepaid_Spend_Amortization_Schedule_DataType::setSupplier_Invoice_ID()
     * @uses Prepaid_Spend_Amortization_Schedule_DataType::setPrepaid_Spend_Amortization_Installment_Data()
     * @param string $prepaid_Spend_Amortization_Schedule_ID
     * @param string $supplier_Invoice_ID
     * @param \StructType\Prepaid_Spend_Amortization_Installment_DataType[] $prepaid_Spend_Amortization_Installment_Data
     */
    public function __construct($prepaid_Spend_Amortization_Schedule_ID = null, $supplier_Invoice_ID = null, array $prepaid_Spend_Amortization_Installment_Data = array())
    {
        $this
            ->setPrepaid_Spend_Amortization_Schedule_ID($prepaid_Spend_Amortization_Schedule_ID)
            ->setSupplier_Invoice_ID($supplier_Invoice_ID)
            ->setPrepaid_Spend_Amortization_Installment_Data($prepaid_Spend_Amortization_Installment_Data);
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule_ID value
     * @return string|null
     */
    public function getPrepaid_Spend_Amortization_Schedule_ID()
    {
        return isset($this->Prepaid_Spend_Amortization_Schedule_ID) ? $this->Prepaid_Spend_Amortization_Schedule_ID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrepaid_Spend_Amortization_Schedule_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Schedule_ID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrepaid_Spend_Amortization_Schedule_IDForChoiceConstraintsFromSetPrepaid_Spend_Amortization_Schedule_ID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Invoice_ID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prepaid_Spend_Amortization_Schedule_ID can\'t be set as the property %s is already set. Only one property must be set among these properties: Prepaid_Spend_Amortization_Schedule_ID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule_ID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $prepaid_Spend_Amortization_Schedule_ID
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_DataType
     */
    public function setPrepaid_Spend_Amortization_Schedule_ID($prepaid_Spend_Amortization_Schedule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($prepaid_Spend_Amortization_Schedule_ID) && !is_string($prepaid_Spend_Amortization_Schedule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaid_Spend_Amortization_Schedule_ID, true), gettype($prepaid_Spend_Amortization_Schedule_ID)), __LINE__);
        }
        // validation for constraint: choice(Prepaid_Spend_Amortization_Schedule_ID, Supplier_Invoice_ID)
        if ('' !== ($prepaid_Spend_Amortization_Schedule_IDChoiceErrorMessage = self::validatePrepaid_Spend_Amortization_Schedule_IDForChoiceConstraintsFromSetPrepaid_Spend_Amortization_Schedule_ID($prepaid_Spend_Amortization_Schedule_ID))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_Schedule_IDChoiceErrorMessage, __LINE__);
        }
        if (is_null($prepaid_Spend_Amortization_Schedule_ID) || (is_array($prepaid_Spend_Amortization_Schedule_ID) && empty($prepaid_Spend_Amortization_Schedule_ID))) {
            unset($this->Prepaid_Spend_Amortization_Schedule_ID);
        } else {
            $this->Prepaid_Spend_Amortization_Schedule_ID = $prepaid_Spend_Amortization_Schedule_ID;
        }
        return $this;
    }
    /**
     * Get Supplier_Invoice_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_ID()
    {
        return isset($this->Supplier_Invoice_ID) ? $this->Supplier_Invoice_ID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Invoice_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_ID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Invoice_IDForChoiceConstraintsFromSetSupplier_Invoice_ID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Prepaid_Spend_Amortization_Schedule_ID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Invoice_ID can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Invoice_ID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Invoice_ID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $supplier_Invoice_ID
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_DataType
     */
    public function setSupplier_Invoice_ID($supplier_Invoice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_ID) && !is_string($supplier_Invoice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_ID, true), gettype($supplier_Invoice_ID)), __LINE__);
        }
        // validation for constraint: choice(Prepaid_Spend_Amortization_Schedule_ID, Supplier_Invoice_ID)
        if ('' !== ($supplier_Invoice_IDChoiceErrorMessage = self::validateSupplier_Invoice_IDForChoiceConstraintsFromSetSupplier_Invoice_ID($supplier_Invoice_ID))) {
            throw new \InvalidArgumentException($supplier_Invoice_IDChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Invoice_ID) || (is_array($supplier_Invoice_ID) && empty($supplier_Invoice_ID))) {
            unset($this->Supplier_Invoice_ID);
        } else {
            $this->Supplier_Invoice_ID = $supplier_Invoice_ID;
        }
        return $this;
    }
    /**
     * Get Prepaid_Spend_Amortization_Installment_Data value
     * @return \StructType\Prepaid_Spend_Amortization_Installment_DataType[]|null
     */
    public function getPrepaid_Spend_Amortization_Installment_Data()
    {
        return $this->Prepaid_Spend_Amortization_Installment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Spend_Amortization_Installment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Installment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Spend_Amortization_Installment_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Installment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepaid_Spend_Amortization_Schedule_DataTypePrepaid_Spend_Amortization_Installment_DataItem) {
            // validation for constraint: itemType
            if (!$prepaid_Spend_Amortization_Schedule_DataTypePrepaid_Spend_Amortization_Installment_DataItem instanceof \StructType\Prepaid_Spend_Amortization_Installment_DataType) {
                $invalidValues[] = is_object($prepaid_Spend_Amortization_Schedule_DataTypePrepaid_Spend_Amortization_Installment_DataItem) ? get_class($prepaid_Spend_Amortization_Schedule_DataTypePrepaid_Spend_Amortization_Installment_DataItem) : sprintf('%s(%s)', gettype($prepaid_Spend_Amortization_Schedule_DataTypePrepaid_Spend_Amortization_Installment_DataItem), var_export($prepaid_Spend_Amortization_Schedule_DataTypePrepaid_Spend_Amortization_Installment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Spend_Amortization_Installment_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_Installment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Installment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_Installment_DataType[] $prepaid_Spend_Amortization_Installment_Data
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_DataType
     */
    public function setPrepaid_Spend_Amortization_Installment_Data(array $prepaid_Spend_Amortization_Installment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Spend_Amortization_Installment_DataArrayErrorMessage = self::validatePrepaid_Spend_Amortization_Installment_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Installment_Data($prepaid_Spend_Amortization_Installment_Data))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_Installment_DataArrayErrorMessage, __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Installment_Data = $prepaid_Spend_Amortization_Installment_Data;
        return $this;
    }
    /**
     * Add item to Prepaid_Spend_Amortization_Installment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_Installment_DataType $item
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_DataType
     */
    public function addToPrepaid_Spend_Amortization_Installment_Data(\StructType\Prepaid_Spend_Amortization_Installment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prepaid_Spend_Amortization_Installment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Spend_Amortization_Installment_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_Installment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Installment_Data[] = $item;
        return $this;
    }
}
