<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_Amortization_ScheduleType StructType
 * Meta information extracted from the WSDL
 * - documentation: One schedule that was found along with the installments.
 * @subpackage Structs
 */
class Prepaid_Spend_Amortization_ScheduleType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Schedule_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference of this schedule.
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_ScheduleObjectType
     */
    public $Prepaid_Spend_Amortization_Schedule_Reference;
    /**
     * The Prepaid_Spend_Amortization_Schedule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_Schedule_DataType[]
     */
    public $Prepaid_Spend_Amortization_Schedule_Data;
    /**
     * Constructor method for Prepaid_Spend_Amortization_ScheduleType
     * @uses Prepaid_Spend_Amortization_ScheduleType::setPrepaid_Spend_Amortization_Schedule_Reference()
     * @uses Prepaid_Spend_Amortization_ScheduleType::setPrepaid_Spend_Amortization_Schedule_Data()
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference
     * @param \StructType\Prepaid_Spend_Amortization_Schedule_DataType[] $prepaid_Spend_Amortization_Schedule_Data
     */
    public function __construct(\StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference = null, array $prepaid_Spend_Amortization_Schedule_Data = array())
    {
        $this
            ->setPrepaid_Spend_Amortization_Schedule_Reference($prepaid_Spend_Amortization_Schedule_Reference)
            ->setPrepaid_Spend_Amortization_Schedule_Data($prepaid_Spend_Amortization_Schedule_Data);
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule_Reference value
     * @return \StructType\Prepaid_Spend_Amortization_ScheduleObjectType|null
     */
    public function getPrepaid_Spend_Amortization_Schedule_Reference()
    {
        return $this->Prepaid_Spend_Amortization_Schedule_Reference;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule_Reference value
     * @param \StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference
     * @return \StructType\Prepaid_Spend_Amortization_ScheduleType
     */
    public function setPrepaid_Spend_Amortization_Schedule_Reference(\StructType\Prepaid_Spend_Amortization_ScheduleObjectType $prepaid_Spend_Amortization_Schedule_Reference = null)
    {
        $this->Prepaid_Spend_Amortization_Schedule_Reference = $prepaid_Spend_Amortization_Schedule_Reference;
        return $this;
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule_Data value
     * @return \StructType\Prepaid_Spend_Amortization_Schedule_DataType[]|null
     */
    public function getPrepaid_Spend_Amortization_Schedule_Data()
    {
        return $this->Prepaid_Spend_Amortization_Schedule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Spend_Amortization_Schedule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Schedule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Spend_Amortization_Schedule_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Schedule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepaid_Spend_Amortization_ScheduleTypePrepaid_Spend_Amortization_Schedule_DataItem) {
            // validation for constraint: itemType
            if (!$prepaid_Spend_Amortization_ScheduleTypePrepaid_Spend_Amortization_Schedule_DataItem instanceof \StructType\Prepaid_Spend_Amortization_Schedule_DataType) {
                $invalidValues[] = is_object($prepaid_Spend_Amortization_ScheduleTypePrepaid_Spend_Amortization_Schedule_DataItem) ? get_class($prepaid_Spend_Amortization_ScheduleTypePrepaid_Spend_Amortization_Schedule_DataItem) : sprintf('%s(%s)', gettype($prepaid_Spend_Amortization_ScheduleTypePrepaid_Spend_Amortization_Schedule_DataItem), var_export($prepaid_Spend_Amortization_ScheduleTypePrepaid_Spend_Amortization_Schedule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Spend_Amortization_Schedule_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_Schedule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_Schedule_DataType[] $prepaid_Spend_Amortization_Schedule_Data
     * @return \StructType\Prepaid_Spend_Amortization_ScheduleType
     */
    public function setPrepaid_Spend_Amortization_Schedule_Data(array $prepaid_Spend_Amortization_Schedule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Spend_Amortization_Schedule_DataArrayErrorMessage = self::validatePrepaid_Spend_Amortization_Schedule_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Schedule_Data($prepaid_Spend_Amortization_Schedule_Data))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_Schedule_DataArrayErrorMessage, __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Schedule_Data = $prepaid_Spend_Amortization_Schedule_Data;
        return $this;
    }
    /**
     * Add item to Prepaid_Spend_Amortization_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_Schedule_DataType $item
     * @return \StructType\Prepaid_Spend_Amortization_ScheduleType
     */
    public function addToPrepaid_Spend_Amortization_Schedule_Data(\StructType\Prepaid_Spend_Amortization_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prepaid_Spend_Amortization_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Spend_Amortization_Schedule_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_Schedule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Schedule_Data[] = $item;
        return $this;
    }
}
